/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.queries.CollocationQueryImplementation;
import org.openide.util.NbBundle;

public class MercurialVCS
extends VersioningSystem
implements PropertyChangeListener,
PreferenceChangeListener {
    private Set<File> knownRoots = Collections.synchronizedSet(new HashSet());
    private final Set<File> unversionedParents = Collections.synchronizedSet(new HashSet(20));
    private final CollocationQueryImplementation collocationQueryImplementation = new CollocationQueryImplementation(){

        public boolean areCollocated(File file, File file2) {
            File file3 = MercurialVCS.this.getTopmostManagedAncestor(file);
            File file4 = MercurialVCS.this.getTopmostManagedAncestor(file2);
            return file3 != null && file3.equals(file4);
        }

        public File findRoot(File file) {
            return MercurialVCS.this.getTopmostManagedAncestor(file);
        }
    };

    public MercurialVCS() {
        this.putProperty("String VCS.DisplayName", NbBundle.getMessage(MercurialVCS.class, (String)"CTL_Mercurial_DisplayName"));
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(MercurialVCS.class, (String)"CTL_Mercurial_MainMenu"));
        HgModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public CollocationQueryImplementation getCollocationQueryImplementation() {
        return this.collocationQueryImplementation;
    }

    public File getTopmostManagedAncestor(File file) {
        long l = System.currentTimeMillis();
        Mercurial.LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        if (this.unversionedParents.contains(file)) {
            Mercurial.LOG.fine(" cached as unversioned");
            return null;
        }
        Mercurial.LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        File file2 = this.getKnownParent(file);
        if (file2 != null) {
            Mercurial.LOG.log(Level.FINE, "  getTopmostManagedParent returning known parent " + file2);
            return file2;
        }
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            while (file != null) {
                if (HgUtils.isAdministrative(file)) {
                    file = file.getParentFile();
                    break;
                }
                file = file.getParentFile();
            }
        }
        HashSet<File> hashSet = new HashSet<File>();
        File file3 = null;
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                Mercurial.LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (Utils.isScanForbidden((File)file)) break;
            if (HgUtils.hgExistsFor(file)) {
                Mercurial.LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                hashSet.clear();
                file3 = file;
            } else {
                Mercurial.LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                if (file.exists()) {
                    hashSet.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (hashSet.size() > 0) {
            Mercurial.LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(hashSet);
        }
        if (Mercurial.LOG.isLoggable(Level.FINE)) {
            Mercurial.LOG.log(Level.FINE, " getTopmostManagedParent returns {0} after {1} millis", new Object[]{file3, System.currentTimeMillis() - l});
        }
        if (file3 != null) {
            this.knownRoots.add(file3);
        }
        return file3;
    }

    private File getKnownParent(File file) {
        File[] fileArray = this.knownRoots.toArray(new File[this.knownRoots.size()]);
        File file2 = null;
        for (File file3 : fileArray) {
            if (!Utils.isAncestorOrEqual((File)file3, (File)file) || file2 != null && !Utils.isAncestorOrEqual((File)file2, (File)file3)) continue;
            file2 = file3;
        }
        return file2;
    }

    public VCSAnnotator getVCSAnnotator() {
        return Mercurial.getInstance().getMercurialAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return Mercurial.getInstance().getMercurialInterceptor();
    }

    public void getOriginalFile(File file, File file2) {
        Mercurial.getInstance().getOriginalFile(file, file2);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("status.changed")) {
            FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)propertyChangeEvent.getNewValue();
            this.fireStatusChanged(changedEvent.getFile());
        } else if (propertyChangeEvent.getPropertyName().equals("annotationsChanged")) {
            this.fireAnnotationsChanged((Set)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("versionedFilesChanged")) {
            Mercurial.LOG.fine("cleaning unversioned parents cache");
            this.unversionedParents.clear();
            this.fireVersionedFilesChanged();
        } else if (propertyChangeEvent.getPropertyName().equals("event.badgeChanged")) {
            this.fireStatusChanged((Set)propertyChangeEvent.getNewValue());
        }
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        }
    }
}

