/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatusCacheNewGeneration
extends FileStatusCache {
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(2, false);
    private static final FileInformation FILE_INFORMATION_UPTODATE = new FileInformation(8, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(1, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED_DIRECTORY = new FileInformation(1, true);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(0, false);
    private static final FileInformation FILE_INFORMATION_NEWLOCALLY = new FileInformation(4, false);
    private int MAX_COUNT_UPTODATE_FILES = 1024;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.mercurial.fileStatusCacheNewGeneration");
    private static final Logger LOG_UPTODATE_FILES = Logger.getLogger("mercurial.cache.upToDateFiles");
    private PropertyChangeSupport listenerSupport = new PropertyChangeSupport(this);
    private Mercurial hg;
    private final Map<File, FileInformation> cachedFiles;
    private final LinkedHashSet<File> upToDateFiles = new LinkedHashSet(this.MAX_COUNT_UPTODATE_FILES);
    private final RequestProcessor rp = new RequestProcessor("Mercurial.cacheNG", 1, true);
    private final HashSet<File> nestedRepositories = new HashSet(2);
    int upToDateAccess = 0;
    private static final int UTD_NOTIFY_NUMBER = 100;

    FileStatusCacheNewGeneration() {
        this.hg = Mercurial.getInstance();
        this.cachedFiles = new HashMap<File, FileInformation>();
    }

    private void handleIgnoredFiles(final Set<File> set) {
        Runnable runnable = new Runnable(){

            public void run() {
                for (File file : set) {
                    if (!HgUtils.isIgnored(file, true)) continue;
                    boolean bl = file.isDirectory();
                    boolean bl2 = file.exists();
                    if (!bl2) {
                        FileStatusCacheNewGeneration.this.refreshFileStatus(file, FILE_INFORMATION_UNKNOWN, Collections.EMPTY_MAP, true);
                        continue;
                    }
                    FileStatusCacheNewGeneration.this.refreshFileStatus(file, bl ? new FileInformation(2, true) : FILE_INFORMATION_EXCLUDED, Collections.EMPTY_MAP, true);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            this.rp.post(runnable);
        } else {
            runnable.run();
        }
    }

    private FileInformation checkForIgnoredFile(File file) {
        FileInformation fileInformation = null;
        if (HgUtils.isIgnored(file, false)) {
            fileInformation = FILE_INFORMATION_EXCLUDED;
        } else {
            this.handleIgnoredFiles(Collections.singleton(file));
        }
        return fileInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInformation getInfo(File file) {
        FileInformation fileInformation = null;
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            fileInformation = this.cachedFiles.get(file);
            LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
            synchronized (linkedHashSet) {
                if (fileInformation == null && this.upToDateFiles.contains(file)) {
                    this.addUpToDate(file);
                    fileInformation = FILE_INFORMATION_UPTODATE;
                }
            }
        }
        return fileInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInfo(File file, FileInformation fileInformation) {
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            this.cachedFiles.put(file, fileInformation);
            this.removeUpToDate(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInfo(File file) {
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            this.cachedFiles.remove(file);
            this.removeUpToDate(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpToDate(File file) {
        LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
        synchronized (linkedHashSet) {
            this.upToDateFiles.remove(file);
            this.upToDateFiles.add(file);
            if (this.upToDateFiles.size() >= this.MAX_COUNT_UPTODATE_FILES) {
                if (LOG_UPTODATE_FILES.isLoggable(Level.FINE)) {
                    LOG_UPTODATE_FILES.log(Level.WARNING, "Cache of uptodate files grows too quickly: {0}", this.upToDateFiles.size());
                    this.MAX_COUNT_UPTODATE_FILES <<= 1;
                    assert (false);
                } else {
                    Iterator iterator = this.upToDateFiles.iterator();
                    int n = this.MAX_COUNT_UPTODATE_FILES >> 3;
                    for (int i = 0; i < n && iterator.hasNext(); ++i) {
                        iterator.next();
                        iterator.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeUpToDate(File file) {
        LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
        synchronized (linkedHashSet) {
            return this.upToDateFiles.remove(file);
        }
    }

    @Override
    public FileInformation getStatus(File file) {
        FileInformation fileInformation = this.getInfo(file);
        if (fileInformation == null) {
            boolean bl;
            boolean bl2 = HgUtils.isAdministrative(file);
            boolean bl3 = bl = bl2 || file.isDirectory();
            if (bl && (bl2 || HgUtils.isIgnored(file))) {
                return new FileInformation(2, true);
            }
            fileInformation = !bl && !this.exists(file) ? FILE_INFORMATION_UNKNOWN : (!bl && HgUtils.isIgnored(file) ? FILE_INFORMATION_EXCLUDED : (bl ? this.refresh(file, REPOSITORY_STATUS_UNKNOWN) : FILE_INFORMATION_UPTODATE));
        }
        return fileInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInformation getCachedStatus(final File file) {
        FileInformation fileInformation = this.getInfo(file);
        LOG.log(Level.FINER, "getCachedStatus for file {0}: {1}", new Object[]{file, fileInformation});
        if (fileInformation == null) {
            if (this.hg.isManaged(file)) {
                this.hg.getMercurialInterceptor().pingRepositoryRootFor(file);
                fileInformation = this.checkForIgnoredFile(file);
                if (file.isDirectory()) {
                    fileInformation = this.createFolderFileInformation(file, fileInformation == null ? null : new FileInformation(2, true));
                } else if (fileInformation == null) {
                    fileInformation = FILE_INFORMATION_UPTODATE;
                    this.addUpToDate(file);
                    if (++this.upToDateAccess > 100) {
                        this.upToDateAccess = 0;
                        if (LOG_UPTODATE_FILES.isLoggable(Level.FINE)) {
                            LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
                            synchronized (linkedHashSet) {
                                LOG_UPTODATE_FILES.log(Level.FINE, "Another {0} U2D files added: {1}", new Object[]{new Integer(100), this.upToDateFiles});
                            }
                        }
                    }
                } else {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            FileStatusCacheNewGeneration.this.refreshFileStatus(file, FILE_INFORMATION_EXCLUDED, Collections.EMPTY_MAP, false);
                        }
                    });
                }
            } else {
                fileInformation = file.isDirectory() ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_NOTMANAGED;
            }
            LOG.log(Level.FINER, "getCachedStatus: default for file {0}: {1}", new Object[]{file, fileInformation});
        }
        return fileInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInformation createFolderFileInformation(File file, FileInformation fileInformation) {
        FileInformation fileInformation2;
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            fileInformation2 = this.getInfo(file);
            if (fileInformation2 == null || !fileInformation2.isDirectory()) {
                fileInformation2 = fileInformation == null ? new FileInformation(8, true) : fileInformation;
                this.setInfo(file, fileInformation2);
            }
        }
        return fileInformation2;
    }

    @Override
    @Deprecated
    public Map<File, FileInformation> getScannedFiles(File file, Map<File, FileInformation> map) {
        this.getStatus(file);
        return null;
    }

    @Override
    Map<File, FileInformation> getAllModifiedFiles() {
        return Collections.emptyMap();
    }

    private Map<File, FileInformation> getModifiedFiles(File file, int n) {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>();
        FileInformation fileInformation = this.getCachedStatus(file);
        if ((fileInformation.getStatus() & n) != 0) {
            hashMap.put(file, fileInformation);
        }
        for (File file2 : fileInformation.getModifiedChildren(false)) {
            if (bl) {
                this.checkIsParentOf(file, file2);
            }
            hashMap.putAll(this.getModifiedFiles(file2, n));
        }
        return hashMap;
    }

    @Override
    public void refreshAllRoots(Map<File, Set<File>> map) {
        for (Map.Entry<File, Set<File>> entry : map.entrySet()) {
            File file = entry.getKey();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "refreshAllRoots() roots: {0}, repositoryRoot: {1} ", new Object[]{entry.getValue(), file.getAbsolutePath()});
            }
            try {
                Map<File, FileInformation> map2 = HgCommand.getInterestingStatus(file, new LinkedList<File>((Collection)entry.getValue()));
                for (Map.Entry<File, FileInformation> entry2 : map2.entrySet()) {
                    File file2 = entry2.getKey();
                    FileInformation fileInformation = entry2.getValue();
                    LOG.log(Level.FINE, "refreshAllRoots() file: {0} {1} ", new Object[]{file2.getAbsolutePath(), fileInformation});
                    this.refreshFileStatus(file2, fileInformation, map2);
                }
                for (File file3 : entry.getValue()) {
                    for (Map.Entry entry3 : this.getModifiedFiles(file3, -9).entrySet()) {
                        File file4 = (File)entry3.getKey();
                        FileInformation fileInformation = (FileInformation)entry3.getValue();
                        boolean bl = file4.exists();
                        File file5 = null;
                        boolean bl2 = true;
                        if (!map2.containsKey(file4) && ((fileInformation.getStatus() & 2) != 0 && !bl || (fileInformation.getStatus() & 2) == 0 && (!bl || file4.isFile())) && (bl2 = file.equals(file5 = this.hg.getRepositoryRoot(file4)))) {
                            LOG.log(Level.FINE, "refreshAllRoots() uninteresting file: {0} {1}", new Object[]{file4, fileInformation});
                            if (HgCommand.existsConflictFile(file4.getAbsolutePath())) {
                                this.refreshFileStatus(file4, FILE_INFORMATION_CONFLICT, map2);
                            } else {
                                this.refreshFileStatus(file4, FILE_INFORMATION_UNKNOWN, map2);
                            }
                        }
                        if (bl2 || !this.nestedRepositories.add(file5)) continue;
                        LOG.log(Level.INFO, "refreshAllRoots: nested repository found: {0} contains {1}", new File[]{file, file5});
                    }
                }
            }
            catch (HgException hgException) {
                LOG.log(Level.INFO, "refreshAll() file: {0} {1} {2} ", new Object[]{file.getAbsolutePath(), entry.getValue(), hgException.toString()});
            }
        }
    }

    @Override
    public FileInformation refresh(File file, FileStatus fileStatus) {
        FileInformation fileInformation;
        File file2 = this.hg.getRepositoryRoot(file);
        if (file2 == null) {
            fileInformation = file.isDirectory() ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_NOTMANAGED;
        } else {
            this.refreshAllRoots(Collections.singletonMap(file2, Collections.singleton(file)));
            fileInformation = this.getCachedStatus(file);
        }
        return fileInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshFileStatus(File file, FileInformation fileInformation, Map<File, FileInformation> map, boolean bl) {
        FileInformation fileInformation2;
        if (file == null || fileInformation == null) {
            return;
        }
        FileStatusCacheNewGeneration fileStatusCacheNewGeneration = this;
        synchronized (fileStatusCacheNewGeneration) {
            if (FileStatusCacheNewGeneration.equivalent(FILE_INFORMATION_NEWLOCALLY, fileInformation) && (HgUtils.isIgnored(file) || (this.getCachedStatus(file.getParentFile()).getStatus() & 2) != 0)) {
                LOG.log(Level.FINE, "refreshFileStatus() file: {0} was LocallyNew but is NotSharable", file.getAbsolutePath());
                FileInformation fileInformation3 = fileInformation = file.isDirectory() ? new FileInformation(2, true) : FILE_INFORMATION_EXCLUDED;
            }
            if (FileStatusCacheNewGeneration.equivalent(fileInformation, fileInformation2 = this.getInfo(file = FileUtil.normalizeFile((File)file)))) {
                return;
            }
            if (fileInformation.getStatus() == 0) {
                this.removeInfo(file);
            } else if (fileInformation.getStatus() == 8 && file.isFile()) {
                this.removeInfo(file);
                this.addUpToDate(file);
            } else {
                this.setInfo(file, fileInformation);
            }
            this.updateParentInformation(file, fileInformation2, fileInformation);
        }
        this.fireFileStatusChanged(file, fileInformation2, fileInformation);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void updateParentInformation(File file, FileInformation fileInformation, FileInformation fileInformation2) {
        FileInformation fileInformation3;
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        File file2 = file;
        File file3 = file;
        while ((file2 = file2.getParentFile()) != null && (fileInformation3 = this.getCachedStatus(file2)) != null && (fileInformation3.getStatus() & 0xFFFFFFFE) != 0) {
            if (!fileInformation3.isDirectory()) {
                fileInformation3 = this.createFolderFileInformation(file2, null);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "updateParentInformation: updating {0} with {1} triggered by {2}", new Object[]{file2, fileInformation2, file});
            }
            if (bl) {
                this.checkIsParentOf(file2, file3);
                if (fileInformation3 == FILE_INFORMATION_EXCLUDED || fileInformation3 == FILE_INFORMATION_UPTODATE || fileInformation3 == FILE_INFORMATION_NOTMANAGED || fileInformation3 == FILE_INFORMATION_NOTMANAGED_DIRECTORY || fileInformation3 == FILE_INFORMATION_UNKNOWN || fileInformation3 == FILE_INFORMATION_NEWLOCALLY) {
                    throw new IllegalStateException("Wrong info, expected an own instance for " + file2 + ", " + fileInformation3.getStatusText() + " - " + fileInformation3.getStatus());
                }
            }
            if (!fileInformation3.setModifiedChild(file3, fileInformation2)) break;
            file3 = file2;
        }
    }

    private void fireFileStatusChanged(File file, FileInformation fileInformation, FileInformation fileInformation2) {
        this.listenerSupport.firePropertyChange("status.changed", null, new FileStatusCache.ChangedEvent(file, fileInformation, fileInformation2));
    }

    private boolean exists(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.getAbsolutePath().equals(FileUtil.normalizeFile((File)file).getAbsolutePath());
    }

    private static boolean equivalent(FileInformation fileInformation, FileInformation fileInformation2) {
        FileStatus fileStatus;
        if (fileInformation2 == null || fileInformation.getStatus() != fileInformation2.getStatus() || fileInformation.isDirectory() != fileInformation2.isDirectory()) {
            return false;
        }
        FileStatus fileStatus2 = fileInformation.getStatus(null);
        return fileStatus2 == (fileStatus = fileInformation2.getStatus(null)) || fileStatus2 == null || fileStatus == null || FileStatusCacheNewGeneration.equal(fileStatus2, fileStatus);
    }

    private static boolean equal(FileStatus fileStatus, FileStatus fileStatus2) {
        return true;
    }

    @Override
    public File[] listFiles(File file) {
        HashSet<File> hashSet = this.getStatus(file).getModifiedChildren(false);
        return hashSet.toArray(new File[hashSet.size()]);
    }

    @Override
    public boolean containsFileOfStatus(VCSContext vCSContext, int n, boolean bl, boolean bl2) {
        Set set = vCSContext.getRootFiles();
        for (File file : set) {
            if (!this.hasStatus(file, n, bl) && !this.containsFileOfStatus(file, n, bl, !VersioningSupport.isFlat((File)file))) continue;
            return true;
        }
        return false;
    }

    private boolean containsFileOfStatus(File file, int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (!$assertionsDisabled) {
            bl3 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        FileInformation fileInformation = this.getCachedStatus(file);
        for (File file2 : fileInformation.getModifiedChildren(n == 64)) {
            if (bl3) {
                this.checkIsParentOf(file, file2);
            }
            if (this.hasStatus(file2, n, bl)) {
                return true;
            }
            if (!bl2 || !this.containsFileOfStatus(file2, n, bl, bl2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasStatus(File file, int n, boolean bl) {
        FileInformation fileInformation = this.getCachedStatus(file);
        return (fileInformation.getStatus() & n) != 0 && (!bl || !HgModuleConfig.getDefault().isExcludedFromCommit(file.getAbsolutePath()));
    }

    @Override
    public File[] listFiles(VCSContext vCSContext, int n) {
        Set set = vCSContext.getRootFiles();
        Set<File> set2 = this.listFilesIntern(set.toArray(new File[set.size()]), n);
        for (File file : vCSContext.getExclusions()) {
            Iterator<File> iterator = set2.iterator();
            while (iterator.hasNext()) {
                File file2 = iterator.next();
                if (!Utils.isAncestorOrEqual((File)file, (File)file2)) continue;
                iterator.remove();
            }
        }
        return set2.toArray(new File[set2.size()]);
    }

    @Override
    public File[] listFiles(File[] fileArray, int n) {
        Set<File> set = this.listFilesIntern(fileArray, n);
        return set.toArray(new File[set.size()]);
    }

    private Set<File> listFilesIntern(File[] fileArray, int n) {
        HashSet<File> hashSet = new HashSet<File>();
        for (File file : fileArray) {
            if (VersioningSupport.isFlat((File)file)) {
                for (File file2 : this.listFiles(file)) {
                    if ((this.getCachedStatus(file2).getStatus() & n) == 0) continue;
                    hashSet.add(file2);
                }
                continue;
            }
            Map<File, FileInformation> map = this.getModifiedFiles(file, n);
            for (File file3 : map.keySet()) {
                hashSet.add(file3);
            }
        }
        return hashSet;
    }

    @Override
    public void refreshFileStatus(File file, FileInformation fileInformation, Map<File, FileInformation> map) {
        this.refreshFileStatus(file, fileInformation, map, false);
    }

    @Override
    public void refreshAll(File file) {
    }

    @Override
    public void refreshCached(File file) {
        this.refreshAllRoots(Collections.singletonMap(this.hg.getRepositoryRoot(file), Collections.singleton(file)));
    }

    @Override
    public void refreshCached(VCSContext vCSContext) {
        for (File file : vCSContext.getRootFiles()) {
            this.refreshCached(file);
        }
    }

    @Override
    public void addToCache(Set<File> set) {
        if (set.size() > 0) {
            this.hg.getMercurialInterceptor().pingRepositoryRootFor(set.iterator().next());
        }
    }

    @Override
    public void notifyFileChanged(File file) {
        this.fireFileStatusChanged(file, null, FILE_INFORMATION_UPTODATE);
    }

    private void checkIsParentOf(File file, File file2) {
        if (!file.equals(file2.getParentFile())) {
            throw new IllegalStateException(file.getAbsolutePath() + " is not parent of " + file2.getAbsolutePath());
        }
    }
}

