/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.ITask;

public abstract class AutomaticRepositoryTaskContainer
extends AbstractTaskCategory {
    protected String repositoryUrl;
    private final String connectorKind;

    public AutomaticRepositoryTaskContainer(String handleAndDescription, String connectorKind, String repositoryUrl) {
        super(handleAndDescription);
        this.connectorKind = connectorKind;
        this.repositoryUrl = repositoryUrl;
    }

    public abstract String getSummaryLabel();

    protected abstract String getHandleSuffix();

    public String getSummary() {
        return String.valueOf(this.getSummaryLabel()) + " [" + this.getRepositoryUrl() + "]";
    }

    public boolean isUserManaged() {
        return false;
    }

    public String getConnectorKind() {
        return this.connectorKind;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getPriority() {
        return ITask.PriorityLevel.P1.toString();
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        this.setHandleIdentifier(String.valueOf(repositoryUrl) + "-" + this.getHandleSuffix());
    }
}

