/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class InstallationSettingsPanel
extends JPanel {
    private final String LATEST = NbBundle.getMessage(InstallationSettingsPanel.class, (String)"Latest");
    private ButtonGroup dependencyGroup;
    private JLabel depsLbl;
    private JRadioButton excludeToggle;
    private JRadioButton includeToggle;
    private JLabel messageLabel;
    private JTextField nameField;
    private JLabel nameLbl;
    private JComboBox versionCombo;
    private JLabel versionLbl;

    public InstallationSettingsPanel(Gem gem) {
        this.initComponents();
        this.nameField.setText(gem.getName());
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(this.LATEST);
        for (String string : gem.getAvailableVersions()) {
            defaultComboBoxModel.addElement(string);
        }
        this.versionCombo.setModel(defaultComboBoxModel);
    }

    public void setMessage(String string) {
        this.messageLabel.setText(string);
    }

    public boolean getIncludeDepencies() {
        return this.includeToggle.isSelected();
    }

    public String getVersion() {
        String string = this.versionCombo.getSelectedItem().toString().trim();
        if (string == this.LATEST) {
            return null;
        }
        return string;
    }

    public String getGemName() {
        return this.nameField.getText().trim();
    }

    private void initComponents() {
        this.dependencyGroup = new ButtonGroup();
        this.nameLbl = new JLabel();
        this.nameField = new JTextField();
        this.versionLbl = new JLabel();
        this.versionCombo = new JComboBox();
        this.depsLbl = new JLabel();
        this.includeToggle = new JRadioButton();
        this.excludeToggle = new JRadioButton();
        this.messageLabel = new JLabel();
        this.nameLbl.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.nameLbl, (String)NbBundle.getMessage(InstallationSettingsPanel.class, (String)"InstallationSettingsPanel.nameLbl.text"));
        this.versionLbl.setLabelFor(this.versionCombo);
        Mnemonics.setLocalizedText((JLabel)this.versionLbl, (String)NbBundle.getMessage(InstallationSettingsPanel.class, (String)"InstallationSettingsPanel.versionLbl.text"));
        Mnemonics.setLocalizedText((JLabel)this.depsLbl, (String)NbBundle.getMessage(InstallationSettingsPanel.class, (String)"InstallationSettingsPanel.depsLbl.text"));
        this.dependencyGroup.add(this.includeToggle);
        this.includeToggle.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.includeToggle, (String)NbBundle.getMessage(InstallationSettingsPanel.class, (String)"InstallationSettingsPanel.includeToggle.text"));
        this.includeToggle.setMargin(new Insets(0, 0, 0, 0));
        this.dependencyGroup.add(this.excludeToggle);
        Mnemonics.setLocalizedText((AbstractButton)this.excludeToggle, (String)NbBundle.getMessage(InstallationSettingsPanel.class, (String)"InstallationSettingsPanel.excludeToggle.text"));
        this.excludeToggle.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.nameLbl).add((Component)this.versionLbl).add((Component)this.depsLbl)).add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.includeToggle).addPreferredGap(0).add((Component)this.excludeToggle)).add((Component)this.versionCombo, -2, -1, -2).add((Component)this.nameField, -1, 125, Short.MAX_VALUE))).add((Component)this.messageLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLbl).add((Component)this.nameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.versionLbl).add((Component)this.versionCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.depsLbl).add((Component)this.includeToggle).add((Component)this.excludeToggle)).addPreferredGap(0).add((Component)this.messageLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.nameLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallationSettingsPanel.class, (String)"InstallationSettingsPanel.nameLbl.AccessibleContext.accessibleDescription"));
        this.nameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallationSettingsPanel.class, (String)"InstallationSettingsPanel.nameField.AccessibleContext.accessibleDescription"));
        this.versionLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallationSettingsPanel.class, (String)"InstallationSettingsPanel.versionLbl.AccessibleContext.accessibleDescription"));
        this.versionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallationSettingsPanel.class, (String)"InstallationSettingsPanel.versionCombo.AccessibleContext.accessibleDescription"));
        this.includeToggle.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallationSettingsPanel.class, (String)"InstallationSettingsPanel.includeToggle.AccessibleContext.accessibleDescription"));
        this.excludeToggle.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallationSettingsPanel.class, (String)"InstallationSettingsPanel.excludeToggle.AccessibleContext.accessibleDescription"));
    }
}

