/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.netbeans.modules.ruby.platform.gems.GemFilesParser;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.platform.gems.GemInstallInfo;
import org.netbeans.modules.ruby.platform.gems.GemListParser;
import org.netbeans.modules.ruby.platform.gems.GemPanel;
import org.netbeans.modules.ruby.platform.gems.GemRunner;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GemManager {
    private static final Logger LOGGER = Logger.getLogger(GemManager.class.getName());
    private static final String[] TOP_LEVEL_REPO_DIRS = new String[]{"cache", "specifications", "gems", "doc"};
    private static final String SPECIFICATIONS = "specifications";
    private static final boolean SKIP_INDEX_LIBS = System.getProperty("ruby.index.nolibs") != null;
    private static final boolean SKIP_INDEX_GEMS = System.getProperty("ruby.index.nogems") != null;
    private static final String DOT_GEM_SPEC = ".gemspec";
    private Map<String, List<GemInfo>> localGems;
    private Map<String, String> gemVersions;
    private Map<String, URL> gemUrls;
    private Set<URL> nonGemUrls;
    public static String TEST_GEM_HOME;
    private List<Gem> local;
    private List<Gem> remote;
    private String gemHomeUrl;
    private final RubyPlatform platform;
    private final Lock runnerLocalLock;
    private final Lock runnerRemoteLock;

    public GemManager(RubyPlatform rubyPlatform) {
        assert (rubyPlatform.hasRubyGemsInstalled()) : "called when RubyGems installed";
        this.platform = rubyPlatform;
        this.runnerLocalLock = new ReentrantLock(true);
        this.runnerRemoteLock = new ReentrantLock(true);
    }

    String getRubyGemsVersion() {
        return this.platform.getInfo().getGemVersion();
    }

    boolean hasAncientRubyGemsVersion() {
        return Util.compareVersions("1.0", this.getRubyGemsVersion()) > 0;
    }

    boolean hasOldRubyGemsVersion() {
        return Util.compareVersions("1.2", this.getRubyGemsVersion()) > 0;
    }

    boolean isGemHomeWritable() {
        return this.getGemHomeF().canWrite();
    }

    private boolean checkGemHomePermissions() {
        String string;
        if (!this.isGemHomeWritable() && (string = Util.findOnPath("gksu")) == null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(GemManager.class, (String)"GemManager.GemNotWritable", (Object)this.getGemHome()), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
            return false;
        }
        return true;
    }

    public static void initializeRepository(File file) throws IOException {
        if (!file.exists()) {
            file.mkdirs();
        }
        GemManager.initializeRepository(FileUtil.toFileObject((File)file));
    }

    public static void initializeRepository(FileObject fileObject) throws IOException {
        for (String string : TOP_LEVEL_REPO_DIRS) {
            fileObject.createFolder(string);
        }
    }

    public String getGemHome() {
        return this.platform.getInfo().getGemHome();
    }

    public File getGemHomeF() {
        return FileUtil.normalizeFile((File)new File(this.platform.getInfo().getGemHome()));
    }

    public FileObject getGemHomeFO() {
        return FileUtil.toFileObject((File)this.getGemHomeF());
    }

    public String getGemHomeUrl() {
        String string;
        if (this.gemHomeUrl == null && (string = this.getGemHome()) != null) {
            try {
                File file = new File(string);
                if (file != null) {
                    this.gemHomeUrl = file.toURI().toURL().toExternalForm();
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return this.gemHomeUrl;
    }

    public Set<? extends File> getRepositories() {
        Set<File> set = this.getGemPath();
        set.add(this.getGemHomeF());
        return set;
    }

    public Set<File> getGemPath() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.platform.getInfo().getGemPath(), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            linkedHashSet.add(new File(stringTokenizer.nextToken()));
        }
        return linkedHashSet;
    }

    public boolean addGemPath(File file) {
        boolean bl;
        Set<File> set = this.getGemPath();
        try {
            bl = set.add(file.getCanonicalFile());
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
            bl = false;
        }
        if (bl) {
            this.storeGemPath(set);
        }
        return bl;
    }

    public void removeGemPath(File file) {
        Set<File> set = this.getGemPath();
        set.remove(file);
        this.storeGemPath(set);
    }

    private void storeGemPath(Set<File> set) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : set) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(file.getAbsolutePath());
        }
        this.platform.getInfo().setGemPath(stringBuilder.toString());
        try {
            RubyPlatformManager.storePlatform(this.platform);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
        }
        this.resetLocal();
    }

    public boolean isGemInstalled(String string) {
        return !this.getVersions(string).isEmpty();
    }

    public boolean isGemInstalledForPlatform(String string, VersionPredicate versionPredicate) {
        for (GemInfo gemInfo : this.getVersions(string)) {
            String string2 = gemInfo.getSpecFile().getName();
            if (!this.platform.isJRuby() && string2.endsWith("-java.gemspec")) continue;
            if (string2.startsWith("ruby-debug-base-")) {
                boolean bl = string2.endsWith("-java.gemspec");
                if (this.platform.isJRuby() && !bl || !this.platform.isJRuby() && bl) continue;
            }
            if (!versionPredicate.isRight(gemInfo.getVersion())) continue;
            return true;
        }
        return false;
    }

    public boolean isGemInstalled(String string, String string2) {
        String string3 = this.getLatestVersion(string);
        return this.isRightVersion(string3, string2, false);
    }

    public boolean isGemInstalledForPlatform(String string, final String string2, final boolean bl) {
        VersionPredicate versionPredicate = new VersionPredicate(){

            public boolean isRight(String string) {
                return GemManager.this.isRightVersion(string, string2, bl);
            }
        };
        return this.isGemInstalledForPlatform(string, versionPredicate);
    }

    private boolean isRightVersion(String string, String string2, boolean bl) {
        boolean bl2 = false;
        if (string != null) {
            int n = Util.compareVersions(string2, string);
            bl2 = bl ? n == 0 : n <= 0;
        }
        return bl2;
    }

    public boolean isGemInstalledForPlatform(String string, String string2) {
        return this.isGemInstalledForPlatform(string, string2, false);
    }

    public String getLatestVersion(String string) {
        this.initGemList();
        List<GemInfo> list = this.getVersions(string);
        return list.isEmpty() ? null : list.get(0).getVersion();
    }

    public List<GemInfo> getVersions(String string) {
        this.initGemList();
        List<GemInfo> list = this.localGems.get(string);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    private void logGems(Level level) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        if (this.localGems == null) {
            LOGGER.log(level, "No gems found, gemFiles is null");
            return;
        }
        LOGGER.log(level, "Found " + this.localGems.size() + " gems.");
        for (String string : this.localGems.keySet()) {
            List<GemInfo> list = this.getVersions(string);
            LOGGER.log(level, string + " has " + list.size() + " version(s):");
            for (GemInfo gemInfo : list) {
                LOGGER.log(level, gemInfo + " at " + gemInfo.getSpecFile());
            }
        }
    }

    private void initGemList() {
        if (this.localGems == null) {
            assert (this.platform.hasRubyGemsInstalled()) : "asking for gems only when RubyGems are installed";
            this.localGems = new HashMap<String, List<GemInfo>>();
            for (File file : this.getRepositories()) {
                File file2 = new File(file, SPECIFICATIONS);
                if (file2.exists()) {
                    LOGGER.finer("Initializing \"" + file + "\" repository");
                    File[] fileArray = file2.listFiles();
                    if (fileArray != null) {
                        Map<String, List<GemInfo>> map = GemFilesParser.getGemInfos(fileArray);
                        for (Map.Entry<String, List<GemInfo>> entry : map.entrySet()) {
                            String string = entry.getKey();
                            List<GemInfo> list = entry.getValue();
                            List<GemInfo> list2 = this.localGems.get(string);
                            if (list2 != null) {
                                list2.addAll(list);
                                continue;
                            }
                            this.localGems.put(string, list);
                        }
                    }
                } else {
                    LOGGER.finer("Cannot find Gems repository. \"" + file + "\" does not exist or is not a directory.");
                }
                this.logGems(Level.FINEST);
            }
        }
    }

    public Set<String> getInstalledGemsFiles() {
        this.initGemList();
        return this.localGems.keySet();
    }

    public void reset() {
        this.resetRemote();
        this.resetLocal();
        this.gemHomeUrl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRemote() {
        if (this.runnerRemoteLock.tryLock()) {
            try {
                this.remote = null;
            }
            finally {
                this.runnerRemoteLock.unlock();
            }
        } else {
            LOGGER.finer("resetRemote() ignored");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLocal() {
        if (this.runnerLocalLock.tryLock()) {
            try {
                this.local = null;
                this.localGems = null;
                this.platform.fireGemsChanged();
            }
            finally {
                this.runnerLocalLock.unlock();
            }
        } else {
            LOGGER.finer("resetLocal() ignored");
        }
    }

    public List<Gem> getInstalledGems(List<? super String> list) {
        List<? super String> list2 = list;
        list2.addAll(this.reloadLocalIfNeeded());
        return this.getLocalGems();
    }

    public List<Gem> getRemoteGems(List<? super String> list) {
        List<? super String> list2 = list;
        list2.addAll(this.reloadRemoteIfNeeded());
        return this.getRemoteGems();
    }

    public List<Gem> getLocalGems() {
        return this.local != null ? this.local : Collections.emptyList();
    }

    public List<Gem> getRemoteGems() {
        return this.remote != null ? this.remote : Collections.emptyList();
    }

    boolean needsLocalReload() {
        return this.local == null;
    }

    boolean needsRemoteReload() {
        return this.remote == null;
    }

    boolean needsReload() {
        return this.needsLocalReload() || this.needsRemoteReload();
    }

    public void reloadIfNeeded(List<? super String> list) {
        assert (!EventQueue.isDispatchThread()) : "do not call from EDT!";
        if (!this.platform.checkAndReportRubyGemsProblems()) {
            return;
        }
        List<? super String> list2 = list;
        list2.addAll(this.reloadLocalIfNeeded());
        if (list.isEmpty()) {
            list2.addAll(this.reloadRemoteIfNeeded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> reloadLocalIfNeeded() {
        if (!this.platform.checkAndReportRubyGemsProblems()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.runnerLocalLock.lock();
        try {
            if (this.local == null) {
                GemRunner gemRunner = new GemRunner(this.platform);
                if (gemRunner.fetchLocal()) {
                    this.local = GemListParser.parseLocal(gemRunner.getOutput());
                    Collections.sort(this.local);
                } else {
                    ArrayList<String> arrayList2 = arrayList;
                    arrayList2.addAll(gemRunner.getOutput());
                }
            }
        }
        finally {
            this.runnerLocalLock.unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> reloadRemoteIfNeeded() {
        if (!this.platform.checkAndReportRubyGemsProblems()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.runnerRemoteLock.lock();
        try {
            if (this.remote == null) {
                GemRunner gemRunner = new GemRunner(this.platform);
                if (gemRunner.fetchRemote()) {
                    this.remote = GemListParser.parseRemote(gemRunner.getOutput());
                    Collections.sort(this.remote);
                } else {
                    arrayList.addAll(gemRunner.getOutput());
                }
            }
        }
        finally {
            this.runnerRemoteLock.unlock();
        }
        return arrayList;
    }

    public void installGem(String string, boolean bl, boolean bl2, String string2) {
        if (!this.checkGemHomePermissions()) {
            return;
        }
        Gem[] gemArray = new Gem[]{new Gem(string, null, null)};
        Runnable runnable = new Runnable(){

            public void run() {
                GemManager.this.platform.recomputeRoots();
            }
        };
        this.install(gemArray, null, bl, bl2, string2, true, true, runnable);
    }

    public void installGem(String string, boolean bl, boolean bl2) {
        this.installGem(string, bl, bl2, null);
    }

    public boolean install(Gem[] gemArray, Component component, boolean bl, boolean bl2, String string, boolean bl3, boolean bl4, Runnable runnable) {
        if (!this.checkGemHomePermissions()) {
            return false;
        }
        List<String> list = this.mapToGemNames(gemArray);
        GemRunner gemRunner = new GemRunner(this.platform);
        if (bl4) {
            gemRunner.installAsynchronously(list, bl, bl2, bl3, string, this.resetCompletionTask(runnable), component);
            return false;
        }
        boolean bl5 = gemRunner.install(list, bl, bl2, bl3, string);
        this.resetLocal();
        return bl5;
    }

    boolean installLocal(File file, GemPanel gemPanel, boolean bl, boolean bl2, boolean bl3, Runnable runnable) {
        if (!this.checkGemHomePermissions()) {
            return false;
        }
        GemRunner gemRunner = new GemRunner(this.platform);
        if (bl3) {
            gemRunner.installLocalAsynchronously(file, bl, bl2, this.resetCompletionTask(runnable), gemPanel);
            return false;
        }
        boolean bl4 = gemRunner.installLocal(file, bl, bl2);
        this.resetLocal();
        return bl4;
    }

    boolean uninstall(List<GemInstallInfo> list, Component component, boolean bl, Runnable runnable) {
        if (!this.checkGemHomePermissions()) {
            return false;
        }
        GemRunner gemRunner = new GemRunner(this.platform);
        if (bl) {
            gemRunner.uninstallAsynchronously(list, this.resetCompletionTask(runnable), component);
            return false;
        }
        boolean bl2 = gemRunner.uninstall(list);
        this.resetLocal();
        return bl2;
    }

    public boolean update(Gem[] gemArray, Component component, boolean bl, boolean bl2, boolean bl3, boolean bl4, Runnable runnable) {
        if (!this.checkGemHomePermissions()) {
            return false;
        }
        List<String> list = gemArray == null ? null : this.mapToGemNames(gemArray);
        GemRunner gemRunner = new GemRunner(this.platform);
        if (bl4) {
            gemRunner.updateAsynchronously(list, bl, bl2, bl3, this.resetCompletionTask(runnable), component);
            return false;
        }
        boolean bl5 = gemRunner.update(list, bl, bl2, bl3);
        this.resetLocal();
        return bl5;
    }

    public Set<URL> getNonGemLoadPath() {
        if (this.nonGemUrls == null) {
            this.initializeUrlMaps();
        }
        return this.nonGemUrls;
    }

    public Map<String, String> getGemVersions() {
        if (this.gemVersions == null) {
            this.initializeUrlMaps();
        }
        return this.gemVersions;
    }

    public Map<String, URL> getGemUrls() {
        if (this.gemUrls == null) {
            this.initializeUrlMaps();
        }
        return this.gemUrls;
    }

    private void initializeUrlMaps() {
        File file = this.platform.getHome();
        if (file == null || !file.exists()) {
            this.gemVersions = Collections.emptyMap();
            this.gemUrls = Collections.emptyMap();
            this.nonGemUrls = Collections.emptySet();
            return;
        }
        try {
            Object object;
            Object object2;
            this.gemUrls = new HashMap<String, URL>(60);
            this.gemVersions = new HashMap<String, String>(60);
            this.nonGemUrls = new HashSet<URL>(12);
            if (!SKIP_INDEX_LIBS && (object2 = this.platform.getVersionLibDir()) != null) {
                object = new File((String)object2);
                assert (((File)object).exists() && ((File)object).isDirectory());
                this.nonGemUrls.add(((File)object).toURI().toURL());
            }
            if (!SKIP_INDEX_GEMS) {
                this.initGemList();
                if (RubyPlatformManager.PREINDEXING) {
                    object2 = this.getGemHome();
                    object = new File((String)object2, "gems");
                    if (((File)object).exists()) {
                        File[] fileArray;
                        for (File file2 : fileArray = ((File)object).listFiles()) {
                            File file3;
                            if (file2.getName().indexOf(45) == -1 || !(file3 = new File(file2, "lib")).exists() || !file3.isDirectory() || file3.list().length <= 0) continue;
                            URL uRL = file3.toURI().toURL();
                            this.nonGemUrls.add(uRL);
                        }
                    }
                } else if (this.localGems != null) {
                    object2 = this.localGems.keySet();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        List<GemInfo> list = this.localGems.get(string);
                        assert (!list.isEmpty());
                        GemInfo gemInfo = list.get(0);
                        File file4 = gemInfo.getSpecFile();
                        assert (file4.getName().endsWith(DOT_GEM_SPEC));
                        String string2 = file4.getName().substring(0, file4.getName().length() - DOT_GEM_SPEC.length());
                        File file5 = new File(file4.getParentFile().getParentFile(), "gems" + File.separator + string2 + File.separator + "lib");
                        if (!file5.exists() || !file5.isDirectory()) continue;
                        URL uRL = file5.toURI().toURL();
                        this.gemUrls.put(string, uRL);
                        String string3 = gemInfo.getVersion();
                        this.gemVersions.put(string, string3);
                    }
                }
            }
            if (!SKIP_INDEX_LIBS && (object2 = this.platform.getRubyLibSiteDir()) != null && ((File)(object = new File((String)object2))).exists() && ((File)object).isDirectory()) {
                this.nonGemUrls.add(((File)object).toURI().toURL());
            }
            this.gemUrls = Collections.unmodifiableMap(this.gemUrls);
            this.gemVersions = Collections.unmodifiableMap(this.gemVersions);
            this.nonGemUrls = Collections.unmodifiableSet(this.nonGemUrls);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
    }

    private List<String> mapToGemNames(Gem[] gemArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Gem gem : gemArray) {
            arrayList.add(gem.getName());
        }
        return arrayList;
    }

    private Runnable resetCompletionTask(final Runnable runnable) {
        return new Runnable(){

            public void run() {
                GemManager.this.resetLocal();
                runnable.run();
            }
        };
    }

    public static String getNotInstalledMessage() {
        return NbBundle.getMessage(GemManager.class, (String)"GemManager.rubyGemsNotInstalled");
    }

    static boolean isValidGemHome(File file) {
        Parameters.notNull((CharSequence)"gemHomeF", (Object)file);
        boolean bl = file.isDirectory();
        for (int i = 0; bl && i < TOP_LEVEL_REPO_DIRS.length; ++i) {
            String string = TOP_LEVEL_REPO_DIRS[i];
            File file2 = new File(file, string);
            LOGGER.finer("Checking: " + file2);
            LOGGER.finer("valid: " + (bl &= file2.isDirectory()));
        }
        return bl;
    }

    public static void adjustEnvironment(RubyPlatform rubyPlatform, Map<String, String> map) {
        if (rubyPlatform.hasRubyGemsInstalled()) {
            String string = GemManager.adjustGemPath(rubyPlatform.getGemManager().getGemHome());
            String string2 = GemManager.adjustGemPath(rubyPlatform.getInfo().getGemPath());
            map.put("GEM_HOME", string);
            map.put("GEM_PATH", string2);
        }
    }

    private static String adjustGemPath(String string) {
        return Utilities.isWindows() ? string.replace('\\', '/') : string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GemManager gemManager = (GemManager)object;
        return this.platform == gemManager.platform || this.platform != null && this.platform.equals(gemManager.platform);
    }

    public int hashCode() {
        int n = 3;
        n = 53 * n + (this.platform != null ? this.platform.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "GemManager[platform:" + this.platform + "]";
    }

    public static interface VersionPredicate {
        public boolean isRight(String var1);
    }
}

