/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.olddeploy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.URLWait;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentStatus;
import org.netbeans.modules.j2ee.weblogic9.WLTargetModuleID;
import org.netbeans.modules.j2ee.weblogic9.config.gen.WeblogicWebApp;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WLDeployer
implements ProgressObject,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(WLDeployer.class.getName());
    private static final String AUTO_DEPLOY_DIR = "/autodeploy";
    private static final int TIMEOUT = 60000;
    private final String uri;
    private File file;
    private TargetModuleID module_id;
    private List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private DeploymentStatus deploymentStatus;

    public WLDeployer(String string) {
        this.uri = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject deploy(Target[] targetArray, File file, File file2, String string, String string2) {
        WLTargetModuleID wLTargetModuleID;
        block20: {
            wLTargetModuleID = new WLTargetModuleID(targetArray[0], file.getName());
            try {
                String string3 = "http://" + string + ":" + string2;
                if (file.getName().endsWith(".war")) {
                    JarFileSystem jarFileSystem = new JarFileSystem();
                    jarFileSystem.setJarFile(file);
                    FileObject fileObject = jarFileSystem.getRoot().getFileObject("WEB-INF/weblogic.xml");
                    if (fileObject != null) {
                        InputStream inputStream = fileObject.getInputStream();
                        try {
                            String[] stringArray = WeblogicWebApp.createGraph(inputStream).getContextRoot();
                            if (stringArray != null && stringArray.length > 0) {
                                wLTargetModuleID.setContextURL(string3 + stringArray[0]);
                            }
                            break block20;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    System.out.println("Cannot file WEB-INF/weblogic.xml in " + file);
                    break block20;
                }
                if (!file.getName().endsWith(".ear")) break block20;
                JarFileSystem jarFileSystem = new JarFileSystem();
                jarFileSystem.setJarFile(file);
                FileObject fileObject = jarFileSystem.getRoot().getFileObject("META-INF/application.xml");
                if (fileObject != null) {
                    Application application = DDProvider.getDefault().getDDRoot(fileObject);
                    Module[] moduleArray = application.getModule();
                    for (int i = 0; i < moduleArray.length; ++i) {
                        WLTargetModuleID wLTargetModuleID2 = new WLTargetModuleID(targetArray[0]);
                        if (moduleArray[i].getWeb() != null) {
                            wLTargetModuleID2.setContextURL(string3 + moduleArray[i].getWeb().getContextRoot());
                        }
                        wLTargetModuleID.addChild(wLTargetModuleID2);
                    }
                    break block20;
                }
                for (FileObject fileObject2 : jarFileSystem.getRoot().getChildren()) {
                    if (!fileObject2.hasExt("war") && !fileObject2.hasExt("jar")) continue;
                    WLTargetModuleID wLTargetModuleID3 = new WLTargetModuleID(targetArray[0]);
                    if (fileObject2.hasExt("war")) {
                        String string4 = "/" + fileObject2.getName();
                        ZipInputStream zipInputStream = new ZipInputStream(fileObject2.getInputStream());
                        try {
                            ZipEntry zipEntry = null;
                            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                                if (!"WEB-INF/weblogic.xml".equals(zipEntry.getName())) continue;
                                String[] stringArray = WeblogicWebApp.createGraph(new ZipEntryInputStream(zipInputStream)).getContextRoot();
                                if (stringArray != null && stringArray.length > 0) {
                                    string4 = stringArray[0];
                                }
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            LOGGER.log(Level.INFO, "Error reading context-root", iOException);
                        }
                        finally {
                            zipInputStream.close();
                        }
                        wLTargetModuleID3.setContextURL(string3 + string4);
                    }
                    wLTargetModuleID.addChild(wLTargetModuleID3);
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.INFO, null, exception);
            }
        }
        this.file = file;
        this.module_id = wLTargetModuleID;
        this.fireHandleProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(WLDeployer.class, (String)"MSG_DEPLOYING", (Object)file.getAbsolutePath())));
        RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        return this;
    }

    public void run() {
        String string = InstanceProperties.getInstanceProperties((String)this.uri).getProperty("domainRoot") + AUTO_DEPLOY_DIR;
        FileObject fileObject = FileUtil.toFileObject((File)this.file);
        FileObject fileObject2 = FileUtil.toFileObject((File)new File(string));
        String string2 = this.file.getName();
        File file = new File(string + File.separator + string2);
        if (file.exists()) {
            file.delete();
        }
        string2 = string2.substring(0, string2.lastIndexOf(46));
        String string3 = NbBundle.getMessage(WLDeployer.class, (String)"MSG_DEPLOYING", (Object)this.file.getAbsolutePath());
        this.fireHandleProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, string3));
        try {
            Object object;
            FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)string2);
            System.out.println("Copying 1 file to: " + fileObject2.getPath());
            String string4 = this.module_id.getWebURL();
            if (string4 == null && (object = this.module_id.getChildTargetModuleID()) != null) {
                for (int i = 0; i < ((TargetModuleID[])object).length && (string4 = object[i].getWebURL()) == null; ++i) {
                }
            }
            if (string4 != null) {
                object = new URL(string4);
                String string5 = NbBundle.getMessage(WLDeployer.class, (String)"MSG_Waiting_For_Url", (Object)object);
                this.fireHandleProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, string5));
                for (int i = 0; i < 3; ++i) {
                    Thread.sleep(1000L);
                }
                long l = System.currentTimeMillis();
                while (System.currentTimeMillis() - l < 60000L && !URLWait.waitForUrlReady((URL)object, 1000)) {
                }
            }
        }
        catch (Exception exception) {
            this.fireHandleProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        this.fireHandleProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, "Applicaton Deployed"));
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.listeners.remove(progressListener);
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[]{this.module_id};
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public void fireHandleProgressEvent(TargetModuleID targetModuleID, DeploymentStatus deploymentStatus) {
        ProgressEvent progressEvent = new ProgressEvent((Object)this, targetModuleID, deploymentStatus);
        this.deploymentStatus = deploymentStatus;
        for (ProgressListener progressListener : this.listeners) {
            progressListener.handleProgressEvent(progressEvent);
        }
    }

    private static class ZipEntryInputStream
    extends InputStream {
        private final ZipInputStream zis;

        public ZipEntryInputStream(ZipInputStream zipInputStream) {
            this.zis = zipInputStream;
        }

        public int available() throws IOException {
            return this.zis.available();
        }

        public void close() throws IOException {
            this.zis.closeEntry();
        }

        public int read() throws IOException {
            if (this.available() > 0) {
                return this.zis.read();
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.zis.read(byArray, n, n2);
        }

        public long skip(long l) throws IOException {
            return this.zis.skip(l);
        }
    }
}

