/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFFrameworkProvider;
import org.netbeans.modules.web.jsf.wizards.JSFConfigurationPanelVisual;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;

public class JSFConfigurationPanel
extends WebModuleExtender {
    private final JSFFrameworkProvider framework;
    private final ExtenderController controller;
    private JSFConfigurationPanelVisual component;
    private static final String PREFERRED_LANGUAGE = "jsf.language";
    private Preferences preferences;
    private LibraryType libraryType;
    private Library jsfCoreLibrary;
    private String newLibraryName;
    private File installedFolder;
    private boolean enableFacelets;
    private boolean debugFacelets;
    private boolean skipComments;
    private boolean createExamples;
    private String facesSuffix;
    private String facesMapping;
    private boolean validateXml;
    private boolean verifyObjects;
    private boolean customizer;
    private final Set listeners = new HashSet(1);

    public JSFConfigurationPanel(JSFFrameworkProvider jSFFrameworkProvider, ExtenderController extenderController, boolean bl) {
        this.framework = jSFFrameworkProvider;
        this.controller = extenderController;
        this.customizer = bl;
        this.enableFacelets = false;
        this.debugFacelets = true;
        this.skipComments = true;
        this.createExamples = true;
        this.facesSuffix = ".xhtml";
        this.validateXml = true;
        this.verifyObjects = false;
        this.facesMapping = "/faces/*";
        this.getComponent();
    }

    public JSFConfigurationPanel(JSFFrameworkProvider jSFFrameworkProvider, ExtenderController extenderController, boolean bl, Preferences preferences) {
        this.framework = jSFFrameworkProvider;
        this.controller = extenderController;
        this.customizer = bl;
        this.preferences = preferences;
        this.enableFacelets = preferences.get(PREFERRED_LANGUAGE, "JSP").equals(PreferredLanguage.Facelets.getName());
        this.debugFacelets = true;
        this.skipComments = true;
        this.createExamples = true;
        this.facesSuffix = ".xhtml";
        this.validateXml = true;
        this.verifyObjects = false;
        this.facesMapping = "/faces/*";
        this.getComponent();
    }

    public JSFConfigurationPanelVisual getComponent() {
        if (this.component == null) {
            this.component = new JSFConfigurationPanelVisual(this, this.customizer);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(JSFConfigurationPanel.class);
    }

    public String getFacesSuffix() {
        return this.facesSuffix;
    }

    public String getFacesMapping() {
        return this.facesMapping;
    }

    private void setFacesMapping(String string) {
        this.facesMapping = string;
    }

    public void update() {
        this.component.update();
    }

    public boolean isValid() {
        this.getComponent();
        if (this.component.valid()) {
            this.setFacesMapping(this.component.getURLPattern());
            return true;
        }
        return false;
    }

    public Set extend(WebModule webModule) {
        Project project = FileOwnerQuery.getOwner((FileObject)webModule.getDocumentBase());
        this.preferences = ProjectUtils.getPreferences((Project)project, ProjectUtils.class, (boolean)true);
        String string = this.component.getPreferredLanguage();
        if (string.equals(PreferredLanguage.JSP.getName()) || string.equals(PreferredLanguage.Facelets.getName())) {
            this.preferences.put(PREFERRED_LANGUAGE, this.component.getPreferredLanguage());
        }
        return this.framework.extendImpl(webModule);
    }

    public ExtenderController getController() {
        return this.controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent((Object)this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    public String getServletName() {
        return this.component.getServletName();
    }

    public void setServletName(String string) {
        this.component.setServletName(string);
    }

    @Deprecated
    public String getURLPattern() {
        return this.component.getURLPattern();
    }

    public void setURLPattern(String string) {
        if (this.component != null) {
            this.component.setURLPattern(string);
        }
    }

    public boolean validateXML() {
        return this.validateXml;
    }

    public void setValidateXML(boolean bl) {
        this.validateXml = bl;
    }

    public boolean verifyObjects() {
        return this.verifyObjects;
    }

    public void setVerifyObjects(boolean bl) {
        this.verifyObjects = bl;
    }

    public boolean packageJars() {
        return this.component.packageJars();
    }

    public String getNewLibraryName() {
        return this.newLibraryName;
    }

    public void setNewLibraryName(String string) {
        this.newLibraryName = string;
        this.fireChangeEvent();
    }

    public File getInstallFolder() {
        return this.installedFolder;
    }

    public void setInstallFolder(File file) {
        this.installedFolder = file;
        this.fireChangeEvent();
    }

    public boolean isDebugFacelets() {
        return this.debugFacelets;
    }

    public void setDebugFacelets(boolean bl) {
        this.debugFacelets = bl;
    }

    public boolean isSkipComments() {
        return this.skipComments;
    }

    public void setSkipComments(boolean bl) {
        this.skipComments = bl;
    }

    public boolean isCreateExamples() {
        return this.createExamples;
    }

    public void setCreateExamples(boolean bl) {
        this.createExamples = bl;
    }

    public boolean isEnableFacelets() {
        return this.enableFacelets;
    }

    protected void setEnableFacelets(boolean bl) {
        if (this.enableFacelets != bl) {
            this.enableFacelets = bl;
            String string = bl ? PreferredLanguage.JSP.getName() : PreferredLanguage.Facelets.getName();
            String string2 = bl ? PreferredLanguage.Facelets.getName() : PreferredLanguage.JSP.getName();
            this.updatePreferredLanguage(string, string2);
        }
    }

    private void updatePreferredLanguage(String string, String string2) {
        if (this.preferences != null && !string.equals(string2)) {
            this.preferences.put(PREFERRED_LANGUAGE, this.component.getPreferredLanguage());
        }
    }

    public LibraryType getLibraryType() {
        return this.libraryType;
    }

    public void setLibraryType(LibraryType libraryType) {
        this.libraryType = libraryType;
    }

    public Library getLibrary() {
        return this.jsfCoreLibrary;
    }

    protected void setLibrary(Library library) {
        this.jsfCoreLibrary = library;
        this.fireChangeEvent();
    }

    protected static class PreferredLanguage {
        private String name;
        static final PreferredLanguage JSP = new PreferredLanguage("JSP");
        static final PreferredLanguage Facelets = new PreferredLanguage("Facelets");

        private PreferredLanguage(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LibraryType {
        USED,
        NEW,
        NONE;

    }
}

