/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.refactoring.DiffElement;
import org.netbeans.modules.web.jsf.refactoring.Modifications;
import org.netbeans.modules.web.jsf.refactoring.Occurrences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JSFRefactoringUtils {
    private static final Logger LOGGER = Logger.getLogger(JSFRefactoringUtils.class.getName());
    private static final String JAVA_MIME_TYPE = "text/x-java";

    private JSFRefactoringUtils() {
    }

    public static String getPackageName(FileObject fileObject) {
        assert (fileObject.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
    }

    public static String getPackageName(URL uRL) {
        File file = null;
        try {
            file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Cannot create package name for url " + uRL);
        }
        String string = "";
        do {
            FileObject fileObject;
            if ((fileObject = FileUtil.toFileObject((File)file)) != null) {
                if ("".equals(string)) {
                    return JSFRefactoringUtils.getPackageName(fileObject);
                }
                String string2 = JSFRefactoringUtils.getPackageName(fileObject);
                return string2 + ("".equals(string2) ? "" : ".") + string;
            }
            if (!"".equals(string)) {
                string = "." + string;
            }
            string = URLDecoder.decode(file.getPath().substring(file.getPath().lastIndexOf(File.separatorChar) + 1)) + string;
        } while ((file = file.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + uRL);
    }

    public static boolean containsRenamingPackage(String string, String string2, boolean bl) {
        boolean bl2 = false;
        if (string != null && string2 != null) {
            if (!bl) {
                if (string.startsWith(string2) && string.substring(string2.length() + 1).indexOf(46) < 0 && string.substring(string2.length()).charAt(0) == '.') {
                    bl2 = true;
                }
            } else if (string.startsWith(string2) && string.substring(string2.length()).charAt(0) == '.') {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static void renamePackage(AbstractRefactoring abstractRefactoring, RefactoringElementsBag refactoringElementsBag, FileObject fileObject, String string, String string2, boolean bl) {
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule != null) {
            List<Occurrences.OccurrenceItem> list = Occurrences.getPackageOccurrences(webModule, string, string2, bl);
            Modifications modifications = new Modifications();
            for (Occurrences.OccurrenceItem occurrenceItem : list) {
                Modifications.Difference difference = new Modifications.Difference(Modifications.Difference.Kind.CHANGE, occurrenceItem.getChangePosition().getBegin(), occurrenceItem.getChangePosition().getEnd(), occurrenceItem.getOldValue(), occurrenceItem.getNewValue(), occurrenceItem.getRenamePackageMessage());
                modifications.addDifference(occurrenceItem.getFacesConfig(), difference);
                refactoringElementsBag.add(abstractRefactoring, (RefactoringElementImplementation)new DiffElement.ChangeFQCNElement(difference, occurrenceItem, modifications));
            }
        }
    }

    public static boolean isJavaFile(FileObject fileObject) {
        return JAVA_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static CompilationInfo getCompilationInfo(final AbstractRefactoring abstractRefactoring, FileObject fileObject) {
        CompilationInfo compilationInfo = (CompilationInfo)abstractRefactoring.getContext().lookup(CompilationInfo.class);
        if (compilationInfo == null && fileObject != null) {
            ClasspathInfo classpathInfo = (ClasspathInfo)abstractRefactoring.getContext().lookup(ClasspathInfo.class);
            JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{fileObject});
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        abstractRefactoring.getContext().add((Object)compilationController);
                    }
                }, false);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Exception in JSFSafeDeletePlugin", iOException);
            }
            compilationInfo = (CompilationInfo)abstractRefactoring.getContext().lookup(CompilationInfo.class);
        }
        return compilationInfo;
    }
}

