/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.impl.metamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModelFactory;
import org.netbeans.modules.web.jsf.api.metamodel.Behavior;
import org.netbeans.modules.web.jsf.api.metamodel.Component;
import org.netbeans.modules.web.jsf.api.metamodel.FacesConverter;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModel;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModelElement;
import org.netbeans.modules.web.jsf.api.metamodel.ModelUnit;
import org.netbeans.modules.web.jsf.api.metamodel.SystemEventListener;
import org.netbeans.modules.web.jsf.api.metamodel.Validator;
import org.netbeans.modules.web.jsf.impl.facesmodel.AnnotationBehaviorRenderer;
import org.netbeans.modules.web.jsf.impl.facesmodel.AnnotationRenderer;
import org.netbeans.modules.web.jsf.impl.metamodel.BehaviorFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.ClientBehaviorRendererImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.ComponentFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.ConverterFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.ElementFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.JsfModelManagers;
import org.netbeans.modules.web.jsf.impl.metamodel.ManagedBeanFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.ObjectProviders;
import org.netbeans.modules.web.jsf.impl.metamodel.RendererImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.ValidatorFinder;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsfModelImpl
extends JsfModelManagers
implements JsfModel {
    private static final String SUFFIX = ".faces-config.xml";
    private static final Map<Class<? extends JsfModelElement>, ElementFinder<? extends JsfModelElement>> FINDERS = new HashMap<Class<? extends JsfModelElement>, ElementFinder<? extends JsfModelElement>>();
    private static final LibMarker LIB;
    private final PropertyChangeSupport mySupport;
    private ModelUnit myUnit;
    private List<JSFConfigModel> myModels;
    private volatile JSFConfigModel myMainModel;
    private List<FacesConfig> myFacesConfigs;
    private FileChangeListener myListener;
    private Set<FileObject> compileRoots;
    private static final Logger LOG;

    JsfModelImpl(ModelUnit modelUnit, AnnotationModelHelper annotationModelHelper) {
        super(annotationModelHelper);
        this.myUnit = modelUnit;
        this.mySupport = new PropertyChangeSupport(this);
        this.myModels = new LinkedList<JSFConfigModel>();
        this.myFacesConfigs = new CopyOnWriteArrayList<FacesConfig>();
        this.registerChangeListeners();
        this.initModels();
    }

    @Override
    public <T extends JsfModelElement> List<T> getElements(Class<T> clazz) {
        Boolean bl;
        Object object;
        this.refreshModels();
        ElementFinder<T> elementFinder = this.getFinder(clazz);
        Class<Object> clazz2 = elementFinder == null ? clazz : elementFinder.getConfigType();
        LinkedList<T> linkedList = new LinkedList<T>();
        for (FacesConfig facesConfig : this.myFacesConfigs) {
            if (facesConfig == null) continue;
            object = facesConfig.getChildren(clazz2);
            linkedList.addAll((Collection<T>)object);
        }
        JSFConfigModel jSFConfigModel = this.myMainModel;
        boolean bl2 = false;
        if (jSFConfigModel != null && (object = jSFConfigModel.getRootComponent()) != null && (bl = object.isMetaDataComplete()) != null) {
            bl2 = bl;
        }
        if (elementFinder != null && !bl2) {
            linkedList.addAll(elementFinder.getAnnotations(this));
        }
        return linkedList;
    }

    @Override
    public List<FacesConfig> getFacesConfigs() {
        this.refreshModels();
        return Collections.unmodifiableList(this.myFacesConfigs);
    }

    @Override
    public FacesConfig getMainConfig() {
        this.refreshModels();
        JSFConfigModel jSFConfigModel = this.myMainModel;
        return jSFConfigModel != null ? jSFConfigModel.getRootComponent() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JSFConfigModel> getModels() {
        List<JSFConfigModel> list = this.myModels;
        synchronized (list) {
            this.refreshModels();
            return Collections.unmodifiableList(this.myModels);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    protected List<AnnotationBehaviorRenderer> getClientBehaviorRenderers(String string) {
        Object object;
        FacesConfig facesConfig = this.getMainConfig();
        if (facesConfig != null && (object = facesConfig.isMetaDataComplete()) != null && ((Boolean)object).booleanValue()) {
            return Collections.emptyList();
        }
        object = this.getClientBehaviorManager().getObjects();
        ArrayList<AnnotationBehaviorRenderer> arrayList = new ArrayList<AnnotationBehaviorRenderer>(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ClientBehaviorRendererImpl clientBehaviorRendererImpl = (ClientBehaviorRendererImpl)iterator.next();
            String string2 = clientBehaviorRendererImpl.getRenderKitId();
            if (!string.equals(string2)) continue;
            arrayList.add(clientBehaviorRendererImpl);
        }
        return arrayList;
    }

    @Override
    protected List<AnnotationRenderer> getRenderers(String string) {
        Object object;
        FacesConfig facesConfig = this.getMainConfig();
        if (facesConfig != null && (object = facesConfig.isMetaDataComplete()) != null && ((Boolean)object).booleanValue()) {
            return Collections.emptyList();
        }
        object = this.getRendererManager().getObjects();
        ArrayList<AnnotationRenderer> arrayList = new ArrayList<AnnotationRenderer>(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            RendererImpl rendererImpl = (RendererImpl)iterator.next();
            String string2 = rendererImpl.getRenderKitId();
            if (!string.equals(string2)) continue;
            arrayList.add(rendererImpl);
        }
        return arrayList;
    }

    @Override
    protected List<SystemEventListener> getSystemEventListeners() {
        Collection collection = this.getSystemEventManager().getObjects();
        List<SystemEventListener> list = ObjectProviders.findApplicationSystemEventListeners(this.getHelper());
        ArrayList<SystemEventListener> arrayList = new ArrayList<SystemEventListener>(collection.size() + list.size());
        arrayList.addAll(collection);
        arrayList.addAll(list);
        return arrayList;
    }

    private PropertyChangeSupport getChangeSupport() {
        return this.mySupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshModels() {
        List<JSFConfigModel> list = this.myModels;
        synchronized (list) {
            for (JSFConfigModel jSFConfigModel : this.myModels) {
                try {
                    boolean bl = jSFConfigModel.getRootComponent() == null;
                    jSFConfigModel.sync();
                    if (!bl || jSFConfigModel.getRootComponent() == null) continue;
                    this.myFacesConfigs.add(jSFConfigModel.getRootComponent());
                }
                catch (IOException iOException) {
                    LOG.log(Level.SEVERE, "Error during faces-config.xml parsing! File: " + jSFConfigModel.getModelSource().getLookup().lookup(FileObject.class), iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModels() {
        ArrayList<FacesConfig> arrayList;
        List<JSFConfigModel> list = this.myModels;
        synchronized (list) {
            Object object;
            LinkedList<JSFConfigModel> linkedList = new LinkedList<JSFConfigModel>();
            if (this.getUnit().getMainFacesConfig() != null) {
                this.myMainModel = JSFConfigModelFactory.getInstance().getModel(this.getModelSource(this.getUnit().getMainFacesConfig(), true));
            }
            FileObject[] fileObjectArray = this.getUnit().getConfigFiles().iterator();
            while (fileObjectArray.hasNext()) {
                object = fileObjectArray.next();
                if (object.equals(this.myMainModel)) {
                    linkedList.add(this.myMainModel);
                    continue;
                }
                linkedList.add(JSFConfigModelFactory.getInstance().getModel(this.getModelSource((FileObject)object, true)));
            }
            this.compileRoots = new HashSet<FileObject>();
            object = this.compileRoots;
            synchronized (object) {
                FileObject[] fileObjectArray2 = fileObjectArray = this.getUnit().getCompilePath().getRoots();
                int n = fileObjectArray2.length;
                for (int i = 0; i < n; ++i) {
                    FileObject fileObject = fileObjectArray2[i];
                    this.compileRoots.add(fileObject);
                }
            }
            for (FileObject fileObject : fileObjectArray) {
                if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                    fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
                }
                this.collectLibraryModels(linkedList, fileObject);
            }
            this.myModels.addAll(linkedList);
            arrayList = new ArrayList<FacesConfig>(this.myModels.size());
            for (JSFConfigModel jSFConfigModel : this.myModels) {
                if (jSFConfigModel.getRootComponent() == null) continue;
                arrayList.add(jSFConfigModel.getRootComponent());
            }
        }
        this.myFacesConfigs.addAll(arrayList);
    }

    private void collectLibraryModels(List<JSFConfigModel> list, FileObject fileObject) {
        FileObject fileObject2 = fileObject.getFileObject("META-INF");
        if (fileObject2 != null) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject3 : fileObjectArray = fileObject2.getChildren()) {
                String string = fileObject3.getNameExt();
                if (!string.equals("faces-config.xml") && !string.endsWith(SUFFIX)) continue;
                list.add(JSFConfigModelFactory.getInstance().getModel(this.getLibModelSource(fileObject3, false)));
            }
        }
    }

    private ModelUnit getUnit() {
        return this.myUnit;
    }

    private ModelSource getModelSource(FileObject fileObject, boolean bl) {
        try {
            ModelSource modelSource = Utilities.createModelSource((FileObject)fileObject, (boolean)bl);
            Lookup lookup = modelSource.getLookup();
            lookup = new ProxyLookup(new Lookup[]{lookup, Lookups.singleton((Object)this)});
            return new ModelSource(lookup, bl);
        }
        catch (CatalogModelException catalogModelException) {
            Logger.getLogger("global").log(Level.SEVERE, catalogModelException.getMessage(), catalogModelException);
            return null;
        }
    }

    private ModelSource getLibModelSource(FileObject fileObject, boolean bl) {
        try {
            ModelSource modelSource = Utilities.createModelSource((FileObject)fileObject, (boolean)bl);
            Lookup lookup = modelSource.getLookup();
            lookup = new ProxyLookup(new Lookup[]{lookup, Lookups.fixed((Object[])new Object[]{this, LIB})});
            return new ModelSource(lookup, bl);
        }
        catch (CatalogModelException catalogModelException) {
            Logger.getLogger("global").log(Level.SEVERE, catalogModelException.getMessage(), catalogModelException);
            return null;
        }
    }

    private <T extends JsfModelElement> ElementFinder<T> getFinder(Class<T> clazz) {
        return FINDERS.get(clazz);
    }

    private void registerChangeListeners() {
        ClassPath classPath = this.getUnit().getCompilePath();
        classPath.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ArrayList arrayList;
                if (!propertyChangeEvent.getPropertyName().equals("entries")) {
                    return;
                }
                FileObject[] fileObjectArray = JsfModelImpl.this.getUnit().getCompilePath().getRoots();
                LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
                List list = JsfModelImpl.this.myModels;
                synchronized (list) {
                    Object object = new HashSet<JSFConfigModel>();
                    HashSet<JSFConfigModel> hashSet = new HashSet<JSFConfigModel>();
                    for (JSFConfigModel jSFConfigModel : JsfModelImpl.this.myModels) {
                        if (jSFConfigModel.getModelSource().getLookup().lookup(LibMarker.class) == null) continue;
                        hashSet.add(jSFConfigModel);
                    }
                    for (FileObject fileObject : fileObjectArray) {
                        boolean bl = true;
                        for (JSFConfigModel jSFConfigModel : hashSet) {
                            if (jSFConfigModel.getModelSource().getLookup().lookup(LibMarker.class) == null) continue;
                            FileObject fileObject2 = (FileObject)jSFConfigModel.getModelSource().getLookup().lookup(FileObject.class);
                            if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                                fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
                            }
                            if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) continue;
                            object.add(jSFConfigModel);
                            bl = false;
                        }
                        if (!bl) continue;
                        linkedList.add(fileObject);
                    }
                    hashSet.removeAll((Collection<?>)object);
                    for (JSFConfigModel jSFConfigModel : hashSet) {
                        JsfModelImpl.this.myModels.remove(jSFConfigModel);
                        JsfModelImpl.this.myFacesConfigs.remove(jSFConfigModel.getRootComponent());
                    }
                    arrayList = new ArrayList(linkedList.size());
                    for (FileObject fileObject : linkedList) {
                        JsfModelImpl.this.collectLibraryModels(arrayList, fileObject);
                    }
                    JsfModelImpl.this.myModels.addAll(arrayList);
                }
                for (Object object : arrayList) {
                    if (object.getRootComponent() == null) continue;
                    JsfModelImpl.this.myFacesConfigs.add(object.getRootComponent());
                }
            }
        });
        this.myListener = new FileChangeListener(){

            public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            }

            public void fileChanged(FileEvent fileEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileDataCreated(FileEvent fileEvent) {
                FileObject fileObject = fileEvent.getFile();
                if (!this.checkConfigFile(fileObject)) {
                    return;
                }
                ModelSource modelSource = JsfModelImpl.this.getModelSource(fileObject, true);
                if (modelSource != null) {
                    JSFConfigModel jSFConfigModel = JSFConfigModelFactory.getInstance().getModel(modelSource);
                    boolean bl = false;
                    List list = JsfModelImpl.this.myModels;
                    synchronized (list) {
                        if (JsfModelImpl.this.myModels.contains(jSFConfigModel)) {
                            bl = true;
                        } else {
                            JsfModelImpl.this.myModels.add(jSFConfigModel);
                        }
                    }
                    if (fileObject.equals(JsfModelImpl.this.getUnit().getMainFacesConfig())) {
                        JsfModelImpl.this.myMainModel = jSFConfigModel;
                    }
                    if (!bl && jSFConfigModel.getRootComponent() != null) {
                        JsfModelImpl.this.myFacesConfigs.add(jSFConfigModel.getRootComponent());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileDeleted(FileEvent fileEvent) {
                FileObject fileObject = fileEvent.getFile();
                if (!this.wasConfigFile(fileObject)) {
                    return;
                }
                JSFConfigModel jSFConfigModel = null;
                List list = JsfModelImpl.this.myModels;
                synchronized (list) {
                    for (JSFConfigModel jSFConfigModel2 : JsfModelImpl.this.myModels) {
                        FileObject fileObject2 = (FileObject)jSFConfigModel2.getModelSource().getLookup().lookup(FileObject.class);
                        if (!fileObject2.equals(fileEvent.getFile())) continue;
                        jSFConfigModel = jSFConfigModel2;
                        break;
                    }
                    if (jSFConfigModel != null) {
                        JsfModelImpl.this.myModels.remove(jSFConfigModel);
                    }
                }
                if (jSFConfigModel != null) {
                    if (JsfModelImpl.this.myMainModel == jSFConfigModel) {
                        JsfModelImpl.this.myMainModel = null;
                    }
                    if (jSFConfigModel.getRootComponent() != null) {
                        JsfModelImpl.this.myFacesConfigs.remove(jSFConfigModel.getRootComponent());
                    }
                }
            }

            public void fileFolderCreated(FileEvent fileEvent) {
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
            }

            private boolean checkConfigFile(FileObject fileObject) {
                if (fileObject == null) {
                    return false;
                }
                if (fileObject.equals(JsfModelImpl.this.getUnit().getMainFacesConfig())) {
                    return true;
                }
                for (FileObject fileObject2 : JsfModelImpl.this.getUnit().getConfigFiles()) {
                    if (!fileObject.equals(fileObject2)) continue;
                    return true;
                }
                return false;
            }

            private boolean wasConfigFile(FileObject fileObject) {
                if (fileObject == null) {
                    return false;
                }
                if (fileObject.equals(JsfModelImpl.this.getUnit().getMainFacesConfig())) {
                    return true;
                }
                String string = fileObject.getNameExt();
                if (string.equals("faces-config.xml") || string.endsWith(JsfModelImpl.SUFFIX)) {
                    FileObject fileObject2 = fileObject.getParent();
                    if (!fileObject2.getName().equals("META-INF")) {
                        return false;
                    }
                    for (FileObject fileObject3 : JsfModelImpl.this.getUnit().getSourcePath().getRoots()) {
                        if (!fileObject2.equals(fileObject3.getFileObject("META-INF"))) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        FileUtil.addFileChangeListener((FileChangeListener)this.myListener);
    }

    static {
        FINDERS.put(Behavior.class, new BehaviorFinder());
        FINDERS.put(Component.class, new ComponentFinder());
        FINDERS.put(FacesConverter.class, new ConverterFinder());
        FINDERS.put(FacesManagedBean.class, new ManagedBeanFinder());
        FINDERS.put(Validator.class, new ValidatorFinder());
        LIB = new LibMarker();
        LOG = Logger.getLogger(JsfModelImpl.class.getName());
    }

    private static final class LibMarker {
        private LibMarker() {
        }
    }
}

