/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.websvc.saas.codegen.java.support.Xsd2Java;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlSaasEx {
    private WadlSaas wadlSaas;
    private ArrayList<FileObject> jaxbJars;
    private ArrayList<FileObject> jaxbSourceJars;

    public WadlSaasEx(WadlSaas wadlSaas) {
        this.wadlSaas = wadlSaas;
    }

    private boolean compileSchemas() throws IOException {
        assert (this.wadlSaas != null);
        assert (this.wadlSaas.getWadlModel() != null);
        this.jaxbJars = new ArrayList();
        this.jaxbSourceJars = new ArrayList();
        for (FileObject fileObject : this.wadlSaas.getLocalSchemaFiles()) {
            Xsd2Java xsd2Java = new Xsd2Java(fileObject, this.wadlSaas.getPackageName() + "." + SaasUtil.toValidJavaName((String)fileObject.getName()).toLowerCase());
            if (!xsd2Java.compile()) {
                return false;
            }
            this.jaxbJars.add(xsd2Java.getJaxbJarFile());
            this.jaxbSourceJars.add(xsd2Java.getJaxbSourceJarFile());
        }
        return true;
    }

    public List<FileObject> getLibraryJars() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        if (this.jaxbJars == null) {
            try {
                this.compileSchemas();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        arrayList.addAll(this.jaxbJars);
        return arrayList;
    }

    public List<FileObject> getJaxbSourceJars() {
        if (this.jaxbSourceJars == null) {
            try {
                this.compileSchemas();
                return Collections.unmodifiableList(this.jaxbSourceJars);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return Collections.emptyList();
    }
}

