/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.module.dlight.threads.api.Datarace;
import org.netbeans.module.dlight.threads.api.Deadlock;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.perfan.spi.datafilter.SunStudioFiltersProvider;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.DataraceImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.DeadlockImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintCommand;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintSession;
import org.netbeans.modules.dlight.perfan.storage.impl.ExperimentStatistics;
import org.netbeans.modules.dlight.perfan.storage.impl.FunctionStatistic;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.perfan.storage.impl.PerfanDataStorageFactory;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerfanDataStorage
implements DataStorage {
    public static final String ID = "PerfanDataStorage";
    public static final DataStorageType storageType = DataStorageTypeFactory.getInstance().getDataStorageType("PerfanDataStorage");
    private static final Logger log = DLightLogger.getLogger(PerfanDataStorage.class);
    private volatile ErprintSession er_print;
    private String experimentDirectory = null;
    private ExecutionEnvironment env;
    private final List<DataTableMetadata> tableMetadatas = new ArrayList<DataTableMetadata>();
    private ServiceInfoDataStorage serviceInfoDataStorage;
    private volatile boolean isOMPExperiment = false;

    public final void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoDataStorage = serviceInfoDataStorage;
    }

    public boolean shutdown() {
        if (this.er_print != null) {
            this.er_print.close();
        }
        if (this.experimentDirectory != null) {
            StringWriter stringWriter = new StringWriter();
            CommonTasksSupport.rmDir((ExecutionEnvironment)this.env, (String)this.experimentDirectory, (boolean)true, (Writer)stringWriter);
            return stringWriter.toString().trim().equals("");
        }
        return true;
    }

    public void setFilter(String string) {
        this.er_print.setFilter(string);
    }

    public boolean hasOMPCollected() {
        try {
            this.isOMPExperiment = false;
            Metrics metrics = this.er_print.getMetrics(true);
            if (metrics.mspec.indexOf("omp") != -1) {
                this.isOMPExperiment = true;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return this.isOMPExperiment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ExecutionEnvironment executionEnvironment, String string, String string2, SunStudioFiltersProvider sunStudioFiltersProvider) {
        PerfanDataStorage perfanDataStorage = this;
        synchronized (perfanDataStorage) {
            if (this.er_print != null) {
                this.er_print.close();
            }
            this.er_print = ErprintSession.createNew(executionEnvironment, string, string2, sunStudioFiltersProvider);
        }
    }

    public Object[] getCallees(long l) {
        return null;
    }

    public Object[] getCallers(long l) {
        return null;
    }

    public String[] getTopFunctions(Metrics metrics, int n) {
        String[] stringArray = null;
        try {
            stringArray = this.er_print.getHotFunctions(metrics, n, 0, true);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            log.log(Level.FINEST, "getTopFunctions: " + iOException.toString());
        }
        return stringArray == null ? new String[]{} : stringArray;
    }

    public Metrics getCollectedMetrics() {
        try {
            return this.er_print.getMetrics(true);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            log.log(Level.FINEST, "getMetrics: " + iOException.toString());
        }
        return Metrics.constructFrom(Arrays.asList(SunStudioDCConfiguration.c_name), Arrays.asList(SunStudioDCConfiguration.c_name));
    }

    public String[] getTopFunctions(ErprintCommand erprintCommand, Metrics metrics, int n) throws InterruptedException {
        String[] stringArray = null;
        try {
            stringArray = this.er_print.getHotFunctions(erprintCommand, metrics, n, true);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException();
        }
        catch (IOException iOException) {
            log.log(Level.FINEST, "getTopFunctions: " + iOException.toString());
        }
        return stringArray;
    }

    public FunctionStatistic getFunctionStatistic(String string) {
        FunctionStatistic functionStatistic = null;
        try {
            functionStatistic = this.er_print.getFunctionStatistic(string, false);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, null, iOException);
        }
        return functionStatistic;
    }

    public FunctionStatistic getFunctionStatistic(FunctionCallImpl functionCallImpl) {
        FunctionStatistic functionStatistic = null;
        try {
            functionStatistic = this.er_print.getFunctionStatistic(functionCallImpl, false);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, null, iOException);
        }
        return functionStatistic;
    }

    public List<? extends Datarace> getDataraces() {
        List<DataraceImpl> list = null;
        try {
            list = this.er_print.getDataRaces(true);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            log.log(Level.INFO, null, iOException);
        }
        return list == null ? Collections.emptyList() : list;
    }

    public List<? extends Deadlock> getDeadlocks() {
        List<DeadlockImpl> list = null;
        try {
            list = this.er_print.getDeadlocks(true);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            log.log(Level.INFO, null, iOException);
        }
        return list == null ? Collections.emptyList() : list;
    }

    public ExperimentStatistics fetchSummaryData() {
        ExperimentStatistics experimentStatistics = null;
        try {
            experimentStatistics = this.er_print.getExperimentStatistics(0, true);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, null, iOException);
        }
        return experimentStatistics;
    }

    public Collection<DataStorageType> getStorageTypes() {
        return PerfanDataStorageFactory.supportedTypes;
    }

    public boolean supportsType(DataStorageType dataStorageType) {
        return this.getStorageTypes().contains(dataStorageType);
    }

    public boolean hasData(DataTableMetadata dataTableMetadata) {
        return dataTableMetadata.isProvidedBy(this.tableMetadatas);
    }

    public void createTables(List<DataTableMetadata> list) {
        this.tableMetadatas.addAll(list);
    }

    public void addData(String string, List<DataRow> list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

