/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.module.dlight.threads.api.Deadlock;
import org.netbeans.module.dlight.threads.api.DeadlockThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeadlockImpl
implements Deadlock {
    private final int id;
    private final boolean actual;
    private final List<DeadlockThreadSnapshot> threads;
    private static final Pattern DEADLOCK_PATTERN = Pattern.compile("Deadlock\\s+#(\\d+),\\s+(Actual|Potential)\\s+deadlock");
    private static final Pattern THREAD_PATTERN = Pattern.compile("\\s+Thread\\s+#\\d+");
    private static final Pattern LOCK_PATTERN = Pattern.compile("\\s+Lock being (held|requested):\\s+0x([0-9a-fA-F]+)");

    private DeadlockImpl(int n, boolean bl, List<DeadlockThreadSnapshot> list) {
        this.id = n;
        this.actual = bl;
        this.threads = Collections.unmodifiableList(list);
    }

    public boolean isActual() {
        return this.actual;
    }

    public List<DeadlockThreadSnapshot> getThreadStates() {
        return this.threads;
    }

    public String toString() {
        return "Deadlock #" + this.id + " (" + (this.actual ? "actual" : "potential") + ")";
    }

    public static List<DeadlockImpl> fromErprint(String[] stringArray) {
        ArrayList<DeadlockImpl> arrayList = new ArrayList<DeadlockImpl>();
        ListIterator<String> listIterator = Arrays.asList(stringArray).listIterator();
        while (listIterator.hasNext()) {
            Matcher matcher = DEADLOCK_PATTERN.matcher(listIterator.next());
            if (!matcher.matches()) continue;
            arrayList.add(DeadlockImpl.parseDeadlock(listIterator, matcher));
        }
        return arrayList;
    }

    private static DeadlockImpl parseDeadlock(ListIterator<String> listIterator, Matcher matcher) {
        Matcher matcher2;
        int n;
        try {
            n = Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        boolean bl = matcher.group(2).equals("Actual");
        ArrayList<DeadlockThreadSnapshot> arrayList = new ArrayList<DeadlockThreadSnapshot>();
        while (listIterator.hasNext() && (matcher2 = THREAD_PATTERN.matcher(listIterator.next())).matches()) {
            arrayList.add(DeadlockImpl.parseThreadSnapshot(listIterator, matcher2));
        }
        return new DeadlockImpl(n, bl, arrayList);
    }

    private static DeadlockThreadSnapshot parseThreadSnapshot(ListIterator<String> listIterator, Matcher matcher) {
        long l = DeadlockImpl.parseLockAddress(listIterator.next(), "held");
        List<FunctionCall> list = FunctionCallImpl.parseStack(listIterator);
        long l2 = DeadlockImpl.parseLockAddress(listIterator.next(), "requested");
        List<FunctionCall> list2 = FunctionCallImpl.parseStack(listIterator);
        return new DeadlockThreadSnapshotImpl(l, list, l2, list2);
    }

    private static long parseLockAddress(String string, String string2) {
        Matcher matcher = LOCK_PATTERN.matcher(string);
        if (matcher.matches() && matcher.group(1).equals(string2)) {
            try {
                return Long.parseLong(matcher.group(2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeadlockThreadSnapshotImpl
    implements DeadlockThreadSnapshot {
        private final long oldLockAddress;
        private final List<FunctionCall> oldLockStack;
        private final long newLockAddress;
        private final List<FunctionCall> newLockStack;

        private DeadlockThreadSnapshotImpl(long l, List<FunctionCall> list, long l2, List<FunctionCall> list2) {
            this.oldLockAddress = l;
            this.oldLockStack = Collections.unmodifiableList(list);
            this.newLockAddress = l2;
            this.newLockStack = Collections.unmodifiableList(list2);
        }

        public long getHeldLockAddress() {
            return this.oldLockAddress;
        }

        public List<FunctionCall> getHeldLockCallStack() {
            return this.oldLockStack;
        }

        public long getRequestedLockAddress() {
            return this.newLockAddress;
        }

        public List<FunctionCall> getRequestedLockCallStack() {
            return this.newLockStack;
        }
    }
}

