/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.tasklist.ErrorAnnotator;
import org.netbeans.modules.java.source.tasklist.JavaTaskProvider;
import org.netbeans.modules.java.source.tasklist.TasklistSettings;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskCache {
    private static final String ERR_EXT = "err";
    private static final String WARN_EXT = "warn";
    private static final Logger LOG = Logger.getLogger(TaskCache.class.getName());
    private static TaskCache theInstance;
    private ThreadLocal<TransactionContext> q = new ThreadLocal();

    private TaskCache() {
    }

    public static TaskCache getDefault() {
        if (null == theInstance) {
            theInstance = new TaskCache();
        }
        return theInstance;
    }

    private String getTaskType(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return "nb-tasklist-error";
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return "nb-tasklist-warning";
            }
        }
        return null;
    }

    public List<Task> getErrors(FileObject fileObject) {
        LinkedList<Task> linkedList = new LinkedList<Task>();
        linkedList.addAll(this.getErrors(fileObject, true));
        linkedList.addAll(this.getErrors(fileObject, false));
        return linkedList;
    }

    private List<Task> getErrors(FileObject fileObject, boolean bl) {
        LOG.log(Level.FINE, "getErrors, file={0}, errors={1}", new Object[]{FileUtil.getFileDisplayName((FileObject)fileObject), bl});
        try {
            File file = this.computePersistentFile(fileObject, bl ? ERR_EXT : WARN_EXT);
            LOG.log(Level.FINE, "getErrors, error file={0}", file == null ? "null" : file.getAbsolutePath());
            if (file == null || !file.canRead()) {
                return Collections.emptyList();
            }
            file.getParentFile().mkdirs();
            return this.loadErrors(file, fileObject);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return Collections.emptyList();
        }
    }

    private boolean dumpErrors(File file, List<? extends Diagnostic> list, boolean bl) throws IOException {
        if (!list.isEmpty()) {
            boolean bl2 = bl && file.exists();
            file.getParentFile().mkdirs();
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            for (Diagnostic diagnostic : list) {
                printWriter.print((Object)diagnostic.getKind());
                printWriter.print(':');
                printWriter.print(diagnostic.getLineNumber());
                printWriter.print(':');
                String string = diagnostic.getMessage(null);
                string = string.replaceAll("\\\\", "\\\\\\\\");
                string = string.replaceAll("\n", "\\\\n");
                string = string.replaceAll(":", "\\\\d");
                printWriter.println(string);
            }
            printWriter.close();
            return !bl2;
        }
        return file.delete();
    }

    private void separate(List<? extends Diagnostic> list, List<Diagnostic> list2, List<Diagnostic> list3) {
        for (Diagnostic diagnostic : list) {
            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                list2.add(diagnostic);
                continue;
            }
            list3.add(diagnostic);
        }
    }

    private static File urlToFile(URL uRL) {
        if ("file".equals(uRL.getProtocol())) {
            try {
                return new File(uRL.toURI().getPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "The caller module provide unencoded URL. Please report this issue against caller module.", uRISyntaxException);
                }
                return new File(uRL.getPath());
            }
        }
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.log(Level.SEVERE, "Url is not a file: " + uRL);
        }
        return null;
    }

    public void dumpErrors(final URL uRL, final URL uRL2, final List<? extends Diagnostic> list) throws IOException {
        this.refreshTransaction(new Mutex.ExceptionAction<Void>(){

            public Void run() throws Exception {
                TaskCache.this.dumpErrors((TransactionContext)TaskCache.this.q.get(), uRL, uRL2, list);
                return null;
            }
        });
    }

    private void dumpErrors(TransactionContext transactionContext, URL uRL, URL uRL2, List<? extends Diagnostic> list) throws IOException {
        File file = TaskCache.urlToFile(uRL2);
        if (file == null) {
            return;
        }
        if (!file.canRead()) {
            list = Collections.emptyList();
        }
        File[] fileArray = this.computePersistentFile(uRL, uRL2);
        LinkedList<Diagnostic> linkedList = new LinkedList<Diagnostic>();
        LinkedList<Diagnostic> linkedList2 = new LinkedList<Diagnostic>();
        this.separate(list, linkedList, linkedList2);
        boolean bl = this.dumpErrors(fileArray[1], linkedList, true);
        this.dumpErrors(fileArray[2], linkedList2, false);
        transactionContext.toRefresh.add(uRL2);
        File file2 = file.getParentFile();
        transactionContext.toRefresh.add(file2.toURI().toURL());
        if (bl) {
            Project project;
            File file3 = fileArray[1].getParentFile();
            while (!fileArray[0].equals(file3)) {
                file3 = file3.getParentFile();
                file2 = file2.getParentFile();
                transactionContext.toRefresh.add(file2.toURI().toURL());
            }
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null) {
                FileObject fileObject2 = project.getProjectDirectory();
                if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
                    for (FileObject fileObject3 = fileObject; fileObject3 != null && fileObject3 != fileObject2; fileObject3 = fileObject3.getParent()) {
                        transactionContext.toRefresh.add(fileObject3.getURL());
                    }
                }
                transactionContext.toRefresh.add(fileObject2.getURL());
            }
        }
        transactionContext.rootsToRefresh.add(uRL);
    }

    private List<Task> loadErrors(File file, FileObject fileObject) throws IOException {
        String string;
        LinkedList<Task> linkedList = new LinkedList<Task>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split(":");
            Diagnostic.Kind kind = Diagnostic.Kind.valueOf(stringArray[0]);
            if (kind == null) continue;
            int n = Integer.parseInt(stringArray[1]);
            String string2 = stringArray[2];
            string2 = string2.replaceAll("\\\\d", ":");
            string2 = string2.replaceAll("\\\\n", " ");
            string2 = string2.replaceAll("\\\\\\\\", "\\\\");
            String string3 = this.getTaskType(kind);
            if (null == string3) continue;
            Task task = Task.create((FileObject)fileObject, (String)string3, (String)string2, (int)n);
            linkedList.add(task);
        }
        bufferedReader.close();
        return linkedList;
    }

    public List<URL> getAllFilesWithRecord(URL uRL) throws IOException {
        return this.getAllFilesWithRecord(uRL, false);
    }

    private List<URL> getAllFilesWithRecord(URL uRL, boolean bl) throws IOException {
        try {
            LinkedList<URL> linkedList = new LinkedList<URL>();
            if (FileUtil.getArchiveFile((URL)uRL) != null) {
                return linkedList;
            }
            URI uRI = uRL.toURI();
            File[] fileArray = this.computePersistentFile(uRL, uRL);
            URI uRI2 = fileArray[0].toURI();
            LinkedList<File> linkedList2 = new LinkedList<File>();
            linkedList2.add(fileArray[0]);
            while (!linkedList2.isEmpty()) {
                Object object;
                File file = (File)linkedList2.poll();
                assert (file != null);
                if (file.isFile()) {
                    if (file.getName().endsWith(ERR_EXT)) {
                        object = uRI2.relativize(file.toURI()).getRawPath();
                        object = ((String)object).replaceAll("err$", "java");
                        linkedList.add(uRI.resolve((String)object).toURL());
                    }
                    if (bl || !file.getName().endsWith(WARN_EXT)) continue;
                    object = uRI2.relativize(file.toURI()).getRawPath();
                    object = ((String)object).replaceAll("warn$", "java");
                    linkedList.add(uRI.resolve((String)object).toURL());
                    continue;
                }
                object = file.listFiles();
                if (object == null) continue;
                for (File file2 : object) {
                    linkedList2.offer(file2);
                }
            }
            return linkedList;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IOException)new IOException().initCause(uRISyntaxException);
        }
    }

    public List<URL> getAllFilesInError(URL uRL) throws IOException {
        return this.getAllFilesWithRecord(uRL, true);
    }

    public boolean isInError(FileObject fileObject, boolean bl) {
        LOG.log(Level.FINE, "file={0}, recursive={1}", new Object[]{fileObject, bl});
        if (fileObject.isData()) {
            return !this.getErrors(fileObject, true).isEmpty();
        }
        try {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (classPath == null) {
                return false;
            }
            FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
            if (fileObject2 == null) {
                LOG.log(Level.FINE, "file={0} does not have a root on its own source classpath", fileObject);
                return false;
            }
            String string = classPath.getResourceName(fileObject, File.separatorChar, false);
            File file = JavaIndex.getClassFolder(fileObject2.getURL(), true);
            if (file == null) {
                return false;
            }
            File file2 = new File(new File(file.getParentFile(), "errors"), string);
            return this.folderContainsErrors(file2, bl);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.WARNING, null, iOException);
            return false;
        }
    }

    private boolean folderContainsErrors(File file, boolean bl) throws IOException {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".err");
            }
        });
        if (fileArray == null) {
            return false;
        }
        if (fileArray.length > 0) {
            return true;
        }
        if (!bl) {
            return false;
        }
        File[] fileArray2 = file.listFiles();
        if (fileArray2 == null) {
            return false;
        }
        for (File file2 : fileArray2) {
            if (!file2.isDirectory() || !this.folderContainsErrors(file2, bl)) continue;
            return true;
        }
        return false;
    }

    private File[] computePersistentFile(URL uRL, URL uRL2) throws IOException {
        try {
            URI uRI = uRL2.toURI();
            URI uRI2 = uRL.toURI();
            String string = uRI2.relativize(uRI).getPath();
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
            }
            File file = JavaIndex.getClassFolder(uRL);
            File file2 = new File(file.getParentFile(), "errors");
            File file3 = new File(file2, string + "." + ERR_EXT);
            File file4 = new File(file2, string + "." + WARN_EXT);
            return new File[]{file2, file3, file4};
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IOException)new IOException().initCause(uRISyntaxException);
        }
    }

    private File computePersistentFile(FileObject fileObject, String string) throws IOException {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
        if (fileObject2 == null) {
            LOG.log(Level.FINE, "file={0} does not have a root on its own source classpath", fileObject);
            return null;
        }
        String string2 = classPath.getResourceName(fileObject, File.separatorChar, false);
        File file = JavaIndex.getClassFolder(fileObject2.getURL());
        File file2 = new File(new File(file.getParentFile(), "errors"), string2 + "." + string);
        return file2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T refreshTransaction(Mutex.ExceptionAction<T> exceptionAction) throws IOException {
        Object object;
        TransactionContext transactionContext = this.q.get();
        if (transactionContext == null) {
            transactionContext = new TransactionContext();
            this.q.set(transactionContext);
        }
        transactionContext.depth++;
        try {
            try {
                object = exceptionAction.run();
                Object var5_6 = null;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw (IOException)new IOException(exception.getMessage()).initCause(exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (--transactionContext.depth != 0) throw throwable;
            TaskCache.doRefresh(transactionContext);
            this.q.set(null);
            throw throwable;
        }
        if (--transactionContext.depth != 0) return (T)object;
        TaskCache.doRefresh(transactionContext);
        this.q.set(null);
        return (T)object;
    }

    private static void doRefresh(TransactionContext transactionContext) {
        Object object;
        if (TasklistSettings.isBadgesEnabled() && !transactionContext.toRefresh.isEmpty() && (object = ErrorAnnotator.getAnnotator()) != null) {
            ((ErrorAnnotator)((Object)object)).updateInError(transactionContext.toRefresh);
        }
        for (URL uRL : transactionContext.rootsToRefresh) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null) continue;
            JavaTaskProvider.refresh(fileObject);
        }
    }

    private static final class TransactionContext {
        private int depth;
        private Set<URL> toRefresh = new HashSet<URL>();
        private Set<URL> rootsToRefresh = new HashSet<URL>();

        private TransactionContext() {
        }
    }
}

