/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.tools.javac.tree.JCTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.save.CasualDiff;
import org.netbeans.modules.java.source.transform.FieldGroupTree;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PositionEstimator {
    public static final int NOPOS = -2;
    final List<? extends Tree> oldL;
    final List<? extends Tree> newL;
    final WorkingCopy copy;
    boolean initialized;
    final TokenSequence<JavaTokenId> seq;
    GuardedSectionManager guards;
    int[][] matrix;
    public static final EnumSet<JavaTokenId> nonRelevant = EnumSet.of(JavaTokenId.LINE_COMMENT, JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.WHITESPACE);

    PositionEstimator(List<? extends Tree> list, List<? extends Tree> list2, WorkingCopy workingCopy) {
        this.oldL = list;
        this.newL = list2;
        this.copy = workingCopy;
        this.seq = workingCopy != null ? workingCopy.getTokenHierarchy().tokenSequence(JavaTokenId.language()) : null;
        try {
            this.guards = workingCopy.getDocument() != null ? GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)workingCopy.getDocument())) : null;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.initialized = false;
    }

    protected abstract void initialize();

    public abstract int getInsertPos(int var1);

    public abstract int[] getPositions(int var1);

    abstract int prepare(int var1, StringBuilder var2, StringBuilder var3);

    public abstract int[] sectionRemovalBounds(StringBuilder var1);

    public CasualDiff.LineInsertionType lineInsertType() {
        return CasualDiff.LineInsertionType.NONE;
    }

    public abstract String head();

    public abstract String sep();

    public abstract String getIndentString();

    public String append(int n) {
        return "";
    }

    public int[][] getMatrix() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.matrix;
    }

    int moveBelowGuarded(int n) {
        if (this.guards != null) {
            for (GuardedSection guardedSection : this.guards.getGuardedSections()) {
                if (n == guardedSection.getStartPosition().getOffset()) {
                    return n - 1;
                }
                if (n <= guardedSection.getStartPosition().getOffset() || n > guardedSection.getEndPosition().getOffset()) continue;
                this.seq.move(n);
                while (this.seq.moveNext() && nonRelevant.contains(this.seq.token().id())) {
                }
                if (this.seq.offset() < guardedSection.getEndPosition().getOffset()) {
                    return n;
                }
                return guardedSection.getEndPosition().getOffset() + 1;
            }
        }
        return n;
    }

    public static JavaTokenId moveToSrcRelevant(TokenSequence<JavaTokenId> tokenSequence, Direction direction) {
        return PositionEstimator.moveToDifferentThan(tokenSequence, direction, nonRelevant);
    }

    public static JavaTokenId moveToDifferentThan(TokenSequence<JavaTokenId> tokenSequence, Direction direction, EnumSet<JavaTokenId> enumSet) {
        boolean bl = false;
        switch (direction) {
            case BACKWARD: {
                while ((bl = tokenSequence.movePrevious()) && enumSet.contains(tokenSequence.token().id())) {
                }
                break;
            }
            case FORWARD: {
                while ((bl = tokenSequence.moveNext()) && enumSet.contains(tokenSequence.token().id())) {
                }
                break;
            }
        }
        return bl ? (JavaTokenId)tokenSequence.token().id() : null;
    }

    private static int goAfterFirstNewLine(TokenSequence<JavaTokenId> tokenSequence) {
        if (tokenSequence.token() == null) {
            tokenSequence.movePrevious();
        }
        int n = tokenSequence.offset();
        tokenSequence.movePrevious();
        while (tokenSequence.moveNext() && nonRelevant.contains(tokenSequence.token().id())) {
            switch ((JavaTokenId)tokenSequence.token().id()) {
                case LINE_COMMENT: {
                    tokenSequence.moveNext();
                    return tokenSequence.offset();
                }
                case WHITESPACE: {
                    char[] cArray = ((Object)tokenSequence.token().text()).toString().toCharArray();
                    int n2 = 0;
                    while (n2 < cArray.length) {
                        if (cArray[n2++] != '\n') continue;
                        return n + n2;
                    }
                    break;
                }
            }
        }
        return n;
    }

    private static int goAfterLastNewLine(TokenSequence<JavaTokenId> tokenSequence) {
        int n = tokenSequence.offset();
        tokenSequence.movePrevious();
        while (tokenSequence.moveNext() && nonRelevant.contains(tokenSequence.token().id())) {
        }
        while (tokenSequence.movePrevious() && nonRelevant.contains(tokenSequence.token().id())) {
            switch ((JavaTokenId)tokenSequence.token().id()) {
                case LINE_COMMENT: {
                    tokenSequence.moveNext();
                    return tokenSequence.offset();
                }
                case WHITESPACE: {
                    char[] cArray = ((Object)tokenSequence.token().text()).toString().toCharArray();
                    int n2 = cArray.length;
                    while (n2 > 0) {
                        if (cArray[--n2] != '\n') continue;
                        return tokenSequence.offset() + n2 + 1;
                    }
                    break;
                }
            }
        }
        if ((tokenSequence.index() == 0 || tokenSequence.moveNext()) && nonRelevant.contains(tokenSequence.token().id())) {
            return tokenSequence.offset();
        }
        return n;
    }

    public static final boolean isSeparator(JavaTokenId javaTokenId) {
        return "separator".equals(javaTokenId.primaryCategory());
    }

    static int moveFwdToToken(TokenSequence<JavaTokenId> tokenSequence, int n, JavaTokenId javaTokenId) {
        tokenSequence.move(n);
        tokenSequence.moveNext();
        while (!javaTokenId.equals((Object)tokenSequence.token().id())) {
            if (tokenSequence.moveNext()) continue;
            return -1;
        }
        return tokenSequence.offset();
    }

    static int moveBackToToken(TokenSequence<JavaTokenId> tokenSequence, int n, JavaTokenId javaTokenId) {
        tokenSequence.move(n);
        tokenSequence.moveNext();
        while (!javaTokenId.equals((Object)tokenSequence.token().id())) {
            if (tokenSequence.movePrevious()) continue;
            return -1;
        }
        return tokenSequence.offset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        FORWARD,
        BACKWARD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TopLevelEstimator
    extends PositionEstimator {
        private List<int[]> data;

        public TopLevelEstimator(List<? extends Tree> list, List<? extends Tree> list2, WorkingCopy workingCopy) {
            super(list, list2, workingCopy);
        }

        @Override
        public void initialize() {
            int n = this.oldL.size();
            this.data = new ArrayList<int[]>(n);
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            for (Tree tree : this.oldL) {
                int n2;
                int n3;
                int n4;
                Token token;
                int n5 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
                int n6 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
                this.seq.move(n5);
                this.seq.moveNext();
                if (null != TopLevelEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD)) {
                    this.seq.moveNext();
                }
                int n7 = this.seq.offset();
                while (nonRelevant.contains((token = this.seq.token()).id())) {
                    n4 = -1;
                    switch ((JavaTokenId)token.id()) {
                        case WHITESPACE: {
                            n3 = ((Object)token.text()).toString().indexOf(10);
                            if (n3 <= -1) break;
                            n4 = this.seq.offset() + n3 + 1;
                            break;
                        }
                        case LINE_COMMENT: {
                            n7 = this.seq.offset() + token.text().length();
                            break;
                        }
                        case JAVADOC_COMMENT: {
                            n7 = this.seq.offset();
                        }
                    }
                    if (n4 > 0) {
                        n7 = n4;
                        break;
                    }
                    if (this.seq.moveNext()) continue;
                    break;
                }
                n4 = n7;
                this.seq.move(n5);
                this.seq.moveNext();
                this.seq.movePrevious();
                while (nonRelevant.contains((token = this.seq.token()).id())) {
                    n3 = -1;
                    switch ((JavaTokenId)token.id()) {
                        case WHITESPACE: {
                            n2 = ((Object)token.text()).toString().lastIndexOf(10);
                            if (n2 <= -1) break;
                            n3 = this.seq.offset() + n2 + 1;
                            break;
                        }
                        case LINE_COMMENT: {
                            n3 = this.seq.offset() + token.text().length();
                            break;
                        }
                        case JAVADOC_COMMENT: 
                        case BLOCK_COMMENT: {
                            n4 = this.seq.offset();
                        }
                    }
                    if (n4 > n7) break;
                    if (n3 > 0) {
                        n4 = n3;
                    }
                    if (this.seq.movePrevious()) continue;
                    break;
                }
                this.seq.move(n6);
                n3 = n6;
                while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                    if (JavaTokenId.WHITESPACE == token.id()) {
                        n2 = ((Object)token.text()).toString().indexOf(10);
                        n3 = n2 > -1 ? this.seq.offset() + n2 + 1 : this.seq.offset();
                    } else {
                        if (JavaTokenId.LINE_COMMENT == token.id()) {
                            n3 = this.seq.offset() + token.text().length();
                            break;
                        }
                        if (JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                    }
                    if (n3 <= n6) continue;
                }
                if (n3 < n6) {
                    n3 = n6;
                }
                this.data.add(new int[]{n4, n3, n7});
            }
            this.initialized = true;
        }

        @Override
        public int getInsertPos(int n) {
            if (!this.initialized) {
                this.initialize();
            }
            if (this.data.isEmpty()) {
                return -1;
            }
            return n == this.data.size() ? this.data.get(n - 1)[2] : this.data.get(n)[0];
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder stringBuilder) {
            int n;
            Token token;
            if (!this.initialized) {
                this.initialize();
            }
            assert (!this.oldL.isEmpty() && this.newL.isEmpty());
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            int n2 = (int)sourcePositions.getStartPosition(compilationUnitTree, (Tree)this.oldL.get(0));
            int n3 = (int)sourcePositions.getEndPosition(compilationUnitTree, (Tree)this.oldL.get(this.oldL.size() - 1));
            this.seq.move(n2);
            this.seq.moveNext();
            while (this.seq.movePrevious() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    this.seq.moveNext();
                    n2 = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                n = ((Object)token.text()).toString().indexOf(10);
                if (n > -1) {
                    n2 = this.seq.offset() + n + 1;
                    continue;
                }
                n2 = this.seq.offset();
            }
            this.seq.move(n3);
            this.seq.movePrevious();
            while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    n3 = this.seq.offset();
                    if (!this.seq.moveNext()) break;
                    n3 = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                n = ((Object)token.text()).toString().lastIndexOf(10);
                if (n > -1) {
                    n3 = this.seq.offset() + n + 1;
                    continue;
                }
                n3 += this.seq.offset() + token.text().length();
            }
            return new int[]{n2, n3};
        }

        @Override
        public String head() {
            return "";
        }

        @Override
        public String sep() {
            return "";
        }

        @Override
        public String getIndentString() {
            return "";
        }

        @Override
        public int[] getPositions(int n) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.data.get(n);
        }

        @Override
        public CasualDiff.LineInsertionType lineInsertType() {
            return CasualDiff.LineInsertionType.AFTER;
        }

        @Override
        public int prepare(int n, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            this.seq.moveEnd();
            if (this.seq.movePrevious()) {
                if (JavaTokenId.WHITESPACE == this.seq.token().id()) {
                    int n2 = -1;
                    String string = ((Object)this.seq.token().text()).toString();
                    n2 = string.indexOf(10);
                    if (n2 > -1) {
                        if (string.lastIndexOf(10) == n2) {
                            stringBuilder.append('\n');
                        }
                    } else {
                        stringBuilder.append("\n\n");
                    }
                } else if (JavaTokenId.LINE_COMMENT != this.seq.token().id()) {
                    stringBuilder.append("\n\n");
                }
                return this.seq.offset() + this.seq.token().text().length();
            }
            return n;
        }

        public String toString() {
            if (!this.initialized) {
                this.initialize();
            }
            String string = "";
            for (int i = 0; i < this.data.size(); ++i) {
                int[] nArray = this.data.get(i);
                String string2 = this.copy.getText().substring(nArray[0], nArray[1]);
                string = string + "[" + string2 + "]";
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CatchesEstimator
    extends PositionEstimator {
        private List<int[]> data;

        public CatchesEstimator(List<? extends Tree> list, List<? extends Tree> list2, WorkingCopy workingCopy) {
            super(list, list2, workingCopy);
        }

        @Override
        public void initialize() {
            int n = this.oldL.size();
            this.data = new ArrayList<int[]>(n);
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            for (Tree tree : this.oldL) {
                Token token;
                int n2 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
                int n3 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
                this.seq.move(n2);
                this.seq.moveNext();
                if (null != CatchesEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD)) {
                    this.seq.moveNext();
                }
                int n4 = this.seq.offset();
                while (nonRelevant.contains((token = this.seq.token()).id())) {
                    int n5 = -1;
                    switch ((JavaTokenId)token.id()) {
                        case WHITESPACE: {
                            int n6 = ((Object)token.text()).toString().indexOf(10);
                            if (n6 <= -1) break;
                            n5 = this.seq.offset() + n6 + 1;
                            break;
                        }
                        case LINE_COMMENT: {
                            n4 = this.seq.offset() + token.text().length();
                        }
                    }
                    if (n5 > 0) {
                        n4 = n5;
                        break;
                    }
                    if (this.seq.moveNext()) continue;
                    break;
                }
                this.data.add(new int[]{n4, n3, n4});
            }
            this.initialized = true;
        }

        @Override
        public int getInsertPos(int n) {
            if (!this.initialized) {
                this.initialize();
            }
            if (this.data.isEmpty()) {
                return -1;
            }
            return n == this.data.size() ? this.data.get(n - 1)[2] : this.data.get(n)[0];
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder stringBuilder) {
            int n;
            Token token;
            if (!this.initialized) {
                this.initialize();
            }
            assert (!this.oldL.isEmpty() && this.newL.isEmpty());
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            int n2 = (int)sourcePositions.getStartPosition(compilationUnitTree, (Tree)this.oldL.get(0));
            int n3 = (int)sourcePositions.getEndPosition(compilationUnitTree, (Tree)this.oldL.get(this.oldL.size() - 1));
            this.seq.move(n2);
            this.seq.moveNext();
            while (this.seq.movePrevious() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    this.seq.moveNext();
                    n2 = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                n = ((Object)token.text()).toString().indexOf(10);
                if (n > -1) {
                    n2 = this.seq.offset() + n + 1;
                    continue;
                }
                n2 = this.seq.offset();
            }
            this.seq.move(n3);
            this.seq.movePrevious();
            while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    n3 = this.seq.offset();
                    if (!this.seq.moveNext()) break;
                    n3 = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                n = ((Object)token.text()).toString().lastIndexOf(10);
                if (n > -1) {
                    n3 = this.seq.offset() + n + 1;
                    continue;
                }
                n3 += this.seq.offset() + token.text().length();
            }
            return new int[]{n2, n3};
        }

        @Override
        public String head() {
            return "";
        }

        @Override
        public String sep() {
            return "";
        }

        @Override
        public String getIndentString() {
            return "";
        }

        @Override
        public int[] getPositions(int n) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.data.get(n);
        }

        @Override
        public int prepare(int n, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            this.seq.move(n);
            this.seq.moveNext();
            CatchesEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD);
            while (this.seq.moveNext() && nonRelevant.contains(this.seq.token().id())) {
                if (JavaTokenId.WHITESPACE == this.seq.token().id()) {
                    int n2 = ((Object)this.seq.token().text()).toString().indexOf(10);
                    if (n2 <= -1) continue;
                    return this.seq.offset() + n2 + 1;
                }
                if (JavaTokenId.LINE_COMMENT != this.seq.token().id()) continue;
                return this.seq.offset() + this.seq.token().text().length();
            }
            return n;
        }

        public String toString() {
            if (!this.initialized) {
                this.initialize();
            }
            String string = "";
            for (int i = 0; i < this.data.size(); ++i) {
                int[] nArray = this.data.get(i);
                String string2 = this.copy.getText().substring(nArray[0], nArray[1]);
                string = string + "[" + string2 + "]";
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MembersEstimator
    extends PositionEstimator {
        private List<int[]> data;
        private List<String> append;
        private int minimalLeftPosition;

        public MembersEstimator(List<? extends Tree> list, List<? extends Tree> list2, WorkingCopy workingCopy) {
            super(list, list2, workingCopy);
            this.minimalLeftPosition = -1;
        }

        public MembersEstimator(List<? extends Tree> list, List<? extends Tree> list2, int n, WorkingCopy workingCopy) {
            super(list, list2, workingCopy);
            this.minimalLeftPosition = n;
        }

        @Override
        public void initialize() {
            int n = this.oldL.size();
            this.data = new ArrayList<int[]>(n);
            this.append = new ArrayList<String>(n);
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            for (Tree tree : this.oldL) {
                int n2;
                int n3;
                Token token;
                Object object;
                int n4 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
                int n5 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
                if (tree instanceof FieldGroupTree) {
                    object = (FieldGroupTree)tree;
                    List<JCTree.JCVariableDecl> list = ((FieldGroupTree)object).getVariables();
                    n5 = (int)sourcePositions.getEndPosition(compilationUnitTree, list.get(list.size() - 1));
                } else {
                    this.seq.move(n5);
                    if (this.seq.movePrevious() && nonRelevant.contains(this.seq.token().id())) {
                        MembersEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD);
                        this.seq.moveNext();
                        n5 = this.seq.offset();
                    }
                }
                object = "";
                int n6 = -1;
                if (this.isEnum(tree)) {
                    this.seq.move(n5);
                    MembersEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.FORWARD);
                    if (JavaTokenId.COMMA == this.seq.token().id()) {
                        n5 = this.seq.offset() + this.seq.token().length();
                        MembersEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.FORWARD);
                    }
                    if (JavaTokenId.SEMICOLON == this.seq.token().id()) {
                        this.seq.moveNext();
                    } else {
                        object = ";";
                        n6 = n5;
                    }
                    n5 = this.seq.offset();
                }
                this.seq.move(n4);
                this.seq.moveNext();
                if (null != MembersEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD)) {
                    this.seq.moveNext();
                }
                int n7 = this.seq.offset();
                while (nonRelevant.contains((token = this.seq.token()).id())) {
                    n3 = -1;
                    switch ((JavaTokenId)token.id()) {
                        case WHITESPACE: {
                            n2 = ((Object)token.text()).toString().indexOf(10);
                            if (n2 <= -1) break;
                            n3 = this.seq.offset() + n2 + 1;
                            break;
                        }
                        case LINE_COMMENT: {
                            n7 = this.seq.offset() + token.text().length();
                        }
                    }
                    if (n3 > 0) {
                        n7 = n3;
                        break;
                    }
                    if (this.seq.moveNext()) continue;
                    break;
                }
                if (this.minimalLeftPosition != -1 && this.minimalLeftPosition > n7) {
                    n7 = this.minimalLeftPosition;
                }
                this.seq.move(n5);
                n3 = n5;
                while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                    if (JavaTokenId.WHITESPACE == token.id()) {
                        n2 = ((Object)token.text()).toString().indexOf(10);
                        n3 = n2 > -1 ? this.seq.offset() + n2 + 1 : this.seq.offset();
                    } else {
                        if (JavaTokenId.LINE_COMMENT == token.id()) {
                            n3 = this.seq.offset() + token.text().length();
                            break;
                        }
                        if (JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                    }
                    if (n3 <= n5) continue;
                }
                if (n3 < n5) {
                    n3 = n5;
                }
                this.data.add(new int[]{n7, n3, n7, n6});
                this.append.add((String)object);
            }
            this.initialized = true;
        }

        private boolean isEnum(Tree tree) {
            if (tree instanceof FieldGroupTree) {
                return ((FieldGroupTree)tree).isEnum();
            }
            if (tree instanceof VariableTree) {
                return (((JCTree.JCVariableDecl)tree).getModifiers().flags & 0x4000L) != 0L;
            }
            return false;
        }

        @Override
        public int getInsertPos(int n) {
            if (!this.initialized) {
                this.initialize();
            }
            if (this.data.isEmpty()) {
                return -1;
            }
            int n2 = n == this.data.size() ? this.data.get(n - 1)[1] : this.data.get(n)[0];
            return this.moveBelowGuarded(n2);
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder stringBuilder) {
            int n;
            Token token;
            if (!this.initialized) {
                this.initialize();
            }
            assert (!this.oldL.isEmpty() && this.newL.isEmpty());
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            int n2 = (int)sourcePositions.getStartPosition(compilationUnitTree, (Tree)this.oldL.get(0));
            int n3 = (int)sourcePositions.getEndPosition(compilationUnitTree, (Tree)this.oldL.get(this.oldL.size() - 1));
            this.seq.move(n2);
            this.seq.moveNext();
            while (this.seq.movePrevious() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    this.seq.moveNext();
                    n2 = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id() || JavaTokenId.WHITESPACE != token.id()) continue;
                n = ((Object)token.text()).toString().indexOf(10);
                if (n > -1) {
                    n2 = this.seq.offset() + n + 1;
                    continue;
                }
                n2 = this.seq.offset();
            }
            this.seq.move(n3);
            this.seq.movePrevious();
            while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    n3 = this.seq.offset();
                    if (!this.seq.moveNext()) break;
                    n3 = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                n = ((Object)token.text()).toString().lastIndexOf(10);
                if (n > -1) {
                    n3 = this.seq.offset() + n + 1;
                    continue;
                }
                n3 += this.seq.offset() + token.text().length();
            }
            return new int[]{n2, n3};
        }

        @Override
        public String head() {
            return "";
        }

        @Override
        public String sep() {
            return "";
        }

        @Override
        public String getIndentString() {
            return "";
        }

        @Override
        public String append(int n) {
            return this.append.get(n);
        }

        @Override
        public int[] getPositions(int n) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.data.get(n);
        }

        @Override
        public CasualDiff.LineInsertionType lineInsertType() {
            return CasualDiff.LineInsertionType.AFTER;
        }

        @Override
        public int prepare(int n, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            this.seq.move(n);
            this.seq.moveNext();
            MembersEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD);
            while (this.seq.moveNext() && nonRelevant.contains(this.seq.token().id())) {
                if (JavaTokenId.WHITESPACE == this.seq.token().id()) {
                    int n2 = ((Object)this.seq.token().text()).toString().indexOf(10);
                    if (n2 <= -1) continue;
                    return this.seq.offset() + n2 + 1;
                }
                if (JavaTokenId.LINE_COMMENT != this.seq.token().id()) continue;
                return this.seq.offset() + this.seq.token().text().length();
            }
            return n;
        }

        public String toString() {
            if (!this.initialized) {
                this.initialize();
            }
            String string = "";
            for (int i = 0; i < this.data.size(); ++i) {
                int[] nArray = this.data.get(i);
                String string2 = this.copy.getText().substring(nArray[0], nArray[1]);
                string = string + "[" + string2 + "]";
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BaseEstimator
    extends PositionEstimator {
        JavaTokenId precToken;
        private ArrayList<String> separatorList;

        private BaseEstimator(JavaTokenId javaTokenId, List<? extends Tree> list, List<? extends Tree> list2, WorkingCopy workingCopy) {
            super(list, list2, workingCopy);
            this.precToken = javaTokenId;
        }

        @Override
        public String head() {
            return " " + this.precToken.fixedText() + " ";
        }

        @Override
        public String sep() {
            return ", ";
        }

        @Override
        public void initialize() {
            this.separatorList = new ArrayList(this.oldL.size());
            boolean bl = true;
            int n = this.oldL.size();
            this.matrix = new int[n + 1][5];
            this.matrix[n] = new int[]{-1, -1, -1, -1, -1};
            int n2 = 0;
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            for (Tree tree : this.oldL) {
                int n3;
                int n4;
                String string = "";
                int n5 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
                int n6 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
                this.seq.move(n5);
                int n7 = this.seq.index();
                int n8 = -1;
                if (bl) {
                    while (this.seq.movePrevious() && this.seq.token().id() != this.precToken) {
                    }
                    n4 = this.seq.index();
                    n8 = n4 + 1;
                    BaseEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD);
                    this.seq.moveNext();
                    n3 = this.seq.index();
                    this.seq.move(n6);
                    this.matrix[n2++] = new int[]{n3, n4, n8, n7, this.seq.index()};
                    bl = false;
                } else {
                    n4 = this.matrix[n2 - 1][4];
                    while (this.seq.movePrevious() && this.seq.token().id() != JavaTokenId.COMMA) {
                        if (this.seq.token().id() == JavaTokenId.WHITESPACE) {
                            string = this.seq.token().text() + string;
                            continue;
                        }
                        if (this.seq.token().id() != JavaTokenId.LINE_COMMENT) continue;
                        string = '\n' + string;
                    }
                    this.separatorList.add(string);
                    n3 = this.seq.index();
                    int n9 = n3 + 1;
                    if (n4 == n3) {
                        n4 = -1;
                    }
                    this.seq.move(n6);
                    this.matrix[n2++] = new int[]{n4, n3, n9, n7, this.seq.index()};
                }
                if (n2 == n) {
                    BaseEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.FORWARD);
                    this.matrix[n2][2] = this.seq.index();
                }
                this.seq.move(n6);
            }
            this.initialized = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getIndentString() {
            void var3_6;
            if (!this.initialized) {
                this.initialize();
            }
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (String object2 : this.separatorList) {
                Object object;
                Object object3 = object2;
                if (((String)object3).lastIndexOf("\n") > -1) {
                    object3 = ((String)object3).substring(object2.lastIndexOf("\n"));
                }
                if ((object = (Integer)hashMap.get(object3)) != null) {
                    Object object4 = object;
                    object = (Integer)object + 1;
                    Integer n = object;
                    hashMap.put(object3, object4);
                    continue;
                }
                hashMap.put(object3, 1);
            }
            int n = -1;
            Object var3_5 = null;
            for (Object object : hashMap.keySet()) {
                if ((Integer)hashMap.get(object) <= n) continue;
                Object object5 = object;
                n = (Integer)hashMap.get(object);
            }
            return var3_6;
        }

        @Override
        public int getInsertPos(int n) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int[] getPositions(int n) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int prepare(int n, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder stringBuilder) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AnnotationsEstimator
    extends PositionEstimator {
        public AnnotationsEstimator(List<? extends Tree> list, List<? extends Tree> list2, WorkingCopy workingCopy) {
            super(list, list2, workingCopy);
        }

        @Override
        public void initialize() {
            int n = this.oldL.size();
            this.matrix = new int[n + 1][5];
            this.matrix[n] = new int[]{-1, -1, -1, -1, -1};
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            int n2 = 0;
            for (Tree tree : this.oldL) {
                int n3 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
                int n4 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
                if (n4 < 0) continue;
                this.seq.move(n3);
                int n5 = this.seq.index();
                AnnotationsEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD);
                this.seq.moveNext();
                int n6 = this.seq.index();
                this.seq.move(n4);
                this.matrix[n2++] = new int[]{n6, n6, n6, n5, this.seq.index()};
                if (n2 != n) continue;
                this.seq.move(n4);
                this.matrix[n2][2] = this.seq.index();
            }
        }

        @Override
        public int getInsertPos(int n) {
            int n2;
            if (!this.initialized) {
                this.initialize();
            }
            if ((n2 = this.matrix[n][2]) == -1) {
                return -1;
            }
            this.seq.moveIndex(n2);
            this.seq.moveNext();
            int n3 = PositionEstimator.goAfterLastNewLine((TokenSequence<JavaTokenId>)this.seq);
            return n3;
        }

        @Override
        public String head() {
            return "";
        }

        @Override
        public String sep() {
            return "";
        }

        @Override
        public String getIndentString() {
            return "";
        }

        @Override
        public int[] getPositions(int n) {
            if (!this.initialized) {
                this.initialize();
            }
            int n2 = this.getInsertPos(n);
            if (this.matrix[n][4] != -1) {
                this.seq.moveIndex(this.matrix[n][4]);
                this.seq.moveNext();
            }
            int n3 = PositionEstimator.goAfterFirstNewLine((TokenSequence<JavaTokenId>)this.seq);
            return new int[]{n2, n3};
        }

        @Override
        public CasualDiff.LineInsertionType lineInsertType() {
            return CasualDiff.LineInsertionType.AFTER;
        }

        @Override
        public int prepare(int n, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            return n;
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder stringBuilder) {
            int n;
            Token token;
            if (!this.initialized) {
                this.initialize();
            }
            assert (!this.oldL.isEmpty() && this.newL.isEmpty());
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            int n2 = (int)sourcePositions.getStartPosition(compilationUnitTree, (Tree)this.oldL.get(0));
            int n3 = (int)sourcePositions.getEndPosition(compilationUnitTree, (Tree)this.oldL.get(this.oldL.size() - 1));
            this.seq.move(n2);
            this.seq.moveNext();
            while (this.seq.movePrevious() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    this.seq.moveNext();
                    n2 = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                n = ((Object)token.text()).toString().lastIndexOf(10);
                if (n > -1) {
                    n2 = this.seq.offset() + n + 1;
                    continue;
                }
                n2 = this.seq.offset();
            }
            this.seq.move(n3);
            this.seq.movePrevious();
            while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    n3 = this.seq.offset();
                    if (!this.seq.moveNext()) break;
                    n3 = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                n = ((Object)token.text()).toString().lastIndexOf(10);
                if (n > -1) {
                    n3 = this.seq.offset() + n + 1;
                    continue;
                }
                n3 += this.seq.offset() + token.text().length();
            }
            return new int[]{n2, n3};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CasesEstimator
    extends PositionEstimator {
        private List<int[]> data;

        public CasesEstimator(List<? extends Tree> list, List<? extends Tree> list2, WorkingCopy workingCopy) {
            super(list, list2, workingCopy);
        }

        @Override
        public void initialize() {
            int n = this.oldL.size();
            this.data = new ArrayList<int[]>(n);
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            for (Tree tree : this.oldL) {
                int n2;
                int n3;
                Token token;
                int n4 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
                int n5 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
                this.seq.move(n4);
                this.seq.moveNext();
                if (null != CasesEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD)) {
                    this.seq.moveNext();
                }
                int n6 = this.seq.offset();
                while (nonRelevant.contains((token = this.seq.token()).id())) {
                    n3 = -1;
                    switch ((JavaTokenId)token.id()) {
                        case WHITESPACE: {
                            n2 = ((Object)token.text()).toString().indexOf(10);
                            if (n2 <= -1) break;
                            n3 = this.seq.offset() + n2 + 1;
                            break;
                        }
                        case LINE_COMMENT: {
                            n6 = this.seq.offset() + token.text().length();
                        }
                    }
                    if (n3 > 0) {
                        n6 = n3;
                        break;
                    }
                    if (this.seq.moveNext()) continue;
                    break;
                }
                this.seq.move(n5);
                n3 = n5;
                while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                    if (JavaTokenId.WHITESPACE == token.id()) {
                        n2 = ((Object)token.text()).toString().indexOf(10);
                        n3 = n2 > -1 ? this.seq.offset() + n2 + 1 : this.seq.offset();
                    } else {
                        if (JavaTokenId.LINE_COMMENT == token.id()) {
                            n3 = this.seq.offset() + token.text().length();
                            break;
                        }
                        if (JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                    }
                    if (n3 <= n5) continue;
                }
                if (n3 < n5) {
                    n3 = n5;
                }
                this.data.add(new int[]{n6, n3, n6});
            }
            this.initialized = true;
        }

        @Override
        public int getInsertPos(int n) {
            if (!this.initialized) {
                this.initialize();
            }
            if (this.data.isEmpty()) {
                return -1;
            }
            return n == this.data.size() ? this.data.get(n - 1)[2] : this.data.get(n)[0];
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder stringBuilder) {
            int n;
            Token token;
            if (!this.initialized) {
                this.initialize();
            }
            assert (!this.oldL.isEmpty() && this.newL.isEmpty());
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            int n2 = (int)sourcePositions.getStartPosition(compilationUnitTree, (Tree)this.oldL.get(0));
            int n3 = (int)sourcePositions.getEndPosition(compilationUnitTree, (Tree)this.oldL.get(this.oldL.size() - 1));
            this.seq.move(n2);
            this.seq.moveNext();
            while (this.seq.movePrevious() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    this.seq.moveNext();
                    n2 = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                n = ((Object)token.text()).toString().indexOf(10);
                if (n > -1) {
                    n2 = this.seq.offset() + n + 1;
                    continue;
                }
                n2 = this.seq.offset();
            }
            this.seq.move(n3);
            this.seq.movePrevious();
            while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    n3 = this.seq.offset();
                    if (!this.seq.moveNext()) break;
                    n3 = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                n = ((Object)token.text()).toString().lastIndexOf(10);
                if (n > -1) {
                    n3 = this.seq.offset() + n + 1;
                    continue;
                }
                n3 += this.seq.offset() + token.text().length();
            }
            return new int[]{n2, n3};
        }

        @Override
        public String head() {
            return "";
        }

        @Override
        public String sep() {
            return "";
        }

        @Override
        public String getIndentString() {
            return "";
        }

        @Override
        public int[] getPositions(int n) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.data.get(n);
        }

        @Override
        public int prepare(int n, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            this.seq.move(n);
            this.seq.moveNext();
            CasesEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD);
            while (this.seq.moveNext() && nonRelevant.contains(this.seq.token().id())) {
                if (JavaTokenId.WHITESPACE == this.seq.token().id()) {
                    int n2 = ((Object)this.seq.token().text()).toString().indexOf(10);
                    if (n2 <= -1) continue;
                    return this.seq.offset() + n2 + 1;
                }
                if (JavaTokenId.LINE_COMMENT != this.seq.token().id()) continue;
                return this.seq.offset() + this.seq.token().text().length();
            }
            return n;
        }

        public String toString() {
            if (!this.initialized) {
                this.initialize();
            }
            String string = "";
            for (int i = 0; i < this.data.size(); ++i) {
                int[] nArray = this.data.get(i);
                String string2 = this.copy.getText().substring(nArray[0], nArray[1]);
                string = string + "[" + string2 + "]";
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImportsEstimator
    extends PositionEstimator {
        List<int[]> data;

        public ImportsEstimator(List<? extends ImportTree> list, List<? extends ImportTree> list2, WorkingCopy workingCopy) {
            super(list, list2, workingCopy);
        }

        @Override
        public void initialize() {
            int n = this.oldL.size();
            this.data = new ArrayList<int[]>(n);
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            for (Tree tree : this.oldL) {
                int n2;
                int n3;
                Token token;
                int n4 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
                int n5 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
                this.seq.move(n4);
                this.seq.moveNext();
                int n6 = PositionEstimator.goAfterLastNewLine((TokenSequence<JavaTokenId>)this.seq);
                this.seq.move(n4);
                this.seq.moveNext();
                if (null != ImportsEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD)) {
                    this.seq.moveNext();
                }
                int n7 = this.seq.offset();
                while (nonRelevant.contains((token = this.seq.token()).id())) {
                    n3 = -1;
                    switch ((JavaTokenId)token.id()) {
                        case WHITESPACE: {
                            n2 = ((Object)token.text()).toString().indexOf(10);
                            if (n2 <= 0) break;
                            n3 = this.seq.offset() + n2 + 1;
                            break;
                        }
                        case LINE_COMMENT: {
                            n7 = this.seq.offset() + token.text().length();
                        }
                    }
                    if (n3 > 0) {
                        n7 = n3;
                        break;
                    }
                    if (this.seq.moveNext()) continue;
                    break;
                }
                this.seq.move(n5);
                n3 = n5;
                while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                    if (JavaTokenId.WHITESPACE == token.id()) {
                        n2 = ((Object)token.text()).toString().indexOf(10);
                        if (n2 > -1) {
                            n3 = this.seq.offset() + n2 + 1;
                            break;
                        }
                        n3 = this.seq.offset();
                        continue;
                    }
                    if (JavaTokenId.LINE_COMMENT == token.id()) {
                        n3 = this.seq.offset() + token.text().length();
                        break;
                    }
                    if (JavaTokenId.JAVADOC_COMMENT != token.id()) continue;
                }
                if (n3 < n5) {
                    n3 = n5;
                }
                this.data.add(new int[]{n6, n3, n7});
            }
            this.initialized = true;
        }

        @Override
        public int getInsertPos(int n) {
            if (!this.initialized) {
                this.initialize();
            }
            if (this.data.isEmpty()) {
                return -1;
            }
            return n == this.data.size() ? this.data.get(n - 1)[2] : this.data.get(n)[0];
        }

        @Override
        public int prepare(int n, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            if (!this.initialized) {
                this.initialize();
            }
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            int n2 = 0;
            if (compilationUnitTree.getTypeDecls().isEmpty()) {
                return this.copy.getText().length();
            }
            Tree tree = compilationUnitTree.getTypeDecls().get(0);
            Object object = this.copy.getTrees().getSourcePositions();
            int n3 = (int)object.getStartPosition(compilationUnitTree, tree);
            this.seq.move(n3);
            if (null == ImportsEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD)) {
                return 0;
            }
            n2 = this.seq.offset() + this.seq.token().length();
            int n4 = 0;
            while (this.seq.moveNext() && nonRelevant.contains(this.seq.token().id()) && n4 < 3) {
                if (JavaTokenId.WHITESPACE == this.seq.token().id()) {
                    object = ((Object)this.seq.token().text()).toString();
                    n3 = 0;
                    int n5 = 0;
                    while ((n5 = ((String)object).indexOf(10, n5)) > -1) {
                        ++n5;
                        if (++n4 >= 3) continue;
                        n3 = n5;
                    }
                    n2 += n3;
                    continue;
                }
                if (JavaTokenId.LINE_COMMENT == this.seq.token().id()) {
                    ++n4;
                    n2 += ((Object)this.seq.token().text()).toString().length();
                    continue;
                }
                if (JavaTokenId.BLOCK_COMMENT != this.seq.token().id() && JavaTokenId.JAVADOC_COMMENT != this.seq.token().id()) continue;
                break;
            }
            return n2;
        }

        @Override
        public int[] getPositions(int n) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.data.get(n);
        }

        @Override
        public CasualDiff.LineInsertionType lineInsertType() {
            return CasualDiff.LineInsertionType.AFTER;
        }

        @Override
        public String head() {
            throw new UnsupportedOperationException("Not applicable for imports!");
        }

        @Override
        public String sep() {
            throw new UnsupportedOperationException("Not applicable for imports!");
        }

        @Override
        public String getIndentString() {
            throw new UnsupportedOperationException("Not applicable for imports!");
        }

        public String toString() {
            String string = "";
            for (int i = 0; i < this.data.size(); ++i) {
                int[] nArray = this.data.get(i);
                String string2 = this.copy.getText().substring(nArray[0], nArray[1]);
                string = string + "\"" + string2 + "\"\n";
            }
            return string;
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder stringBuilder) {
            int n;
            Token token;
            assert (!this.oldL.isEmpty() && this.newL.isEmpty());
            SourcePositions sourcePositions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
            int n2 = (int)sourcePositions.getStartPosition(compilationUnitTree, (Tree)this.oldL.get(0));
            int n3 = (int)sourcePositions.getEndPosition(compilationUnitTree, (Tree)this.oldL.get(this.oldL.size() - 1));
            this.seq.move(n2);
            this.seq.moveNext();
            while (this.seq.movePrevious() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    this.seq.moveNext();
                    n2 = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                n = ((Object)token.text()).toString().indexOf(10);
                if (n > -1) {
                    n2 = this.seq.offset() + n + 1;
                    continue;
                }
                n2 = this.seq.offset();
            }
            this.seq.move(n3);
            this.seq.movePrevious();
            while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    n3 = this.seq.offset();
                    if (!this.seq.moveNext()) break;
                    n3 = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                n = ((Object)token.text()).toString().indexOf(10);
                if (n > -1) {
                    n3 = this.seq.offset() + n + 1;
                    continue;
                }
                n3 += this.seq.offset() + token.text().length();
            }
            return new int[]{n2, n3};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ThrowsEstimator
    extends BaseEstimator {
        ThrowsEstimator(List<? extends ExpressionTree> list, List<? extends ExpressionTree> list2, WorkingCopy workingCopy) {
            super(JavaTokenId.THROWS, list, list2, workingCopy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExtendsEstimator
    extends BaseEstimator {
        ExtendsEstimator(List<? extends Tree> list, List<? extends Tree> list2, WorkingCopy workingCopy) {
            super(JavaTokenId.EXTENDS, list, list2, workingCopy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImplementsEstimator
    extends BaseEstimator {
        ImplementsEstimator(List<? extends Tree> list, List<? extends Tree> list2, WorkingCopy workingCopy) {
            super(JavaTokenId.IMPLEMENTS, list, list2, workingCopy);
        }
    }
}

