/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.platform.JavaPlatformProvider;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class DefaultJavaPlatformProvider
implements JavaPlatformProvider,
FileChangeListener {
    private static final String PLATFORM_STORAGE = "Services/Platforms/org-netbeans-api-java-Platform";
    private static final String DEFAULT_PLATFORM_ATTR = "default-platform";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private FileObject storage = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
    private JavaPlatform defaultPlatform;
    private static final Logger LOG = Logger.getLogger(DefaultJavaPlatformProvider.class.getName());

    public DefaultJavaPlatformProvider() {
        if (this.storage != null) {
            this.storage.addFileChangeListener((FileChangeListener)this);
        }
    }

    public JavaPlatform[] getInstalledPlatforms() {
        ArrayList<JavaPlatform> arrayList = new ArrayList<JavaPlatform>();
        if (this.storage != null) {
            try {
                for (FileObject fileObject : this.storage.getChildren()) {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                    if (instanceCookie == null) {
                        LOG.warning("DefaultPlatformStorage: The file: " + fileObject.getNameExt() + " has no InstanceCookie");
                        continue;
                    }
                    if (instanceCookie instanceof InstanceCookie.Of) {
                        if (((InstanceCookie.Of)instanceCookie).instanceOf(JavaPlatform.class)) {
                            arrayList.add((JavaPlatform)instanceCookie.instanceCreate());
                            continue;
                        }
                        LOG.warning("DefaultPlatformStorage: The file: " + fileObject.getNameExt() + " is not an instance of JavaPlatform");
                        continue;
                    }
                    Object object = instanceCookie.instanceCreate();
                    if (object instanceof JavaPlatform) {
                        arrayList.add((JavaPlatform)object);
                        continue;
                    }
                    LOG.warning("DefaultPlatformStorage: The file: " + fileObject.getNameExt() + " is not an instance of JavaPlatform");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return arrayList.toArray(new JavaPlatform[arrayList.size()]);
    }

    public JavaPlatform getDefaultPlatform() {
        if (this.defaultPlatform == null) {
            this.defaultPlatform = this.getDefaultPlatformByHint();
            if (this.defaultPlatform != null) {
                return this.defaultPlatform;
            }
            JavaPlatform[] javaPlatformArray = this.getInstalledPlatforms();
            for (int i = 0; i < javaPlatformArray.length; ++i) {
                if (!this.isDefaultPlatform(javaPlatformArray[i])) continue;
                this.defaultPlatform = javaPlatformArray[i];
                break;
            }
        }
        return this.defaultPlatform;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.firePropertyChange();
    }

    public void fileChanged(FileEvent fileEvent) {
        this.firePropertyChange();
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.firePropertyChange();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.firePropertyChange();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    private void firePropertyChange() {
        this.pcs.firePropertyChange("installedPlatforms", null, null);
    }

    private final boolean isDefaultPlatform(JavaPlatform javaPlatform) {
        return "default_platform".equals(javaPlatform.getProperties().get("platform.ant.name"));
    }

    private final JavaPlatform getDefaultPlatformByHint() {
        if (this.storage == null) {
            return null;
        }
        for (FileObject fileObject : this.storage.getChildren()) {
            if (fileObject.getAttribute(DEFAULT_PLATFORM_ATTR) != Boolean.TRUE) continue;
            try {
                Object object;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                if (instanceCookie != null && (object = instanceCookie.instanceCreate()) instanceof JavaPlatform && this.isDefaultPlatform((JavaPlatform)object)) {
                    return (JavaPlatform)object;
                }
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }
        return null;
    }
}

