/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.actions;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.modules.mobility.editor.actions.PreprocessorEditorContextAction;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddElifBlockAction
extends PreprocessorEditorContextAction {
    public static final String NAME = "add-elif-block-action";
    private WeakReference<JTextComponent> textComponent;
    private ArrayList<PPLine> preprocessorLineList;

    public AddElifBlockAction() {
        super(NAME);
    }

    @Override
    public boolean isEnabled(ProjectConfigurationsHelper projectConfigurationsHelper, ArrayList<PPLine> arrayList, JTextComponent jTextComponent) {
        if (projectConfigurationsHelper != null && arrayList != null && jTextComponent != null) {
            this.textComponent = new WeakReference<JTextComponent>(jTextComponent);
            this.preprocessorLineList = arrayList;
        } else {
            this.textComponent = null;
        }
        return projectConfigurationsHelper != null && projectConfigurationsHelper.isPreprocessorOn() && projectConfigurationsHelper.getConfigurations().size() > 1 && this.isInsideIfChain(jTextComponent, arrayList) && !this.overlapsBlockBorders(jTextComponent, arrayList) && !this.overlapsGuardedBlocks(jTextComponent);
    }

    public String getPopupMenuText(ProjectConfigurationsHelper projectConfigurationsHelper, ArrayList arrayList, JTextComponent jTextComponent) {
        return NbBundle.getMessage(AddElifBlockAction.class, (String)"LBL_Add_Elif_Block");
    }

    private boolean isInsideIfChain(JTextComponent jTextComponent, ArrayList<PPLine> arrayList) {
        int n = this.getSelectionStartLine(jTextComponent);
        if (n >= arrayList.size()) {
            return false;
        }
        PPBlockInfo pPBlockInfo = this.getBlock(jTextComponent, arrayList);
        return pPBlockInfo != null && (pPBlockInfo.getType() == 0 || pPBlockInfo.getType() == 2 || pPBlockInfo.getType() == 3 || pPBlockInfo.getType() == 5 || pPBlockInfo.getType() == 6 || pPBlockInfo.getType() == 7 || pPBlockInfo.getType() == 4);
    }

    public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        if (jTextComponent != null && this.textComponent != null && jTextComponent.equals(this.textComponent.get())) {
            try {
                final PPBlockInfo pPBlockInfo = this.getBlock(jTextComponent, this.preprocessorLineList);
                if (pPBlockInfo != null) {
                    int n;
                    int n2;
                    final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    if (jTextComponent.getSelectionStart() == jTextComponent.getSelectionEnd()) {
                        n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)pPBlockInfo.getStartLine());
                        n = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(pPBlockInfo.getEndLine() - (pPBlockInfo.hasFooter() ? 2 : 1))));
                    } else {
                        n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(this.getSelectionStartLine(jTextComponent) - 1));
                        n = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(this.getSelectionEndLine(jTextComponent) - 1)));
                    }
                    final String string = jTextComponent.getText(n2, n - n2);
                    NbDocument.runAtomic((StyledDocument)((StyledDocument)jTextComponent.getDocument()), (Runnable)new Runnable(){

                        public void run() {
                            try {
                                if (pPBlockInfo.getType() == 4) {
                                    int n = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(pPBlockInfo.getStartLine() - 1));
                                    baseDocument.insertString(n, "//#elif \n" + string + "\n", null);
                                    jTextComponent.setSelectionStart(n + 8);
                                    jTextComponent.setSelectionEnd(n + 8);
                                } else {
                                    int n = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(pPBlockInfo.getEndLine() - (pPBlockInfo.hasFooter() ? 2 : 1))));
                                    baseDocument.insertString(n, "\n//#elif \n" + string, null);
                                    jTextComponent.setSelectionStart(n + 9);
                                    jTextComponent.setSelectionEnd(n + 9);
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                ErrorManager.getDefault().notify((Throwable)badLocationException);
                            }
                            RecommentAction.actionPerformed(jTextComponent);
                        }
                    });
                    Completion.get().showCompletion();
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
    }
}

