/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.WeakSharedSet;

public class KeyManager {
    private final KeyStorage storage;
    private static final int KEY_MANAGER_DEFAULT_CAPACITY;
    private static final int KEY_MANAGER_DEFAULT_SLICED_NUMBER;
    private static final KeyManager instance;
    private final Object lock = new Lock();

    private KeyManager() {
        this.storage = new KeyStorage(KEY_MANAGER_DEFAULT_SLICED_NUMBER, KEY_MANAGER_DEFAULT_CAPACITY);
    }

    public static KeyManager instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Key getSharedUID(Key key) {
        if (key == null) {
            throw new NullPointerException("null string is illegal to share");
        }
        Key key2 = null;
        Object object = this.lock;
        synchronized (object) {
            key2 = this.storage.getSharedUID(key);
        }
        assert (key2 != null);
        assert (key2.equals(key));
        return key2;
    }

    public final void dispose() {
        this.storage.dispose();
    }

    static {
        int n = CndUtils.getConcurrencyLevel();
        if (n <= 4) {
            KEY_MANAGER_DEFAULT_SLICED_NUMBER = 32;
            KEY_MANAGER_DEFAULT_CAPACITY = 512;
        } else {
            KEY_MANAGER_DEFAULT_SLICED_NUMBER = 128;
            KEY_MANAGER_DEFAULT_CAPACITY = 128;
        }
        instance = new KeyManager();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyStorage {
        private final WeakSharedSet<Key>[] instances;
        private final int segmentMask;
        private final int initialCapacity;

        private KeyStorage(int n, int n2) {
            int n3;
            for (n3 = 1; n3 < n; n3 <<= 1) {
            }
            this.segmentMask = n3 - 1;
            this.initialCapacity = n2;
            WeakSharedSet[] weakSharedSetArray = new WeakSharedSet[n3];
            for (int i = 0; i < weakSharedSetArray.length; ++i) {
                weakSharedSetArray[i] = new WeakSharedSet(n2);
            }
            this.instances = weakSharedSetArray;
        }

        private WeakSharedSet<Key> getDelegate(Key key) {
            int n = key.hashCode() & this.segmentMask;
            return this.instances[n];
        }

        public final Key getSharedUID(Key key) {
            return (Key)this.getDelegate(key).addOrGet((Object)key);
        }

        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                if (this.instances[i].size() <= 0) continue;
                if (CndTraceFlags.TRACE_SLICE_DISTIBUTIONS) {
                    Object[] objectArray = this.instances[i].toArray();
                    System.out.println("Key cache " + this.instances[i].size());
                    HashMap hashMap = new HashMap();
                    for (Object object : objectArray) {
                        if (object == null) continue;
                        Integer n = (Integer)hashMap.get(object.getClass());
                        n = n != null ? new Integer(n + 1) : new Integer(1);
                        hashMap.put(object.getClass(), n);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        System.out.println("   " + entry.getValue() + " of " + ((Class)entry.getKey()).getName());
                    }
                }
                this.instances[i].clear();
                this.instances[i].resize(this.initialCapacity);
            }
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

