/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.AbstractFileBuffer;

public class FileBufferDoc
extends AbstractFileBuffer {
    private static final boolean TRACE = false;
    private final Document doc;
    private final EventListenerList listeners = new EventListenerList();
    private DocumentListener docListener;
    private long lastModified;
    private final ChangedSegment changedSegment;
    private ChangedSegment lastChangedSegment;
    private long changedSegmentTaken;

    public FileBufferDoc(CharSequence charSequence, Document document) {
        super(charSequence);
        this.doc = document;
        this.changedSegment = new ChangedSegment(document);
        this.resetLastModified();
    }

    private void resetLastModified() {
        this.lastModified = System.currentTimeMillis();
    }

    private void fireDocumentChanged() {
        this.resetLastModified();
        EventListener[] eventListenerArray = this.listeners.getListeners(ChangeListener.class);
        if (eventListenerArray.length > 0) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = 0; i < eventListenerArray.length; ++i) {
                ((ChangeListener)eventListenerArray[i]).stateChanged(changeEvent);
            }
        }
        APTDriver.getInstance().invalidateAPT((APTFileBuffer)this);
        APTFileCacheManager.invalidate((APTFileBuffer)this);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners.getListenerCount() == 0) {
            this.docListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    FileBufferDoc.this.changedSegment.addSegment(documentEvent.getOffset(), documentEvent.getLength());
                    FileBufferDoc.this.fireDocumentChanged();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    FileBufferDoc.this.changedSegment.removeSegment(documentEvent.getOffset(), documentEvent.getLength());
                    FileBufferDoc.this.fireDocumentChanged();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }
            };
            this.doc.addDocumentListener(this.docListener);
        }
        this.listeners.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(ChangeListener.class, changeListener);
        if (this.listeners.getListenerCount() == 0) {
            this.doc.removeDocumentListener(this.docListener);
            this.docListener = null;
        }
    }

    private IOException convert(BadLocationException badLocationException) {
        IOException iOException = new IOException(badLocationException.getMessage());
        iOException.setStackTrace(badLocationException.getStackTrace());
        return iOException;
    }

    public InputStream getInputStream() throws IOException {
        final Object[] objectArray = new Object[]{null, null};
        this.doc.render(new Runnable(){

            public void run() {
                try {
                    objectArray[0] = FileBufferDoc.this.doc.getText(0, FileBufferDoc.this.doc.getLength());
                    if (FileBufferDoc.this.lastChangedSegment == null || FileBufferDoc.this.changedSegmentTaken != FileBufferDoc.this.lastModified) {
                        FileBufferDoc.this.lastChangedSegment = new ChangedSegment(FileBufferDoc.this.changedSegment);
                        FileBufferDoc.this.changedSegment.reset(FileBufferDoc.this.doc);
                        FileBufferDoc.this.changedSegmentTaken = FileBufferDoc.this.lastModified;
                    }
                }
                catch (BadLocationException badLocationException) {
                    objectArray[1] = FileBufferDoc.this.convert(badLocationException);
                }
            }
        });
        if (objectArray[1] != null) {
            throw (IOException)objectArray[1];
        }
        return new ByteArrayInputStream(((String)objectArray[0]).getBytes());
    }

    public String getText() throws IOException {
        final String[] stringArray = new String[]{null};
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[]{null};
        this.doc.render(new Runnable(){

            public void run() {
                try {
                    stringArray[0] = FileBufferDoc.this.doc.getText(0, FileBufferDoc.this.doc.getLength());
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        });
        if (badLocationExceptionArray[0] != null) {
            throw this.convert(badLocationExceptionArray[0]);
        }
        return stringArray[0];
    }

    public String getText(int n, int n2) throws IOException {
        try {
            return this.doc.getText(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            throw this.convert(badLocationException);
        }
    }

    public int getLength() {
        return this.doc.getLength();
    }

    public boolean isFileBased() {
        return false;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public ChangedSegment getLastChangedSegment() {
        return this.lastChangedSegment;
    }

    public static final class ChangedSegment {
        private int begUnchangedEnd;
        private int endUnchangedStart = -1;
        private int endUnchangedEnd = -1;

        public int[] begUnchanged() {
            return new int[]{0, this.begUnchangedEnd};
        }

        public int[] endUnchanged() {
            return new int[]{this.endUnchangedStart, this.endUnchangedEnd};
        }

        private ChangedSegment(ChangedSegment changedSegment) {
            this.begUnchangedEnd = changedSegment.begUnchangedEnd;
            this.endUnchangedStart = changedSegment.endUnchangedStart;
            this.endUnchangedEnd = changedSegment.endUnchangedEnd;
        }

        private ChangedSegment(Document document) {
            this.begUnchangedEnd = document.getLength();
        }

        private void reset(Document document) {
            this.begUnchangedEnd = document.getLength();
            this.endUnchangedStart = -1;
            this.endUnchangedEnd = -1;
        }

        private void addSegment(int n, int n2) {
            if (this.endUnchangedStart == -1) {
                this.endUnchangedStart = n + n2;
                this.endUnchangedEnd = this.begUnchangedEnd + n2;
                this.begUnchangedEnd = n;
            } else if (this.begUnchangedEnd <= n) {
                if (this.endUnchangedStart >= n) {
                    this.endUnchangedStart += n2;
                    this.endUnchangedEnd += n2;
                } else {
                    this.endUnchangedStart = n + n2;
                    this.endUnchangedEnd += n2;
                }
            } else {
                this.begUnchangedEnd = n;
                this.endUnchangedStart += n2;
                this.endUnchangedEnd += n2;
            }
        }

        private void removeSegment(int n, int n2) {
            if (this.endUnchangedStart == -1) {
                this.endUnchangedStart = n;
                this.endUnchangedEnd = this.begUnchangedEnd - n2;
                this.begUnchangedEnd = n;
            } else if (this.begUnchangedEnd <= n) {
                if (this.endUnchangedStart >= n) {
                    this.endUnchangedStart -= n2;
                    if (this.endUnchangedStart < n) {
                        this.endUnchangedStart = n;
                    }
                    this.endUnchangedEnd -= n2;
                } else {
                    this.endUnchangedStart = n + n2;
                    this.endUnchangedEnd -= n2;
                }
            } else {
                this.begUnchangedEnd = n;
                this.endUnchangedStart -= n2;
                if (this.endUnchangedStart < n) {
                    this.endUnchangedStart = n;
                }
                this.endUnchangedEnd -= n2;
            }
        }

        public String toString() {
            if (this.endUnchangedStart == -1) {
                return "No changes";
            }
            return "Start unchanged=[0," + this.begUnchangedEnd + ") End unhanged=[" + this.endUnchangedStart + "," + this.endUnchangedEnd + ")";
        }
    }
}

