/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.debug;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.openide.LifecycleManager;
import org.openide.util.RequestProcessor;

public class Terminator
implements Runnable {
    private ProjectBase project;
    private static boolean timeout = false;
    private static final Object lock = new Lock();
    private static int inParse = 0;

    private Terminator(ProjectBase projectBase) {
        this.project = projectBase;
    }

    public static void create(ProjectBase projectBase) {
        RequestProcessor.getDefault().post((Runnable)new Terminator(projectBase));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = lock;
        synchronized (object) {
        }
        System.err.println("Parse started. " + ++inParse + " projects in list");
        if (TraceFlags.CLOSE_TIMEOUT > 0) {
            object = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    ((ModelImpl)CsmModelAccessor.getModel()).shutdown();
                    Object object = lock;
                    synchronized (object) {
                        timeout = true;
                    }
                }
            };
            new Timer(TraceFlags.CLOSE_TIMEOUT * 1000, (ActionListener)object).start();
        }
        this.project.waitParse();
        object = lock;
        synchronized (object) {
            System.err.println("Parse finished. " + --inParse + " projects left");
            if (inParse == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Terminator.this.terminate();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        Object object = lock;
        synchronized (object) {
            long l = ParserQueue.instance().getStopWatchTime();
            System.err.println("disposing at " + l);
            String string = System.getProperty("cnd.close.report.xml");
            if (string != null) {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, true));
                    String string2 = timeout ? "failed" : "passed";
                    bufferedWriter.write("<result>" + string2 + "</result>");
                    bufferedWriter.write("<parsetime>" + l + "</parsetime>");
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    DiagnosticExceptoins.register(iOException);
                }
            }
        }
        LifecycleManager.getDefault().exit();
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

