/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver3;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsingDeclarationImpl
extends OffsetableDeclarationBase<CsmUsingDeclaration>
implements CsmUsingDeclaration,
CsmMember,
RawNamable,
Disposable {
    private final CharSequence name;
    private final int startOffset;
    private final CharSequence[] rawName;
    private CsmUID<CsmDeclaration> referencedDeclarationUID = null;
    private WeakReference<CsmDeclaration> refDeclaration;
    private boolean lastResolveFalure;
    private final CsmUID<CsmScope> scopeUID;
    private final CsmVisibility visibility;

    public UsingDeclarationImpl(AST aST, CsmFile csmFile, CsmScope csmScope, boolean bl, CsmVisibility csmVisibility) {
        super(aST, csmFile);
        this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
        this.name = NameCache.getManager().getString((CharSequence)aST.getText());
        this.rawName = AstUtil.getRawNameInChildren(aST);
        if (!bl) {
            Utils.setSelfUID(this);
        }
        this.visibility = csmVisibility;
        AST aST2 = aST.getFirstChild();
        this.startOffset = aST2 instanceof CsmAST ? ((CsmAST)aST2).getOffset() : this.getStartOffset();
    }

    public CsmDeclaration getReferencedDeclaration() {
        return this.getReferencedDeclaration(null);
    }

    public CsmDeclaration getReferencedDeclaration(Resolver resolver) {
        Object object = this._getReferencedDeclaration();
        if (object == null && !this.lastResolveFalure) {
            this._setReferencedDeclaration(null);
            if (this.rawName != null) {
                CharSequence charSequence;
                Object object2;
                CsmSelect.CsmFilter csmFilter;
                CsmObject csmObject;
                CharSequence[] charSequenceArray;
                ProjectBase projectBase = (ProjectBase)this.getProject();
                CsmNamespace csmNamespace = null;
                if (this.rawName.length == 1) {
                    csmNamespace = projectBase.getGlobalNamespace();
                } else if (this.rawName.length > 1) {
                    charSequenceArray = new CharSequence[this.rawName.length - 1];
                    System.arraycopy(this.rawName, 0, charSequenceArray, 0, this.rawName.length - 1);
                    csmObject = ResolverFactory.createResolver(this.getContainingFile(), this.startOffset, resolver).resolve(charSequenceArray, 1);
                    if (CsmKindUtilities.isNamespace((Object)csmObject)) {
                        csmNamespace = (CsmNamespace)csmObject;
                    }
                }
                if (csmNamespace != null) {
                    Object object3;
                    Object object4;
                    charSequenceArray = this.rawName[this.rawName.length - 1];
                    csmObject = null;
                    csmFilter = CsmSelect.getFilterBuilder().createNameFilter((CharSequence)charSequenceArray, true, true, false);
                    object2 = new LinkedHashSet<CsmNamespace>();
                    object2.add(csmNamespace);
                    charSequence = csmNamespace.getQualifiedName();
                    Collection<CsmProject> collection = resolver != null ? resolver.getLibraries() : Resolver3.getSearchLibraries(projectBase);
                    for (CsmProject object52 : collection) {
                        object4 = object52.findNamespace(charSequence);
                        if (object4 == null) continue;
                        object2.add(object4);
                    }
                    Iterator<Object> iterator = object2.iterator();
                    block1: while (iterator.hasNext()) {
                        CsmNamespace csmNamespace2 = (CsmNamespace)iterator.next();
                        object4 = CsmSelect.getDeclarations((CsmNamespace)csmNamespace2, (CsmSelect.CsmFilter)csmFilter);
                        while (object4.hasNext()) {
                            object3 = (CsmDeclaration)object4.next();
                            if (CharSequenceKey.Comparator.compare(charSequenceArray, object3.getName()) != 0) continue;
                            if (!CsmKindUtilities.isExternVariable((CsmDeclaration)object3)) {
                                object = object3;
                                break block1;
                            }
                            csmObject = object3;
                        }
                    }
                    if (object == null && csmObject == null) {
                        iterator = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM});
                        Iterator iterator2 = object2.iterator();
                        block3: while (iterator2.hasNext()) {
                            object4 = (CsmNamespace)iterator2.next();
                            object3 = CsmSelect.getDeclarations((CsmNamespace)object4, iterator);
                            while (object3.hasNext()) {
                                CsmDeclaration csmDeclaration = (CsmDeclaration)object3.next();
                                if (!CsmKindUtilities.isEnum((CsmObject)csmDeclaration)) continue;
                                CsmEnum csmEnum = (CsmEnum)csmDeclaration;
                                for (CsmEnumerator csmEnumerator : csmEnum.getEnumerators()) {
                                    if (!charSequenceArray.toString().equals(((Object)csmEnumerator.getName()).toString())) continue;
                                    object = csmEnumerator;
                                    break block3;
                                }
                            }
                        }
                    }
                    object = object == null ? csmObject : object;
                }
                charSequenceArray = null;
                if (csmNamespace == null) {
                    csmObject = new CharSequence[this.rawName.length - 1];
                    System.arraycopy(this.rawName, 0, csmObject, 0, this.rawName.length - 1);
                    csmFilter = ResolverFactory.createResolver(this.getContainingFile(), this.startOffset, resolver).resolve((CharSequence[])csmObject, 2);
                    if (CsmKindUtilities.isClass((CsmObject)csmFilter)) {
                        charSequenceArray = (CsmClass)csmFilter;
                    }
                }
                if (charSequenceArray != null) {
                    csmObject = this.rawName[this.rawName.length - 1];
                    csmFilter = CsmSelect.getFilterBuilder().createNameFilter((CharSequence)csmObject, true, true, false);
                    object2 = CsmSelect.getClassMembers((CsmClass)charSequenceArray, (CsmSelect.CsmFilter)csmFilter);
                    if (object2.hasNext()) {
                        charSequence = (CsmMember)object2.next();
                        object = charSequence;
                    }
                }
            }
            this._setReferencedDeclaration((CsmDeclaration)object);
            this.lastResolveFalure = object == null;
        }
        return object;
    }

    private CsmDeclaration _getReferencedDeclaration() {
        CsmDeclaration csmDeclaration = null;
        WeakReference<CsmDeclaration> weakReference = this.refDeclaration;
        if (weakReference != null) {
            csmDeclaration = (CsmDeclaration)weakReference.get();
        }
        if (csmDeclaration == null) {
            csmDeclaration = UIDCsmConverter.UIDtoDeclaration(this.referencedDeclarationUID);
            this.refDeclaration = new WeakReference<CsmDeclaration>(csmDeclaration);
        }
        return csmDeclaration;
    }

    private void _setReferencedDeclaration(CsmDeclaration csmDeclaration) {
        this.refDeclaration = csmDeclaration != null ? new WeakReference<CsmDeclaration>(csmDeclaration) : null;
        this.referencedDeclarationUID = UIDCsmConverter.declarationToUID(csmDeclaration);
        assert (this.referencedDeclarationUID != null || csmDeclaration == null);
    }

    public CsmClass getContainingClass() {
        CsmScope csmScope = this.getScope();
        if (CsmKindUtilities.isClass((CsmObject)csmScope)) {
            return (CsmClass)csmScope;
        }
        return null;
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public boolean isStatic() {
        return false;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.USING_DECLARATION;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        return this.getName();
    }

    @Override
    public CharSequence[] getRawName() {
        return this.rawName;
    }

    public CsmScope getScope() {
        return UIDCsmConverter.UIDtoScope(this.scopeUID);
    }

    @Override
    public void dispose() {
        super.dispose();
        CsmScope csmScope = this.getScope();
        if (csmScope instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)csmScope).removeDeclaration(this);
        }
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        dataOutput.writeInt(this.startOffset);
        PersistentUtils.writeStrings(this.rawName, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.referencedDeclarationUID, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
        PersistentUtils.writeVisibility(this.visibility, dataOutput);
    }

    public UsingDeclarationImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        assert (this.name != null);
        this.startOffset = dataInput.readInt();
        this.rawName = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.referencedDeclarationUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.visibility = PersistentUtils.readVisibility(dataInput);
    }
}

