/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.ModelNode;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.microedition.m2g.SVGImage;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SVGObjectOutline;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.export.ComponentGroup;
import org.netbeans.modules.mobility.svgcore.export.ScreenSizeHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class SVGRasterizerPanel
extends JPanel
implements AnimationRasterizer.Params {
    protected final SVGDataObject m_dObj;
    protected final String m_elementId;
    protected final J2MEProject m_project;
    protected final Dimension m_dim;
    protected double m_ratio;
    protected int m_overrideWidth = -1;
    protected int m_overrideHeight = -1;
    protected volatile boolean m_updateInProgress = false;
    protected volatile SVGImage m_svgImage;
    private SVGLocatableElement m_exportedElement = null;
    private boolean m_isDialogValid = true;
    private static final String CONFIRM_REWRITE_TITLE = "LBL_Confirm_Rewrite_Title";
    private static final String CONFIRM_REWRITE_MESSAGE = "LBL_Confirm_Rewrite_Msg";

    protected SVGRasterizerPanel(SVGDataObject sVGDataObject, String string) throws IOException, BadLocationException {
        SVGImage sVGImage;
        this.m_dObj = sVGDataObject;
        this.m_elementId = string;
        FileObject fileObject = this.m_dObj.getPrimaryFile();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        this.m_project = project != null && project instanceof J2MEProject ? (J2MEProject)project : null;
        this.m_dim = this.m_elementId == null && this.isInProject() ? ScreenSizeHelper.getCurrentDeviceScreenSize(fileObject, null) : ((sVGImage = this.getSVGImage()) != null ? new Dimension(this.m_svgImage.getViewportWidth(), this.m_svgImage.getViewportHeight()) : new Dimension());
    }

    protected ComponentGroup createTimeGroup(JSpinner jSpinner, JSlider jSlider, boolean bl) {
        float f = this.m_dObj.getSceneManager().getAnimationDuration();
        return this.createTimeGroup(jSpinner, jSlider, f, bl);
    }

    protected ComponentGroup createTimeGroup(JSpinner jSpinner, JSlider jSlider, final float f, boolean bl) {
        ComponentGroup.ComponentWrapper componentWrapper;
        int n = Math.round(f * 100.0f);
        jSlider.setMinimum(0);
        jSlider.setMaximum(n);
        jSlider.setValue(0);
        if (!bl) {
            jSlider.setInverted(true);
            componentWrapper = new ComponentGroup.SliderWrapper(jSlider){

                public float getValue() {
                    return f - super.getValue();
                }

                public void setValue(float f2) {
                    super.setValue(f - f2);
                }
            };
        } else {
            componentWrapper = ComponentGroup.ComponentWrapper.wrap(jSlider);
        }
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(bl ? 0.0f : f, 0.0, f, 1.0);
        jSpinner.setModel(spinnerNumberModel);
        return new SVGRasterizerComponentGroup(jSpinner, componentWrapper);
    }

    protected boolean isDialogValid() {
        return this.m_isDialogValid;
    }

    private void setDialogValid(boolean bl) {
        if (this.m_isDialogValid != bl) {
            boolean bl2 = this.m_isDialogValid;
            this.m_isDialogValid = bl;
            this.firePropertyChange("valid", bl2, bl);
        }
    }

    protected ComponentGroup createCompressionGroup(JComboBox jComboBox, JSpinner jSpinner) {
        jSpinner.setModel(new SpinnerNumberModel(0, 0, 99, 1));
        AnimationRasterizer.CompressionLevel compressionLevel = AnimationRasterizer.CompressionLevel.HIGH;
        jSpinner.setValue(new Integer(compressionLevel.getRate()));
        jComboBox.setSelectedItem((Object)compressionLevel);
        return new SVGRasterizerComponentGroup(this.createComboWrapper(jComboBox), jSpinner);
    }

    protected final boolean isInProject() {
        return this.m_project != null;
    }

    protected ComponentGroup.ComponentWrapper createComboWrapper(JComboBox jComboBox) {
        return new ComponentGroup.ComponentWrapper(jComboBox){

            public float getValue() {
                Object object = ((JComboBox)this.m_delegate).getSelectedItem();
                return ((AnimationRasterizer.CompressionLevel)((Object)object)).getRate();
            }

            public void setValue(float f) {
                int n = Math.round(f);
                ((JComboBox)this.m_delegate).setSelectedItem((Object)AnimationRasterizer.CompressionLevel.getLevel(n));
            }
        };
    }

    protected static float roundTime(float f) {
        return (float)Math.round(f * 100.0f) / 100.0f;
    }

    public final void setImageWidth(int n) {
        this.m_overrideWidth = n;
    }

    public final void setImageHeight(int n) {
        this.m_overrideHeight = n;
    }

    public float getEndTime() {
        return 0.0f;
    }

    public float getFramesPerSecond() {
        return 1.0f;
    }

    public double getRatio() {
        return this.m_ratio;
    }

    private void loadSVGImage() {
        try {
            this.m_svgImage = this.m_dObj.getModel().parseSVGImage();
        }
        catch (Exception exception) {
            this.setDialogValid(false);
            SceneManager.log(Level.INFO, "Load of SVG image failed", exception);
        }
    }

    public final synchronized SVGImage getSVGImage() throws IOException, BadLocationException {
        if (this.m_svgImage == null) {
            SVGElement sVGElement;
            Thread thread;
            if (SwingUtilities.isEventDispatchThread()) {
                thread = new Thread(){

                    public void run() {
                        SVGRasterizerPanel.this.loadSVGImage();
                    }
                };
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.loadSVGImage();
            }
            if (this.m_svgImage != null && this.m_elementId != null && (sVGElement = PerseusController.hideAllButSubtree((ModelNode)(thread = (SVGSVGElement)this.m_svgImage.getDocument().getDocumentElement()), this.m_elementId)) != null && sVGElement instanceof SVGLocatableElement) {
                this.m_exportedElement = (SVGLocatableElement)sVGElement;
                SVGRect sVGRect = this.m_exportedElement.getBBox();
                SVGMatrix sVGMatrix = thread.getScreenCTM();
                SVGMatrix sVGMatrix2 = this.m_exportedElement.getScreenCTM();
                SVGMatrix sVGMatrix3 = sVGMatrix.inverse();
                SVGMatrix sVGMatrix4 = sVGMatrix3.mMultiply(sVGMatrix2);
                float[][] fArray = SVGObjectOutline.transformRectangle(this.m_exportedElement.getBBox(), (Transform)sVGMatrix4, new float[4][2]);
                Rectangle rectangle = SVGObjectOutline.getShapeBoundingBox(fArray);
                sVGRect = new Box((float)(rectangle.x - 1), (float)(rectangle.y - 1), (float)(rectangle.width + 2), (float)(rectangle.height + 2));
                thread.setRectTrait("viewBox", sVGRect);
                this.m_svgImage.setViewportWidth(Math.round(sVGRect.getWidth()));
                this.m_svgImage.setViewportHeight(Math.round(sVGRect.getHeight()));
            }
        }
        return this.m_svgImage;
    }

    public final J2MEProject getProject() {
        return this.m_project;
    }

    public final String getElementId() {
        return this.m_elementId;
    }

    protected static ComboBoxModel createImageTypeComboBoxModel() {
        DefaultComboBoxModel<AnimationRasterizer.ImageType> defaultComboBoxModel = new DefaultComboBoxModel<AnimationRasterizer.ImageType>(AnimationRasterizer.ImageType.values());
        return defaultComboBoxModel;
    }

    protected boolean isExportConfirmed() {
        String string = this.getPreviewFileName();
        File file = new File(string);
        if (!file.exists()) {
            return true;
        }
        return SVGRasterizerPanel.userConfirmRewrite(string);
    }

    private static boolean userConfirmRewrite(String string) {
        String string2 = NbBundle.getMessage(SVGRasterizerPanel.class, (String)CONFIRM_REWRITE_TITLE, (Object)string);
        String string3 = NbBundle.getMessage(SVGRasterizerPanel.class, (String)CONFIRM_REWRITE_MESSAGE, (Object)string);
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string3, string2, 2);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.OK_OPTION;
    }

    protected abstract void updateImage(JComponent var1, boolean var2);

    protected abstract String getPreviewFileName();

    protected class SVGRasterizerComponentGroup
    extends ComponentGroup {
        public SVGRasterizerComponentGroup(Object ... objectArray) {
            super(objectArray);
        }

        public void refresh(JComponent jComponent) {
            if (!this.componentIsAdjustingSlider(jComponent)) {
                SVGRasterizerPanel.this.updateImage(jComponent, true);
            }
        }

        private boolean componentIsAdjustingSlider(JComponent jComponent) {
            return jComponent instanceof JSlider && ((JSlider)jComponent).getValueIsAdjusting();
        }
    }
}

