/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.models;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.modules.cnd.debugger.common.models.BreakpointsTreeModelFilter;
import org.netbeans.modules.cnd.debugger.common.utils.GeneralUtils;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class BreakpointsNodeModel
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String DISABLED_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    public static final String LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpoint";
    public static final String DISABLED_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledConditionalBreakpoint";
    public static final String DISABLED_CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpointHit";
    public static final String CURRENT_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpointHit";
    public static final String CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/BreakpointHit";
    public static final String CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpointHit";
    public static final String DISABLED_CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpointHit";
    private Collection<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private CndBreakpoint currentBreakpoint;

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            int n;
            int n2;
            LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)object);
            int n3 = lineBreakpoint.getLineNumber();
            String string = Integer.toString(n3);
            Integer n4 = BreakpointsTreeModelFilter.MAX_LINES.get((Object)lineBreakpoint);
            if (n4 != null && (n2 = GeneralUtils.log10(n = n4.intValue()) - GeneralUtils.log10(n3)) > 0) {
                string = GeneralUtils.zeros(n2) + string;
            }
            return this.bold(lineBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName(lineBreakpoint), (Object)string));
        }
        if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)object);
            String string = "";
            if (functionBreakpoint.getFunctionName().equals("")) {
                return this.bold(functionBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_All_Functions_Breakpoint", (Object)BreakpointsNodeModel.getShort(string)));
            }
            String string2 = BreakpointsNodeModel.getShort(string);
            if (string2 != null && string2.length() > 0) {
                return this.bold(functionBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint_With_Class", (Object)BreakpointsNodeModel.getShort(string), (Object)functionBreakpoint.getFunctionName()));
            }
            return this.bold(functionBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint", (Object)functionBreakpoint.getFunctionName()));
        }
        if (object instanceof AddressBreakpoint) {
            AddressBreakpoint addressBreakpoint = (AddressBreakpoint)object;
            return this.bold(addressBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Address_Breakpoint", (Object)addressBreakpoint.getAddress()));
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName((LineBreakpoint)((Object)object)), (Object)((LineBreakpoint)((Object)object)).getLineNumber());
        }
        if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)object);
            String string = "";
            if (functionBreakpoint.getFunctionName().equals("")) {
                return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_All_Functions_Breakpoint", (Object)string);
            }
            return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint", (Object)functionBreakpoint.getFunctionName());
        }
        if (object instanceof AddressBreakpoint) {
            return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Address_Breakpoint", (Object)((AddressBreakpoint)object).getAddress());
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        boolean bl;
        boolean bl2 = this.currentBreakpoint == object;
        boolean bl3 = bl = !((Breakpoint)object).isEnabled();
        if (object instanceof LineBreakpoint || object instanceof AddressBreakpoint) {
            boolean bl4;
            String string = ((CndBreakpoint)((Object)object)).getCondition();
            boolean bl5 = bl4 = string != null && string.trim().length() > 0;
            String string2 = bl2 ? (bl ? (bl4 ? DISABLED_LINE_CONDITIONAL_BREAKPOINT : DISABLED_CURRENT_LINE_BREAKPOINT) : (bl4 ? CURRENT_LINE_CONDITIONAL_BREAKPOINT : CURRENT_LINE_BREAKPOINT)) : (bl ? (bl4 ? DISABLED_LINE_CONDITIONAL_BREAKPOINT : DISABLED_LINE_BREAKPOINT) : (bl4 ? LINE_CONDITIONAL_BREAKPOINT : LINE_BREAKPOINT));
            return string2;
        }
        if (object instanceof FunctionBreakpoint) {
            String string = bl2 ? (bl ? DISABLED_CURRENT_BREAKPOINT : CURRENT_BREAKPOINT) : (bl ? DISABLED_BREAKPOINT : BREAKPOINT);
            return string;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    void fireNodeChanged(CndBreakpoint cndBreakpoint) {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)cndBreakpoint));
        }
    }

    static String getShort(String string) {
        if (string.indexOf(42) >= 0) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private String bold(CndBreakpoint cndBreakpoint, String string) {
        return cndBreakpoint == this.currentBreakpoint ? BoldVariablesTableModelFilterFirst.toHTML(string, true, false, null) : string;
    }

    public void setCurrentBreakpoint(CndBreakpoint cndBreakpoint) {
        CndBreakpoint cndBreakpoint2 = this.currentBreakpoint;
        this.currentBreakpoint = cndBreakpoint;
        if (cndBreakpoint2 != null) {
            this.fireNodeChanged(cndBreakpoint2);
        }
        if (cndBreakpoint != null) {
            this.fireNodeChanged(cndBreakpoint);
        }
    }
}

