/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints.customizers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.utils.ContextBindingSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ConditionsPanel
extends JPanel {
    private CndBreakpoint breakpoint;
    private JTextField tfConditionFieldForUI;
    private JCheckBox cbCondition;
    private JCheckBox cbSkipCount;
    private JPanel panelHitCountFilter;
    private JScrollPane spCondition;
    private JEditorPane tfCondition;
    private JTextField tfSkipCount;

    public ConditionsPanel(final CndBreakpoint cndBreakpoint) {
        this.breakpoint = cndBreakpoint;
        this.initComponents();
        this.tfConditionFieldForUI = new JTextField();
        this.tfConditionFieldForUI.setEnabled(false);
        this.tfConditionFieldForUI.setToolTipText(this.tfCondition.getToolTipText());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.tfConditionFieldForUI, gridBagConstraints);
        this.setCondition(cndBreakpoint.getCondition());
        this.setHitCount(cndBreakpoint.getSkipCount());
        int n = this.tfConditionFieldForUI.getPreferredSize().height;
        if (this.spCondition.getPreferredSize().height > n) {
            n = this.spCondition.getPreferredSize().height;
            this.tfConditionFieldForUI.setPreferredSize(new Dimension(this.tfConditionFieldForUI.getPreferredSize().width, n));
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConditionsPanel.this.tfCondition.setText(cndBreakpoint.getCondition());
            }
        };
        ContextBindingSupport.getDefault().setupContext(this.tfCondition, actionListener);
    }

    public void ok() {
        if (this.cbCondition.isSelected()) {
            this.breakpoint.setCondition(this.tfCondition.getText());
        } else {
            this.breakpoint.setCondition("");
        }
        if (this.cbSkipCount.isSelected()) {
            try {
                this.breakpoint.setSkipCount(Integer.valueOf(this.tfSkipCount.getText()));
            }
            catch (Exception exception) {
                this.breakpoint.setSkipCount(0);
            }
        } else {
            this.breakpoint.setSkipCount(0);
        }
    }

    public void showCondition(boolean bl) {
        this.cbCondition.setVisible(bl);
        if (bl) {
            this.cbConditionActionPerformed(null);
        } else {
            this.spCondition.setVisible(bl);
            this.tfCondition.setVisible(bl);
            this.tfConditionFieldForUI.setVisible(bl);
        }
    }

    public void setCondition(String string) {
        this.tfCondition.setText(string);
        this.cbCondition.setSelected(string.length() > 0);
        this.cbConditionActionPerformed(null);
    }

    public void setHitCount(int n) {
        if (n != 0) {
            this.cbSkipCount.setSelected(true);
            this.tfSkipCount.setText(Integer.toString(n));
        } else {
            this.cbSkipCount.setSelected(false);
            this.tfSkipCount.setText("");
        }
        this.cbSkipCountActionPerformed(null);
    }

    public String getCondition() {
        if (this.cbCondition.isSelected()) {
            return this.tfCondition.getText().trim();
        }
        return "";
    }

    public int getHitCount() {
        if (!this.cbSkipCount.isSelected()) {
            return 0;
        }
        String string = this.tfSkipCount.getText().trim();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String valiadateMsg() {
        String string = this.tfSkipCount.getText().trim();
        if (this.cbSkipCount.isSelected()) {
            if (string.length() > 0) {
                int n;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_Bad_Hit_Count_Filter_Spec", (Object)string);
                }
                if (n <= 0) {
                    return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_NonPositive_Hit_Count_Filter_Spec");
                }
            } else {
                return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_No_Hit_Count_Filter_Spec");
            }
        }
        if (this.cbCondition.isSelected() && this.tfCondition.getText().trim().length() == 0) {
            return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_No_Condition_Spec");
        }
        return null;
    }

    private void initComponents() {
        this.cbCondition = new JCheckBox();
        this.spCondition = new JScrollPane();
        this.tfCondition = new JEditorPane();
        this.panelHitCountFilter = new JPanel();
        this.cbSkipCount = new JCheckBox();
        this.tfSkipCount = new JTextField();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ConditionsPanel.class, (String)"L_Conditions_Breakpoint_BorderTitle")));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cbCondition, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"L_cbCondition"));
        this.cbCondition.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TT_cbCondition"));
        this.cbCondition.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbCondition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConditionsPanel.this.cbConditionActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbCondition, gridBagConstraints);
        this.spCondition = ContextBindingSupport.createScrollableLineEditor(this.tfCondition);
        this.spCondition.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.spCondition.toolTipText"));
        this.tfCondition.setContentType(NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.tfCondition.contentType"));
        this.tfCondition.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.tfCondition.toolTipText"));
        this.spCondition.setViewportView(this.tfCondition);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.spCondition, gridBagConstraints);
        this.panelHitCountFilter.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cbSkipCount, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"L_SkipCount"));
        this.cbSkipCount.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TT_SkiptCount"));
        this.cbSkipCount.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSkipCount.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConditionsPanel.this.cbSkipCountActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelHitCountFilter.add((Component)this.cbSkipCount, gridBagConstraints);
        this.tfSkipCount.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TT_SkipCount"));
        this.tfSkipCount.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelHitCountFilter.add((Component)this.tfSkipCount, gridBagConstraints);
        this.tfSkipCount.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSN_HitCountTF"));
        this.tfSkipCount.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSD_HitCountTF"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelHitCountFilter, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionsPanel.class, (String)"L_Conditions_Breakpoint_BorderTitle"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSD_Conditions"));
    }

    private void cbSkipCountActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.cbSkipCount.isSelected();
        this.tfSkipCount.setEnabled(bl);
        if (bl) {
            this.tfSkipCount.requestFocusInWindow();
        }
    }

    private void cbConditionActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.cbCondition.isSelected();
        if (bl) {
            this.spCondition.setVisible(true);
            this.tfConditionFieldForUI.setVisible(false);
            this.tfCondition.requestFocusInWindow();
        } else {
            this.spCondition.setVisible(false);
            this.tfConditionFieldForUI.setText(this.tfCondition.getText());
            this.tfConditionFieldForUI.setVisible(true);
        }
        this.revalidate();
        this.repaint();
    }
}

