/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.DebuggerBreakpointAnnotation;
import org.netbeans.modules.cnd.debugger.common.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineTranslations;
import org.netbeans.modules.cnd.debugger.common.breakpoints.SessionBreakpointAnnotationProvider;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class BreakpointAnnotationProvider
implements AnnotationProvider,
DebuggerManagerListener {
    private final Map<CndBreakpoint, Set<Annotation>> breakpointToAnnotations = new HashMap<CndBreakpoint, Set<Annotation>>();
    private final Set<FileObject> annotatedFiles = new WeakSet();
    private Set<PropertyChangeListener> dataObjectListeners;
    private boolean attachManagerListener = true;
    private final Logger log = Logger.getLogger("cnd.breakpoint.annotations");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Line.Set set, Lookup lookup) {
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject != null) {
            DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
            if (dataObject != null) {
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("primaryFile".equals(propertyChangeEvent.getPropertyName())) {
                            DataObject dataObject = (DataObject)propertyChangeEvent.getSource();
                            FileObject fileObject = dataObject.getPrimaryFile();
                            BreakpointAnnotationProvider.this.annotate(fileObject);
                        }
                    }
                };
                dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)propertyChangeListener, (Object)dataObject));
                BreakpointAnnotationProvider breakpointAnnotationProvider = this;
                synchronized (breakpointAnnotationProvider) {
                    if (this.dataObjectListeners == null) {
                        this.dataObjectListeners = new HashSet<PropertyChangeListener>();
                    }
                    this.dataObjectListeners.add(propertyChangeListener);
                }
            }
            this.annotate(fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(FileObject fileObject) {
        Map<CndBreakpoint, Set<Annotation>> map = this.breakpointToAnnotations;
        synchronized (map) {
            if (this.annotatedFiles.contains(fileObject)) {
                this.log.fine("BreakpointAnnotationProvider.annotate: " + fileObject.getNameExt() + " is already annotated");
                return;
            }
            Set<CndBreakpoint> set = this.breakpointToAnnotations.keySet();
            for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                if (!BreakpointAnnotationProvider.isAnnotatable(breakpoint)) continue;
                CndBreakpoint cndBreakpoint = (CndBreakpoint)breakpoint;
                if (!set.contains((Object)cndBreakpoint)) {
                    cndBreakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                    this.breakpointToAnnotations.put(cndBreakpoint, (Set<Annotation>)new WeakSet());
                    if (cndBreakpoint instanceof LineBreakpoint) {
                        LineBreakpoint lineBreakpoint = (LineBreakpoint)cndBreakpoint;
                        LineTranslations.getTranslations().registerForLineUpdates(lineBreakpoint);
                    }
                }
                this.addAnnotationTo(cndBreakpoint, fileObject);
            }
            this.annotatedFiles.add(fileObject);
        }
        if (this.attachManagerListener) {
            this.attachManagerListener = false;
            DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)((Object)this), (Object)DebuggerManager.getDebuggerManager()));
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            CndBreakpoint cndBreakpoint = (CndBreakpoint)breakpoint;
            this.log.fine("BreakpointAnnotationProvider.breakpointAdded: " + cndBreakpoint.getPath() + ":" + cndBreakpoint.getLineNumber());
            cndBreakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            RequestProcessor.getDefault().post((Runnable)new AnnotationRefresh(cndBreakpoint, false, true));
            if (cndBreakpoint instanceof LineBreakpoint) {
                LineBreakpoint lineBreakpoint = (LineBreakpoint)cndBreakpoint;
                LineTranslations.getTranslations().registerForLineUpdates(lineBreakpoint);
            }
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            CndBreakpoint cndBreakpoint = (CndBreakpoint)breakpoint;
            this.log.fine("BreakpointAnnotationProvider.breakpointRemoved: " + cndBreakpoint.getPath() + ":" + cndBreakpoint.getLineNumber());
            cndBreakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            RequestProcessor.getDefault().post((Runnable)new AnnotationRefresh(cndBreakpoint, true, false));
            if (cndBreakpoint instanceof LineBreakpoint) {
                LineBreakpoint lineBreakpoint = (LineBreakpoint)cndBreakpoint;
                LineTranslations.getTranslations().unregisterFromLineUpdates(lineBreakpoint);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if ("currentSession".equals(string)) {
            for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                if (!(breakpoint instanceof CndBreakpoint)) continue;
                RequestProcessor.getDefault().post((Runnable)new AnnotationRefresh((CndBreakpoint)breakpoint, true, true));
            }
            return;
        }
        if (!("enabled".equals(string) || "validity".equals(string) || "condition".equals(string) || "skipCount".equals(string) || "url".equals(string) || "functionName".equals(string) || "lineNumber".equals(string) || "address".equals(string) || "refresh".equals(string))) {
            return;
        }
        CndBreakpoint cndBreakpoint = (CndBreakpoint)((Object)propertyChangeEvent.getSource());
        boolean bl = false;
        for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (cndBreakpoint != breakpoint) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        RequestProcessor.getDefault().post((Runnable)new AnnotationRefresh(cndBreakpoint, true, true));
    }

    private static boolean isAnnotatable(Breakpoint breakpoint) {
        return (breakpoint instanceof LineBreakpoint || breakpoint instanceof FunctionBreakpoint || breakpoint instanceof AddressBreakpoint) && !((CndBreakpoint)breakpoint).isHidden();
    }

    public static String getAnnotationType(CndBreakpoint cndBreakpoint) {
        String string;
        boolean bl;
        String string2 = cndBreakpoint.getCondition();
        boolean bl2 = bl = string2 != null && string2.trim().length() > 0;
        if (cndBreakpoint instanceof LineBreakpoint) {
            string = cndBreakpoint.isEnabled() ? (bl ? "CondBreakpoint" : "Breakpoint") : (bl ? "DisabledCondBreakpoint" : "DisabledBreakpoint");
        } else if (cndBreakpoint instanceof FunctionBreakpoint) {
            string = cndBreakpoint.isEnabled() ? "FunctionBreakpoint" : "DisabledFunctionBreakpoint";
        } else if (cndBreakpoint instanceof AddressBreakpoint) {
            string = cndBreakpoint.isEnabled() ? "AddressBreakpoint" : "DisabledAddressBreakpoint";
        } else {
            throw new IllegalStateException(((Object)((Object)cndBreakpoint)).toString());
        }
        return string;
    }

    private static int[] getAnnotationLines(CndBreakpoint cndBreakpoint, FileObject fileObject) {
        SessionBreakpointAnnotationProvider sessionBreakpointAnnotationProvider;
        if (cndBreakpoint instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)cndBreakpoint;
            try {
                if (fileObject.getURL().equals(new URL(lineBreakpoint.getURL()))) {
                    return new int[]{lineBreakpoint.getLineNumber()};
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
            return null;
        }
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine != null && (sessionBreakpointAnnotationProvider = (SessionBreakpointAnnotationProvider)debuggerEngine.lookupFirst(null, SessionBreakpointAnnotationProvider.class)) != null) {
            return sessionBreakpointAnnotationProvider.getBreakpointAnnotationLines(cndBreakpoint, fileObject);
        }
        return null;
    }

    private void addAnnotationTo(CndBreakpoint cndBreakpoint, FileObject fileObject) {
        Object object;
        int[] nArray = BreakpointAnnotationProvider.getAnnotationLines(cndBreakpoint, fileObject);
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.log.fine("BreakpointAnnotationProvider.addAnnotationTo: " + cndBreakpoint.getPath() + ":" + cndBreakpoint.getLineNumber());
        String string = BreakpointAnnotationProvider.getAnnotationType(cndBreakpoint);
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine != null && (object = (SessionBreakpointAnnotationProvider)debuggerEngine.lookupFirst(null, SessionBreakpointAnnotationProvider.class)) != null) {
            string = object.getAnnotationType(cndBreakpoint);
        }
        try {
            object = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
            return;
        }
        LineCookie lineCookie = (LineCookie)object.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return;
        }
        ArrayList<DebuggerBreakpointAnnotation> arrayList = new ArrayList<DebuggerBreakpointAnnotation>();
        for (int n : nArray) {
            try {
                Line line = lineCookie.getLineSet().getCurrent(n - 1);
                DebuggerBreakpointAnnotation debuggerBreakpointAnnotation = new DebuggerBreakpointAnnotation(string, line, cndBreakpoint);
                arrayList.add(debuggerBreakpointAnnotation);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (arrayList.isEmpty()) {
            return;
        }
        Object object2 = this.breakpointToAnnotations.get((Object)cndBreakpoint);
        if (object2 == null) {
            this.breakpointToAnnotations.put(cndBreakpoint, (Set<Annotation>)new WeakSet(arrayList));
        } else {
            object2.addAll(arrayList);
            this.breakpointToAnnotations.put(cndBreakpoint, (Set<Annotation>)object2);
        }
    }

    private void removeAnnotations(CndBreakpoint cndBreakpoint) {
        Set<Annotation> set = this.breakpointToAnnotations.remove((Object)cndBreakpoint);
        if (set == null) {
            return;
        }
        for (Annotation annotation : set) {
            annotation.detach();
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }

    private final class AnnotationRefresh
    implements Runnable {
        private CndBreakpoint b;
        private boolean remove;
        private boolean add;

        public AnnotationRefresh(CndBreakpoint cndBreakpoint, boolean bl, boolean bl2) {
            this.b = cndBreakpoint;
            this.remove = bl;
            this.add = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = BreakpointAnnotationProvider.this.breakpointToAnnotations;
            synchronized (map) {
                if (this.remove) {
                    BreakpointAnnotationProvider.this.removeAnnotations(this.b);
                    if (!this.add) {
                        BreakpointAnnotationProvider.this.breakpointToAnnotations.remove((Object)this.b);
                    }
                }
                if (this.add) {
                    BreakpointAnnotationProvider.this.breakpointToAnnotations.put(this.b, new WeakSet());
                    for (FileObject fileObject : BreakpointAnnotationProvider.this.annotatedFiles) {
                        BreakpointAnnotationProvider.this.addAnnotationTo(this.b, fileObject);
                    }
                }
            }
        }
    }
}

