/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common.CallStackFrame;
import org.netbeans.modules.cnd.debugger.common.EditorContext;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.disassembly.DisassemblyService;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.util.Utilities;

public class EditorContextBridge {
    public static final String FUNCTION = "function";
    public static final String LINE = "line";
    private static EditorContext context;

    public static EditorContext getContext() {
        if (context == null) {
            List list = DebuggerManager.getDebuggerManager().lookup(null, EditorContext.class);
            context = (EditorContext)list.get(0);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                context = new CompoundContextProvider((EditorContext)list.get(i), context);
            }
        }
        return context;
    }

    public static boolean showSource(String string, int n, Object object) {
        return EditorContextBridge.getContext().showSource(string, n, object);
    }

    public static boolean showSource(CallStackFrame callStackFrame, boolean bl) {
        if (bl) {
            return EditorContextBridge.showDis(callStackFrame);
        }
        return EditorContextBridge.showCode(callStackFrame);
    }

    public static boolean showCode(CallStackFrame callStackFrame) {
        FileObject fileObject;
        File file;
        String string = callStackFrame.getFullname();
        if (string != null && (file = new File(string)).exists() && (fileObject = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)file))) != null) {
            try {
                return EditorContextBridge.getContext().showSource(DataObject.find((FileObject)fileObject), callStackFrame.getLineNumber(), null);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public static DisassemblyService getCurrentDisassemblyService() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        return (DisassemblyService)debuggerEngine.lookupFirst(null, DisassemblyService.class);
    }

    public static boolean showDis(CallStackFrame callStackFrame) {
        DisassemblyService disassemblyService = EditorContextBridge.getCurrentDisassemblyService();
        if (disassemblyService != null) {
            return disassemblyService.showAddress(callStackFrame.getAddr());
        }
        return false;
    }

    public static String getUrl(File file) {
        String string;
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        try {
            string = fileObject.getURL().toExternalForm();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            string = Utilities.isWindows() ? "file:/" + fileObject.getPath().replace(" ", "%20") : "file:/" + fileObject.getPath();
        }
        return string;
    }

    public static void createTimeStamp(Object object) {
        EditorContextBridge.getContext().createTimeStamp(object);
    }

    public static void disposeTimeStamp(Object object) {
        EditorContextBridge.getContext().disposeTimeStamp(object);
    }

    public static Annotation annotate(CallStackFrame callStackFrame, String string) {
        FileObject fileObject;
        File file;
        String string2 = callStackFrame.getFullname();
        if (string2 != null && (file = new File(string2)).exists() && (fileObject = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)file))) != null) {
            try {
                return EditorContextBridge.getContext().annotate(DataObject.find((FileObject)fileObject), callStackFrame.getLineNumber(), string, null);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Annotation annotateDis(CallStackFrame callStackFrame, String string) {
        DisassemblyService disassemblyService = EditorContextBridge.getCurrentDisassemblyService();
        if (disassemblyService != null) {
            return disassemblyService.annotateAddress(callStackFrame.getAddr(), string);
        }
        return null;
    }

    public static void removeAnnotation(Annotation annotation) {
        EditorContextBridge.getContext().removeAnnotation(annotation);
    }

    public static int getLineNumber(Object object, Object object2) {
        return EditorContextBridge.getContext().getLineNumber(object, object2);
    }

    public static int getCurrentLineNumber() {
        return EditorContextBridge.getContext().getCurrentLineNumber();
    }

    public static int getMostRecentLineNumber() {
        return EditorContextBridge.getContext().getMostRecentLineNumber();
    }

    public static String getCurrentURL() {
        return EditorContextBridge.getContext().getCurrentURL();
    }

    public static String getMostRecentURL() {
        return EditorContextBridge.getContext().getMostRecentURL();
    }

    public static String getCurrentFunctionName() {
        return EditorContextBridge.getContext().getCurrentFunctionName();
    }

    public static String getSelectedFunctionName() {
        return EditorContextBridge.getContext().getSelectedFunctionName();
    }

    public static int getFieldLineNumber(String string, String string2, String string3) {
        return EditorContextBridge.getContext().getFieldLineNumber(string, string2, string3);
    }

    public String getCurrentMIMEType() {
        return EditorContextBridge.getContext().getCurrentMIMEType();
    }

    public static String getMostRecentMIMEType() {
        return EditorContextBridge.getContext().getMostRecentMIMEType();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        EditorContextBridge.getContext().addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        EditorContextBridge.getContext().removePropertyChangeListener(propertyChangeListener);
    }

    public static String getFileName(CndBreakpoint cndBreakpoint) {
        try {
            return EditorContextBridge.basename(new File(new URL(cndBreakpoint.getURL()).getFile()).getName());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static String basename(String string) {
        int n = string.lastIndexOf(47);
        if (n > 0) {
            return string.substring(n);
        }
        return string;
    }

    public static boolean showSource(CndBreakpoint cndBreakpoint, Object object) {
        DisassemblyService disassemblyService;
        if (cndBreakpoint instanceof LineBreakpoint) {
            if (cndBreakpoint.getLineNumber() < 1) {
                return EditorContextBridge.showSource(cndBreakpoint.getURL(), 1, object);
            }
            return EditorContextBridge.showSource(cndBreakpoint.getURL(), cndBreakpoint.getLineNumber(), object);
        }
        if (cndBreakpoint instanceof AddressBreakpoint && (disassemblyService = EditorContextBridge.getCurrentDisassemblyService()) != null) {
            return disassemblyService.showBreakpoint((AddressBreakpoint)cndBreakpoint);
        }
        return false;
    }

    public static String getDefaultType() {
        return LINE;
    }

    public static String getRelativePath(String string) {
        return string.replace('.', '/') + ".java";
    }

    private static String convertSlash(String string) {
        return string.replace(File.separatorChar, '/');
    }

    private static class CompoundAnnotation
    extends Annotation {
        Annotation annotation1;
        Annotation annotation2;

        private CompoundAnnotation() {
        }

        public String getAnnotationType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getShortDescription() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class CompoundContextProvider
    extends EditorContext {
        private EditorContext cp1;
        private EditorContext cp2;

        CompoundContextProvider(EditorContext editorContext, EditorContext editorContext2) {
            this.cp1 = editorContext;
            this.cp2 = editorContext2;
        }

        public void createTimeStamp(Object object) {
            this.cp1.createTimeStamp(object);
            this.cp2.createTimeStamp(object);
        }

        public void disposeTimeStamp(Object object) {
            this.cp1.disposeTimeStamp(object);
            this.cp2.disposeTimeStamp(object);
        }

        public void updateTimeStamp(Object object, String string) {
            this.cp1.updateTimeStamp(object, string);
            this.cp2.updateTimeStamp(object, string);
        }

        public String getCurrentURL() {
            String string = this.cp1.getCurrentURL();
            if (string.trim().length() < 1) {
                return this.cp2.getCurrentURL();
            }
            return string;
        }

        public String getMostRecentURL() {
            String string = this.cp1.getMostRecentURL();
            if (string.trim().length() < 1) {
                return this.cp2.getMostRecentURL();
            }
            return string;
        }

        public int getCurrentLineNumber() {
            int n = this.cp1.getCurrentLineNumber();
            if (n < 1) {
                return this.cp2.getCurrentLineNumber();
            }
            return n;
        }

        public int getMostRecentLineNumber() {
            int n = this.cp1.getMostRecentLineNumber();
            if (n < 1) {
                return this.cp2.getMostRecentLineNumber();
            }
            return n;
        }

        public String getCurrentFunctionName() {
            String string = this.cp1.getCurrentFunctionName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getCurrentFunctionName();
            }
            return string;
        }

        public DataObject getCurrentDataObject() {
            DataObject dataObject = this.cp1.getCurrentDataObject();
            if (dataObject == null) {
                dataObject = this.cp2.getCurrentDataObject();
            }
            return dataObject;
        }

        public DataObject getMostRecentDataObject() {
            DataObject dataObject = this.cp1.getMostRecentDataObject();
            if (dataObject == null) {
                dataObject = this.cp2.getMostRecentDataObject();
            }
            return dataObject;
        }

        public FileObject getMostRecentFileObject() {
            FileObject fileObject = this.cp1.getMostRecentFileObject();
            if (fileObject == null) {
                fileObject = this.cp2.getMostRecentFileObject();
            }
            return fileObject;
        }

        public FileObject getCurrentFileObject() {
            FileObject fileObject = this.cp1.getCurrentFileObject();
            if (fileObject == null) {
                fileObject = this.cp2.getCurrentFileObject();
            }
            return fileObject;
        }

        public String getSelectedFunctionName() {
            String string = this.cp1.getSelectedFunctionName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getSelectedFunctionName();
            }
            return string;
        }

        public void removeAnnotation(Annotation annotation) {
            CompoundAnnotation compoundAnnotation = (CompoundAnnotation)annotation;
            this.cp1.removeAnnotation(compoundAnnotation.annotation1);
            this.cp2.removeAnnotation(compoundAnnotation.annotation2);
        }

        public Annotation annotate(String string, int n, String string2, Object object) {
            CompoundAnnotation compoundAnnotation = new CompoundAnnotation();
            compoundAnnotation.annotation1 = this.cp1.annotate(string, n, string2, object);
            compoundAnnotation.annotation2 = this.cp2.annotate(string, n, string2, object);
            return compoundAnnotation;
        }

        public Annotation annotate(DataObject dataObject, int n, String string, Object object) {
            CompoundAnnotation compoundAnnotation = new CompoundAnnotation();
            compoundAnnotation.annotation1 = this.cp1.annotate(dataObject, n, string, object);
            compoundAnnotation.annotation2 = this.cp2.annotate(dataObject, n, string, object);
            return compoundAnnotation;
        }

        public int getLineNumber(Object object, Object object2) {
            CompoundAnnotation compoundAnnotation = new CompoundAnnotation();
            int n = this.cp1.getLineNumber(compoundAnnotation.annotation1, object2);
            if (n >= 0) {
                return n;
            }
            return this.cp2.getLineNumber(compoundAnnotation.annotation2, object2);
        }

        public boolean showSource(String string, int n, Object object) {
            return this.cp1.showSource(string, n, object) | this.cp2.showSource(string, n, object);
        }

        public boolean showSource(DataObject dataObject, int n, Object object) {
            return this.cp1.showSource(dataObject, n, object) | this.cp2.showSource(dataObject, n, object);
        }

        public int getFieldLineNumber(String string, String string2, String string3) {
            int n = this.cp1.getFieldLineNumber(string, string2, string3);
            if (n != -1) {
                return n;
            }
            return this.cp2.getFieldLineNumber(string, string2, string3);
        }

        public String getCurrentMIMEType() {
            String string = this.cp1.getCurrentMIMEType();
            if (string == null) {
                return this.cp2.getCurrentMIMEType();
            }
            return string;
        }

        public String getMostRecentMIMEType() {
            String string = this.cp1.getMostRecentMIMEType();
            if (string == null) {
                return this.cp2.getMostRecentMIMEType();
            }
            return string;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(propertyChangeListener);
            this.cp2.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(propertyChangeListener);
            this.cp2.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

