/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.DebuggerOutput;
import org.netbeans.modules.debugger.jpda.ui.IOManager;
import org.netbeans.modules.debugger.jpda.ui.VariablesFormatter;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTableModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.VariablesFilterAdapter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class VariablesFormatterFilter
extends VariablesFilterAdapter {
    static Map<Object, String> FORMATTED_CHILDREN_VARS = new WeakHashMap<Object, String>();
    private IOManager ioManager;
    private boolean formattersLoopWarned = false;
    private static HashSet leafType;
    private static HashSet toStringValueType;

    public VariablesFormatterFilter(ContextProvider contextProvider) {
        List list = contextProvider.lookup(null, LazyActionsManagerListener.class);
        for (Object e : list) {
            if (!(e instanceof DebuggerOutput)) continue;
            this.ioManager = ((DebuggerOutput)e).getIOManager();
            break;
        }
    }

    public String[] getSupportedTypes() {
        VariablesFormatter[] variablesFormatterArray = VariablesFormatter.loadFormatters();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < variablesFormatterArray.length; ++i) {
            String[] stringArray;
            if (variablesFormatterArray[i].isIncludeSubTypes()) continue;
            for (String string : stringArray = variablesFormatterArray[i].getClassTypes()) {
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getSupportedAncestors() {
        VariablesFormatter[] variablesFormatterArray = VariablesFormatter.loadFormatters();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < variablesFormatterArray.length; ++i) {
            String[] stringArray;
            if (!variablesFormatterArray[i].isIncludeSubTypes()) continue;
            for (String string : stringArray = variablesFormatterArray[i].getClassTypes()) {
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public Object[] getChildren(TreeModel treeModel, Variable variable, int n, int n2) throws UnknownTypeException {
        if (!(variable instanceof ObjectVariable)) {
            treeModel.getChildren((Object)variable, n, n2);
        }
        return this.getChildren(treeModel, variable, n, n2, new FormattersLoopControl());
    }

    private Object[] getChildren(TreeModel treeModel, Variable variable, int n, int n2, FormattersLoopControl formattersLoopControl) throws UnknownTypeException {
        if (variable instanceof ObjectVariable) {
            ObjectVariable objectVariable = (ObjectVariable)variable;
            JPDAClassType jPDAClassType = objectVariable.getClassType();
            if (jPDAClassType == null) {
                return treeModel.getChildren((Object)variable, n, n2);
            }
            VariablesFormatter variablesFormatter = this.getFormatterForType(jPDAClassType, formattersLoopControl.getFormatters());
            if (variablesFormatter != null && formattersLoopControl.canUse(variablesFormatter, jPDAClassType.getName())) {
                if (variablesFormatter.isUseChildrenVariables()) {
                    Map<String, String> map = variablesFormatter.getChildrenVariables();
                    Object[] objectArray = new Object[map.size()];
                    int n3 = 0;
                    for (String string : map.keySet()) {
                        Object object;
                        try {
                            Method method = objectVariable.getClass().getMethod("evaluate", String.class);
                            method.setAccessible(true);
                            object = method.invoke((Object)objectVariable, map.get(string));
                            FORMATTED_CHILDREN_VARS.put(object, string);
                            objectArray[n3++] = object;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            object = invocationTargetException.getTargetException();
                            if (!(object instanceof InvalidExpressionException)) {
                                Exceptions.printStackTrace((Throwable)object);
                            }
                            return treeModel.getChildren((Object)variable, n, n2);
                        }
                        catch (Exception exception) {
                            Exceptions.printStackTrace((Throwable)exception);
                            return treeModel.getChildren((Object)variable, n, n2);
                        }
                    }
                    return objectArray;
                }
                String string = variablesFormatter.getChildrenFormatCode();
                if (string != null && string.length() > 0) {
                    try {
                        Method method = objectVariable.getClass().getMethod("evaluate", String.class);
                        method.setAccessible(true);
                        Variable variable2 = (Variable)method.invoke((Object)objectVariable, string);
                        return this.getChildren(treeModel, variable2, n, n2, formattersLoopControl);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getTargetException();
                        if (throwable instanceof InvalidExpressionException) {
                            return treeModel.getChildren((Object)variable, n, n2);
                        }
                        Exceptions.printStackTrace((Throwable)throwable);
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                }
            }
        }
        return treeModel.getChildren((Object)variable, n, n2);
    }

    private VariablesFormatter getFormatterForType(JPDAClassType jPDAClassType, VariablesFormatter[] variablesFormatterArray) {
        String string = jPDAClassType.getName();
        for (VariablesFormatter variablesFormatter : variablesFormatterArray) {
            if (!variablesFormatter.isEnabled()) continue;
            String[] stringArray = variablesFormatter.getClassTypes();
            boolean bl = false;
            for (String string2 : stringArray) {
                if (!string2.equals(string) && (!variablesFormatter.isIncludeSubTypes() || !VariablesFormatterFilter.isInstanceOf(jPDAClassType, string2))) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            return variablesFormatter;
        }
        return null;
    }

    public int getChildrenCount(TreeModel treeModel, Variable variable) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean isLeaf(TreeModel treeModel, Variable variable) throws UnknownTypeException {
        Object object;
        JPDAClassType jPDAClassType;
        if (variable instanceof ObjectVariable && (jPDAClassType = (object = (ObjectVariable)variable).getClassType()) == null) {
            return treeModel.isLeaf((Object)variable);
        }
        object = variable.getType();
        if (VariablesFormatterFilter.isLeafType((String)object)) {
            return true;
        }
        return treeModel.isLeaf((Object)variable);
    }

    public Object getValueAt(TableModel tableModel, Variable variable, String string) throws UnknownTypeException {
        if (!(variable instanceof ObjectVariable)) {
            return tableModel.getValueAt((Object)variable, string);
        }
        return this.getValueAt(tableModel, variable, string, new FormattersLoopControl());
    }

    private Object getValueAt(TableModel tableModel, Variable variable, String string, FormattersLoopControl formattersLoopControl) throws UnknownTypeException {
        String string2;
        if (!(variable instanceof ObjectVariable)) {
            return tableModel.getValueAt((Object)variable, string);
        }
        String string3 = variable.getType();
        ObjectVariable objectVariable = (ObjectVariable)variable;
        JPDAClassType jPDAClassType = objectVariable.getClassType();
        if (jPDAClassType == null) {
            return tableModel.getValueAt((Object)variable, string);
        }
        VariablesFormatter variablesFormatter = this.getFormatterForType(jPDAClassType, formattersLoopControl.getFormatters());
        if (variablesFormatter != null && formattersLoopControl.canUse(variablesFormatter, jPDAClassType.getName()) && (string == "LocalsValue" || string == "WatchValue" || string == "LocalsToString" || string == "WatchToString") && (string2 = variablesFormatter.getValueFormatCode()) != null && string2.length() > 0) {
            try {
                Method method = objectVariable.getClass().getMethod("evaluate", String.class);
                method.setAccessible(true);
                Variable variable2 = (Variable)method.invoke((Object)objectVariable, string2);
                return this.getValueAt(tableModel, variable2, string, formattersLoopControl);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof InvalidExpressionException) {
                    return VariablesTableModel.getMessage((InvalidExpressionException)throwable);
                }
                Exceptions.printStackTrace((Throwable)throwable);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        if (VariablesFormatterFilter.isToStringValueType(string3) && (string == "LocalsValue" || string == "WatchValue")) {
            try {
                return "\"" + objectVariable.getToStringValue() + "\"";
            }
            catch (InvalidExpressionException invalidExpressionException) {
                Logger.getLogger(VariablesFormatterFilter.class.getName()).fine("getToStringValue() " + invalidExpressionException.getLocalizedMessage());
                if (invalidExpressionException.getTargetException() != null && invalidExpressionException.getTargetException() instanceof UnsupportedOperationException) {
                    return tableModel.getValueAt((Object)variable, string);
                }
                return invalidExpressionException.getLocalizedMessage();
            }
        }
        return tableModel.getValueAt((Object)variable, string);
    }

    public void setValueAt(TableModel tableModel, Variable variable, String string, Object object) throws UnknownTypeException {
        String string2;
        String string3 = variable.getType();
        if (VariablesFormatterFilter.isToStringValueType(string3) && (string == "LocalsValue" || string == "WatchValue") && (string2 = (String)object).startsWith("\"") && string2.endsWith("\"") && string2.length() > 1) {
            string2 = "new " + string3 + "(\"" + VariablesFormatterFilter.convertToStringInitializer(string2.substring(1, string2.length() - 1)) + "\")";
            tableModel.setValueAt((Object)variable, string, (Object)string2);
            return;
        }
        tableModel.setValueAt((Object)variable, string, object);
    }

    private static String convertToStringInitializer(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block9;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static boolean isLeafType(String string) {
        if (leafType == null) {
            leafType = new HashSet();
            leafType.add("java.lang.String");
            leafType.add("java.lang.Character");
            leafType.add("java.lang.Integer");
            leafType.add("java.lang.Float");
            leafType.add("java.lang.Byte");
            leafType.add("java.lang.Boolean");
            leafType.add("java.lang.Double");
            leafType.add("java.lang.Long");
            leafType.add("java.lang.Short");
        }
        return leafType.contains(string);
    }

    private static boolean isToStringValueType(String string) {
        if (toStringValueType == null) {
            toStringValueType = new HashSet();
            toStringValueType.add("java.lang.StringBuffer");
            toStringValueType.add("java.lang.StringBuilder");
        }
        return toStringValueType.contains(string);
    }

    private static boolean isInstanceOf(JPDAClassType jPDAClassType, String string) {
        if (jPDAClassType == null) {
            return false;
        }
        try {
            Method method = jPDAClassType.getClass().getMethod("isInstanceOf", String.class);
            return (Boolean)method.invoke((Object)jPDAClassType, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof VMDisconnectedException) {
                return false;
            }
            if (throwable instanceof ObjectCollectedException) {
                return false;
            }
            if (throwable instanceof InternalException) {
                return false;
            }
            if (throwable instanceof InvalidStackFrameException) {
                return false;
            }
            Exceptions.printStackTrace((Throwable)invocationTargetException);
            return false;
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return false;
        }
    }

    private final class FormattersLoopControl {
        private VariablesFormatter[] formatters = VariablesFormatter.loadFormatters();
        private Map<String, VariablesFormatter> usedFormatters = new LinkedHashMap<String, VariablesFormatter>();

        public VariablesFormatter[] getFormatters() {
            return this.formatters;
        }

        public boolean canUse(VariablesFormatter variablesFormatter, String string) {
            boolean bl;
            boolean bl2 = bl = this.usedFormatters.put(string, variablesFormatter) == null;
            if (!bl && VariablesFormatterFilter.this.ioManager != null) {
                if (!VariablesFormatterFilter.this.formattersLoopWarned) {
                    VariablesFormatterFilter.this.formattersLoopWarned = true;
                    VariablesFormatterFilter.this.ioManager.println(NbBundle.getMessage(VariablesFormatterFilter.class, (String)"MSG_LoopInTypeFormattingIntroErrorMessage"), null, true);
                }
                ArrayList<String> arrayList = new ArrayList<String>(this.usedFormatters.size());
                for (Map.Entry<String, VariablesFormatter> entry : this.usedFormatters.entrySet()) {
                    arrayList.add(entry.getValue().getName() + " (" + entry.getKey() + ")");
                }
                VariablesFormatterFilter.this.ioManager.println(NbBundle.getMessage(VariablesFormatterFilter.class, (String)"MSG_LoopInTypeFormatting", (Object)((Object)arrayList).toString()), null, false);
            }
            return bl;
        }
    }
}

