/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingMonitorModel;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeExpansionModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.WeakSet;

public class DebuggingTreeExpansionModelFilter
implements TreeExpansionModelFilter {
    private static final Map<JPDADebugger, DebuggingTreeExpansionModelFilter> FILTERS = new WeakHashMap<JPDADebugger, DebuggingTreeExpansionModelFilter>();
    private final Set<Object> expandedNodes = new WeakSet();
    private final Set<Object> expandedExplicitely = new WeakSet();
    private final List<ModelListener> listeners = new ArrayList<ModelListener>();
    private final Reference<JPDADebugger> debuggerRef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggingTreeExpansionModelFilter(ContextProvider contextProvider) {
        JPDADebugger jPDADebugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debuggerRef = new WeakReference<JPDADebugger>(jPDADebugger);
        Map<JPDADebugger, DebuggingTreeExpansionModelFilter> map = FILTERS;
        synchronized (map) {
            FILTERS.put(jPDADebugger, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isExpanded(JPDADebugger jPDADebugger, Object object) {
        DebuggingTreeExpansionModelFilter debuggingTreeExpansionModelFilter;
        Map<JPDADebugger, DebuggingTreeExpansionModelFilter> map = FILTERS;
        synchronized (map) {
            debuggingTreeExpansionModelFilter = FILTERS.get(jPDADebugger);
        }
        if (debuggingTreeExpansionModelFilter == null) {
            return false;
        }
        return debuggingTreeExpansionModelFilter.isExpanded(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expand(JPDADebugger jPDADebugger, Object object) {
        DebuggingTreeExpansionModelFilter debuggingTreeExpansionModelFilter;
        Map<JPDADebugger, DebuggingTreeExpansionModelFilter> map = FILTERS;
        synchronized (map) {
            debuggingTreeExpansionModelFilter = FILTERS.get(jPDADebugger);
        }
        if (debuggingTreeExpansionModelFilter != null) {
            debuggingTreeExpansionModelFilter.expand(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expand(Object object) {
        DebuggingTreeExpansionModelFilter debuggingTreeExpansionModelFilter = this;
        synchronized (debuggingTreeExpansionModelFilter) {
            this.expandedExplicitely.add(object);
        }
        this.fireNodeExpanded(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExpanded(Object object) {
        DebuggingTreeExpansionModelFilter debuggingTreeExpansionModelFilter = this;
        synchronized (debuggingTreeExpansionModelFilter) {
            return this.expandedNodes.contains(object) || this.expandedExplicitely.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpanded(TreeExpansionModel treeExpansionModel, Object object) throws UnknownTypeException {
        Object object2;
        JPDADebugger jPDADebugger = this.debuggerRef.get();
        if (jPDADebugger == null) {
            return false;
        }
        Set set = DebuggingNodeModel.getNodesInDeadlock(jPDADebugger);
        if (set != null) {
            object2 = set;
            synchronized (object2) {
                if (set.contains(object)) {
                    return true;
                }
            }
        }
        object2 = this;
        synchronized (object2) {
            if (this.expandedExplicitely.contains(object)) {
                return true;
            }
        }
        if (object instanceof JPDAThreadGroup) {
            return true;
        }
        if (object instanceof JPDAThread && ((JPDAThread)object).getCurrentBreakpoint() != null) {
            return true;
        }
        if (object instanceof CallStackFrame) {
            return true;
        }
        if (object instanceof DebuggingMonitorModel.OwnedMonitors) {
            return ((DebuggingMonitorModel.OwnedMonitors)object).monitors != null;
        }
        return treeExpansionModel.isExpanded(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeExpanded(Object object) {
        DebuggingTreeExpansionModelFilter debuggingTreeExpansionModelFilter = this;
        synchronized (debuggingTreeExpansionModelFilter) {
            this.expandedNodes.add(object);
        }
        if (object instanceof JPDAThread || object instanceof JPDAThreadGroup) {
            this.fireNodeChanged(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeCollapsed(Object object) {
        DebuggingTreeExpansionModelFilter debuggingTreeExpansionModelFilter = this;
        synchronized (debuggingTreeExpansionModelFilter) {
            this.expandedNodes.remove(object);
            this.expandedExplicitely.remove(object);
        }
        if (object instanceof JPDAThread || object instanceof JPDAThreadGroup) {
            this.fireNodeChanged(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChanged(Object object) {
        ArrayList<ModelListener> arrayList;
        ModelEvent.NodeChanged nodeChanged = this.listeners;
        synchronized (nodeChanged) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        nodeChanged = new ModelEvent.NodeChanged((Object)this, object, 1);
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged((ModelEvent)nodeChanged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeExpanded(Object object) {
        ArrayList<ModelListener> arrayList;
        ModelEvent.NodeChanged nodeChanged = this.listeners;
        synchronized (nodeChanged) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        nodeChanged = new ModelEvent.NodeChanged((Object)this, object, 16);
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged((ModelEvent)nodeChanged);
        }
    }
}

