/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import java.util.List;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.ThreadInfo;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.storage.impl.SQLStackDataStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SnapshotImpl
implements ThreadSnapshot {
    private final Lock lock = new Lock();
    private final ThreadInfo threadInfo;
    private final SQLStackDataStorage storage;
    private final int stackID;
    private final long timestamp;
    private final ThreadState.MSAState state;
    private boolean stackLoaded = false;
    private List<FunctionCall> stack = null;

    public SnapshotImpl(SQLStackDataStorage sQLStackDataStorage, long l, final int n, int n2, ThreadState.MSAState mSAState) {
        this.timestamp = l;
        this.storage = sQLStackDataStorage;
        this.stackID = n2;
        this.state = mSAState;
        this.threadInfo = new ThreadInfo(){

            public int getThreadId() {
                return n;
            }

            public String getThreadName() {
                return "Thread " + n;
            }
        };
    }

    @Override
    public ThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCall> getStack() {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.stackLoaded) {
                return this.stack;
            }
            this.stack = this.storage.getCallStack(this.stackID);
            this.stackLoaded = true;
            return this.stack;
        }
    }

    @Override
    public ThreadState.MSAState getState() {
        return this.state;
    }

    @Override
    public ThreadSnapshot.MemoryAccessType getMemoryAccessType() {
        return null;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

