/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningConfig;
import org.netbeans.modules.versioning.diff.DiffSidebar;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffSidebarManager
implements PreferenceChangeListener {
    static final String SIDEBAR_ENABLED = "diff.sidebarEnabled";
    private static DiffSidebarManager instance;
    private boolean sidebarEnabled;
    private final Map<DiffSidebar, Object> sideBars = new WeakHashMap<DiffSidebar, Object>();

    public static synchronized DiffSidebarManager getInstance() {
        if (instance == null) {
            instance = new DiffSidebarManager();
        }
        return instance;
    }

    private DiffSidebarManager() {
        this.sidebarEnabled = VersioningConfig.getDefault().getPreferences().getBoolean(SIDEBAR_ENABLED, true);
        VersioningConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public void refreshSidebars(Set<File> set) {
        HashSet<FileObject> hashSet = null;
        if (set != null) {
            hashSet = new HashSet<FileObject>(set.size());
            for (File file : set) {
                hashSet.add(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)));
            }
            hashSet.remove(null);
        }
        final HashSet<FileObject> hashSet2 = hashSet;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = DiffSidebarManager.this.sideBars;
                synchronized (map) {
                    for (DiffSidebar diffSidebar : DiffSidebarManager.this.sideBars.keySet()) {
                        if (!DiffSidebarManager.this.matches(diffSidebar, hashSet2)) continue;
                        diffSidebar.refresh();
                    }
                }
            }
        });
    }

    private boolean matches(DiffSidebar diffSidebar, Set<FileObject> set) {
        if (set == null) {
            return true;
        }
        for (FileObject fileObject : set) {
            if (!fileObject.equals(diffSidebar.getFileObject())) continue;
            return true;
        }
        return false;
    }

    RequestProcessor.Task createDiffSidebarTask(Runnable runnable) {
        return Utils.createTask(runnable);
    }

    JComponent createSideBar(JTextComponent jTextComponent) {
        return this.getSideBar(jTextComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiffSidebar getSideBar(JTextComponent jTextComponent) {
        Map<DiffSidebar, Object> map = this.sideBars;
        synchronized (map) {
            DiffSidebar diffSidebar = null;
            for (DiffSidebar diffSidebar2 : this.sideBars.keySet()) {
                if (diffSidebar2.getTextComponent() != jTextComponent) continue;
                diffSidebar = diffSidebar2;
                break;
            }
            if (diffSidebar == null) {
                DiffSidebar diffSidebar2;
                Document document = jTextComponent.getDocument();
                diffSidebar2 = this.fileForDocument(document);
                if (diffSidebar2 == null || !diffSidebar2.isValid()) {
                    return null;
                }
                diffSidebar = new DiffSidebar(jTextComponent, (FileObject)diffSidebar2);
                this.sideBars.put(diffSidebar, null);
                diffSidebar.setSidebarVisible(this.sidebarEnabled);
            }
            return diffSidebar;
        }
    }

    private FileObject fileForDocument(Document document) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        if (dataObject instanceof MultiDataObject) {
            return this.fileForDataobject(document, (MultiDataObject)dataObject);
        }
        if (dataObject != null) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    private FileObject fileForDataobject(Document document, MultiDataObject multiDataObject) {
        for (MultiDataObject.Entry entry : multiDataObject.secondaryEntries()) {
            CookieSet.Factory factory;
            EditorCookie editorCookie;
            StyledDocument styledDocument;
            if (!(entry instanceof CookieSet.Factory) || (styledDocument = (editorCookie = (EditorCookie)(factory = (CookieSet.Factory)entry).createCookie(EditorCookie.class)).getDocument()) != document) continue;
            return entry.getFile();
        }
        return multiDataObject.getPrimaryFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSidebarEnabled(boolean bl) {
        Map<DiffSidebar, Object> map = this.sideBars;
        synchronized (map) {
            for (DiffSidebar diffSidebar : this.sideBars.keySet()) {
                diffSidebar.setSidebarVisible(bl);
            }
            this.sidebarEnabled = bl;
        }
    }

    MarkProvider createMarkProvider(JTextComponent jTextComponent) {
        DiffSidebar diffSidebar = this.getSideBar(jTextComponent);
        return diffSidebar != null ? diffSidebar.getMarkProvider() : null;
    }

    DiffSidebar t9y_getSidebar() {
        return this.sideBars.keySet().iterator().next();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(SIDEBAR_ENABLED)) {
            this.setSidebarEnabled(Boolean.valueOf(preferenceChangeEvent.getNewValue()));
        }
    }
}

