/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Action;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.debugger.jpda.projects.EditorContextImpl;
import org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class BreakpointsActionsProvider
implements NodeActionsProviderFilter {
    private static final Action GO_TO_SOURCE_ACTION = Models.createAction((String)BreakpointsActionsProvider.loc("CTL_Breakpoint_GoToSource_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            BreakpointsActionsProvider.goToSource((JPDABreakpoint)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    private static String loc(String string) {
        return NbBundle.getBundle(BreakpointsActionsProvider.class).getString(string);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (!(object instanceof JPDABreakpoint) || object instanceof ThreadBreakpoint) {
            return nodeActionsProvider.getActions(object);
        }
        Action[] actionArray = nodeActionsProvider.getActions(object);
        Action[] actionArray2 = new Action[actionArray.length + 2];
        actionArray2[0] = GO_TO_SOURCE_ACTION;
        actionArray2[1] = null;
        System.arraycopy(actionArray, 0, actionArray2, 2, actionArray.length);
        return actionArray2;
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof JPDABreakpoint && !(object instanceof ThreadBreakpoint)) {
            BreakpointsActionsProvider.goToSource((JPDABreakpoint)object);
        } else {
            nodeActionsProvider.performDefaultAction(object);
        }
    }

    private static void goToSource(JPDABreakpoint jPDABreakpoint) {
        int n;
        String string;
        if (jPDABreakpoint instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)jPDABreakpoint;
            string = lineBreakpoint.getURL();
            n = lineBreakpoint.getLineNumber();
            if (n < 1) {
                n = 1;
            }
        } else if (jPDABreakpoint instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)jPDABreakpoint;
            String string2 = fieldBreakpoint.getFieldName();
            String string3 = fieldBreakpoint.getClassName();
            FileObject fileObject = BreakpointsActionsProvider.getFileObject(BreakpointsActionsProvider.getRelativePath(string3));
            if (fileObject == null) {
                return;
            }
            try {
                string = fileObject.getURL().toString();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return;
            }
            n = EditorContextImpl.getFieldLineNumber(fileObject, string3, string2);
        } else if (jPDABreakpoint instanceof MethodBreakpoint) {
            MethodBreakpoint methodBreakpoint = (MethodBreakpoint)jPDABreakpoint;
            String string4 = methodBreakpoint.getMethodName();
            String[] stringArray = methodBreakpoint.getClassFilters();
            if (stringArray.length < 1) {
                return;
            }
            String string5 = stringArray[0];
            FileObject fileObject = BreakpointsActionsProvider.getFileObject(BreakpointsActionsProvider.getRelativePath(string5));
            if (fileObject == null) {
                return;
            }
            try {
                string = fileObject.getURL().toString();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return;
            }
            int[] nArray = EditorContextImpl.getMethodLineNumbers(fileObject, string5, methodBreakpoint.getClassExclusionFilters(), string4, methodBreakpoint.getMethodSignature());
            n = nArray.length == 0 ? 1 : nArray[0];
        } else if (jPDABreakpoint instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)jPDABreakpoint;
            String string6 = exceptionBreakpoint.getExceptionClassName();
            FileObject fileObject = BreakpointsActionsProvider.getFileObject(BreakpointsActionsProvider.getRelativePath(string6));
            if (fileObject == null) {
                return;
            }
            try {
                string = fileObject.getURL().toString();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return;
            }
            n = 1;
        } else if (jPDABreakpoint instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = (ClassLoadUnloadBreakpoint)jPDABreakpoint;
            String[] stringArray = classLoadUnloadBreakpoint.getClassFilters();
            if (stringArray.length == 0) {
                return;
            }
            String string7 = stringArray[0];
            FileObject fileObject = BreakpointsActionsProvider.getFileObject(BreakpointsActionsProvider.getRelativePath(string7));
            if (fileObject == null) {
                return;
            }
            try {
                string = fileObject.getURL().toString();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return;
            }
            n = 1;
        } else {
            return;
        }
        EditorContextImpl.showSourceLine(string, n, null);
    }

    private static FileObject getFileObject(String string) {
        SourcePathProvider sourcePathProvider;
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine != null && (sourcePathProvider = (SourcePathProvider)debuggerEngine.lookupFirst(null, SourcePathProvider.class)) != null) {
            String string2 = sourcePathProvider.getURL(string, false);
            if (string2 == null) {
                string2 = sourcePathProvider.getURL(string, true);
            }
            if (string2 != null) {
                try {
                    FileObject fileObject = URLMapper.findFileObject((URL)new URL(string2));
                    if (fileObject != null) {
                        return fileObject;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
                }
            }
        }
        string = SourcePathProviderImpl.normalize(string);
        sourcePathProvider = GlobalPathRegistry.getDefault().findResource(string);
        return sourcePathProvider;
    }

    private static String getRelativePath(String string) {
        int n = string.indexOf(36);
        if (n > 0) {
            string = string.substring(0, n);
        }
        String string2 = string.replace('.', '/') + ".java";
        return string2;
    }
}

