/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.svg.form;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeleteSupport;
import org.netbeans.modules.vmd.api.model.support.ArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.sources.EventSourceCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComponentCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormCD;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGFormImageParser;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGMenuImageParser;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SVGFormSupport {
    private SVGFormSupport() {
    }

    public static final void removeAllSVGFormComponents(DesignComponent designComponent) {
        DescriptorRegistry descriptorRegistry = designComponent.getDocument().getDescriptorRegistry();
        if (!descriptorRegistry.isInHierarchy(SVGFormCD.TYPEID, designComponent.getType())) {
            throw new IllegalArgumentException("Design Component is not SVGFormCD type" + designComponent.getType());
        }
        HashSet hashSet = new HashSet(designComponent.getComponents());
        for (DesignComponent designComponent2 : hashSet) {
            if (!descriptorRegistry.isInHierarchy(SVGComponentCD.TYPEID, designComponent2.getType())) continue;
            SVGFormSupport.deleteEventSource(designComponent2);
            ArraySupport.remove((DesignComponent)designComponent, (String)"components", (DesignComponent)designComponent2);
        }
        DeleteSupport.invokeDirectUserDeletion((DesignDocument)designComponent.getDocument(), hashSet, (boolean)false);
    }

    public static final Collection<DesignComponent> getSVGFormComponents(DesignComponent designComponent) {
        DescriptorRegistry descriptorRegistry = designComponent.getDocument().getDescriptorRegistry();
        if (!descriptorRegistry.isInHierarchy(SVGFormCD.TYPEID, designComponent.getType())) {
            throw new IllegalArgumentException("Design Component is not SVGFormCD type" + designComponent.getType());
        }
        HashSet<DesignComponent> hashSet = new HashSet<DesignComponent>();
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            if (!descriptorRegistry.isInHierarchy(SVGComponentCD.TYPEID, designComponent2.getType())) continue;
            hashSet.add(designComponent2);
        }
        return hashSet;
    }

    private static void deleteEventSource(DesignComponent designComponent) {
        DesignComponent designComponent2 = designComponent.getParentComponent();
        HashSet hashSet = new HashSet(designComponent2.getComponents());
        for (DesignComponent designComponent3 : hashSet) {
            if (!designComponent2.getDocument().getDescriptorRegistry().isInHierarchy(EventSourceCD.TYPEID, designComponent3.getType()) || designComponent3.readProperty("svgButton").getComponent() != designComponent) continue;
            designComponent2.getDocument().deleteComponent(designComponent3);
        }
    }

    public static synchronized FileObject getSVGFile(DesignComponent designComponent) {
        PropertyValue propertyValue = designComponent.readProperty("resourcePath");
        if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
            return SVGFormSupport.getSVGFile(designComponent.getDocument(), MidpTypes.getString((PropertyValue)propertyValue));
        }
        return null;
    }

    public static synchronized FileObject getSVGFile(DesignDocument designDocument, String string) {
        Map map = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)designDocument, (String)string);
        Iterator iterator = map.keySet().iterator();
        FileObject fileObject = iterator.hasNext() ? (FileObject)iterator.next() : null;
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parseSVGImageItems(FileObject fileObject, DesignComponent designComponent) {
        if (fileObject == null) {
            return;
        }
        SVGComponentImageParser sVGComponentImageParser = SVGComponentImageParser.getParserByComponent(designComponent);
        if (sVGComponentImageParser == null) {
            return;
        }
        InputStream inputStream = null;
        inputStream = fileObject.getInputStream();
        if (inputStream != null) {
            DescriptorRegistry descriptorRegistry = designComponent.getDocument().getDescriptorRegistry();
            if (descriptorRegistry.isInHierarchy(SVGFormCD.TYPEID, designComponent.getType())) {
                SVGFormImageParser.parseSVGForm(inputStream, designComponent);
            } else {
                SVGMenuImageParser.parseSVGMenu(inputStream, designComponent);
            }
        }
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            Debug.warning((Object[])new Object[]{iOException});
        }
        return;
        catch (FileNotFoundException fileNotFoundException) {
            try {
                Debug.warning((Object[])new Object[]{fileNotFoundException});
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    Debug.warning((Object[])new Object[]{iOException});
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                Debug.warning((Object[])new Object[]{iOException});
            }
            return;
        }
    }
}

