/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class TagExecutor
extends ExecutorSupport {
    public static TagExecutor[] splitCommand(TagCommand tagCommand, CvsVersioningSystem cvsVersioningSystem, GlobalOptions globalOptions) {
        Command[] commandArray = new Command[]{};
        if (tagCommand.getDisplayName() == null) {
            tagCommand.setDisplayName(NbBundle.getMessage(TagExecutor.class, (String)"MSG_TagExecutor_CmdDisplayName"));
        }
        try {
            commandArray = TagExecutor.prepareBasicCommand((BasicCommand)tagCommand);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        TagExecutor[] tagExecutorArray = new TagExecutor[commandArray.length];
        for (int i = 0; i < commandArray.length; ++i) {
            Command command = commandArray[i];
            tagExecutorArray[i] = new TagExecutor(cvsVersioningSystem, (TagCommand)command, globalOptions);
        }
        return tagExecutorArray;
    }

    private TagExecutor(CvsVersioningSystem cvsVersioningSystem, TagCommand tagCommand, GlobalOptions globalOptions) {
        super(cvsVersioningSystem, (Command)tagCommand, globalOptions);
    }

    protected void commandFinished(ClientRuntime.Result result) {
        HashSet<File> hashSet = new HashSet<File>();
        for (DefaultFileInfoContainer object : this.toRefresh) {
            File file = object.getFile();
            this.cache.refreshCached(file, 0);
            hashSet.add(file.getParentFile());
        }
        this.toRefresh.clear();
        for (File file : hashSet) {
            this.cache.refreshCached(file, 0);
        }
    }
}

