/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchSettings;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BranchAction
extends AbstractSystemAction {
    private static final int enabledForStatus = 1208;

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Branch";
    }

    protected int getFileEnabledStatus() {
        return 1208;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performCvsAction(Node[] nodeArray) {
        Context context = this.getContext(nodeArray);
        if (context.getFiles().length == 0) {
            DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getBundle(BranchAction.class).getString("CTL_BranchDialogNone_Prompt"), NbBundle.getBundle(BranchAction.class).getString("CTL_BranchDialogNone_Title"), -1, 0, null, null));
            return;
        }
        String string = MessageFormat.format(NbBundle.getBundle(BranchAction.class).getString("CTL_BranchDialog_Title"), this.getContextDisplayName(nodeArray));
        JButton jButton = new JButton(NbBundle.getMessage(BranchAction.class, (String)"CTL_BranchDialog_Action_Branch"));
        jButton.setToolTipText(NbBundle.getMessage(BranchAction.class, (String)"TT_BranchDialog_Action_Branch"));
        BranchSettings branchSettings = new BranchSettings(context.getFiles());
        branchSettings.putClientProperty("OKButton", jButton);
        branchSettings.onBranchNameChange();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)branchSettings, string, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, new HelpCtx(BranchAction.class), null);
        dialogDescriptor.setClosingOptions(null);
        branchSettings.putClientProperty("org.openide.DialogDescriptor", dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BranchAction.class, (String)"ACSD_BranchDialog"));
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != jButton) {
            return;
        }
        branchSettings.saveSettings();
        RequestProcessor.getDefault().post((Runnable)new BranchExecutor(context, branchSettings, this.getRunningName(nodeArray)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BranchExecutor
    implements Runnable {
        private final Context context;
        private final BranchSettings settings;
        private final String name;

        public BranchExecutor(Context context, BranchSettings branchSettings, String string) {
            this.context = context;
            this.settings = branchSettings;
            this.name = string;
        }

        @Override
        public void run() {
            ExecutorGroup executorGroup = new ExecutorGroup(this.name);
            if (this.settings.isTaggingBase()) {
                executorGroup.addExecutors(this.tag(this.context.getFiles(), this.settings.getBaseTagName()));
                executorGroup.addBarrier(null);
            }
            executorGroup.addExecutors(this.branch(this.context.getFiles(), this.settings.getBranchName()));
            executorGroup.addBarrier(null);
            if (this.settings.isCheckingOutBranch()) {
                executorGroup.addExecutors(this.update(this.context, this.settings.getBranchName()));
            }
            executorGroup.execute();
        }

        private ExecutorSupport[] update(Context context, String string) {
            File[][] fileArray = Utils.splitFlatOthers((File[])context.getRootFiles());
            ArrayList<UpdateExecutor> arrayList = new ArrayList<UpdateExecutor>();
            arrayList.addAll(this.update(fileArray[0], string, false));
            arrayList.addAll(this.update(fileArray[1], string, true));
            return arrayList.toArray(new ExecutorSupport[arrayList.size()]);
        }

        private List<UpdateExecutor> update(File[] fileArray, String string, boolean bl) {
            if (fileArray.length == 0) {
                return Collections.emptyList();
            }
            UpdateCommand updateCommand = new UpdateCommand();
            GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
            if (this.context.getExclusions().size() > 0) {
                globalOptions.setExclusions(this.context.getExclusions().toArray(new File[this.context.getExclusions().size()]));
            }
            updateCommand.setUpdateByRevision(string);
            updateCommand.setFiles(fileArray);
            updateCommand.setRecursive(bl);
            return Arrays.asList(UpdateExecutor.splitCommand(updateCommand, CvsVersioningSystem.getInstance(), globalOptions, null));
        }

        private ExecutorSupport[] branch(File[] fileArray, String string) {
            File[][] fileArray2 = Utils.splitFlatOthers((File[])fileArray);
            ArrayList<TagExecutor> arrayList = new ArrayList<TagExecutor>();
            arrayList.addAll(this.tag(fileArray2[0], string, true, false));
            arrayList.addAll(this.tag(fileArray2[1], string, true, true));
            return arrayList.toArray(new ExecutorSupport[arrayList.size()]);
        }

        private ExecutorSupport[] tag(File[] fileArray, String string) {
            File[][] fileArray2 = Utils.splitFlatOthers((File[])fileArray);
            ArrayList<TagExecutor> arrayList = new ArrayList<TagExecutor>();
            arrayList.addAll(this.tag(fileArray2[0], string, false, false));
            arrayList.addAll(this.tag(fileArray2[1], string, false, true));
            return arrayList.toArray(new ExecutorSupport[arrayList.size()]);
        }

        private List<TagExecutor> tag(File[] fileArray, String string, boolean bl, boolean bl2) {
            if (fileArray.length == 0) {
                return Collections.emptyList();
            }
            TagCommand tagCommand = new TagCommand();
            tagCommand.setMakeBranchTag(bl);
            tagCommand.setFiles(fileArray);
            tagCommand.setTag(string);
            tagCommand.setRecursive(bl2);
            return Arrays.asList(TagExecutor.splitCommand(tagCommand, CvsVersioningSystem.getInstance(), null));
        }
    }
}

