/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.log;

import java.io.File;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateCommand;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.annotate.AnnotationBar;
import org.netbeans.modules.versioning.system.cvss.ui.actions.annotate.AnnotationBarManager;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.AnnotationsExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.LogExecutor;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class AnnotationsAction
extends AbstractSystemAction {
    protected String getBaseName(Node[] nodeArray) {
        if (this.visible(nodeArray)) {
            return "CTL_MenuItem_HideAnnotations";
        }
        return "CTL_MenuItem_Annotations";
    }

    public boolean enable(Node[] nodeArray) {
        return super.enable(nodeArray) && this.activatedEditorCookie(nodeArray) != null;
    }

    protected int getFileEnabledStatus() {
        return 4088;
    }

    protected int getDirectoryEnabledStatus() {
        return 0;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performCvsAction(Node[] nodeArray) {
        if (this.visible(nodeArray)) {
            JEditorPane jEditorPane = this.activatedEditorPane(nodeArray);
            AnnotationBarManager.hideAnnotationBar(jEditorPane);
        } else {
            EditorCookie editorCookie = this.activatedEditorCookie(nodeArray);
            if (editorCookie != null) {
                File file = this.activatedFile(nodeArray);
                CvsVersioningSystem cvsVersioningSystem = CvsVersioningSystem.getInstance();
                AdminHandler adminHandler = cvsVersioningSystem.getAdminHandler();
                JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                if (jEditorPaneArray == null) {
                    editorCookie.open();
                }
                if ((jEditorPaneArray = editorCookie.getOpenedPanes()) == null) {
                    return;
                }
                final JEditorPane jEditorPane = jEditorPaneArray[0];
                AnnotationBar annotationBar = AnnotationBarManager.showAnnotationBar(jEditorPane);
                AnnotateCommand annotateCommand = new AnnotateCommand();
                try {
                    Entry entry = adminHandler.getEntry(file);
                    if (entry == null) {
                        return;
                    }
                    String string = entry.getRevision();
                    annotateCommand.setAnnotateByRevision(string);
                    File[] fileArray = new File[]{file};
                    annotateCommand.setFiles(fileArray);
                    ExecutorGroup executorGroup = new ExecutorGroup(NbBundle.getMessage(AnnotationsAction.class, (String)"BK0001"));
                    AnnotationsExecutor annotationsExecutor = new AnnotationsExecutor(cvsVersioningSystem, annotateCommand);
                    annotationsExecutor.addLogOutputListener(annotationBar);
                    executorGroup.addExecutor(annotationsExecutor);
                    LogCommand logCommand = new LogCommand();
                    logCommand.setFiles(fileArray);
                    logCommand.setNoTags(true);
                    LogExecutor logExecutor = new LogExecutor(cvsVersioningSystem, logCommand);
                    logExecutor.addLogOutputListener(annotationBar);
                    executorGroup.addExecutor(logExecutor);
                    executorGroup.addCancellable(new Cancellable(){

                        public boolean cancel() {
                            AnnotationBarManager.hideAnnotationBar(jEditorPane);
                            return true;
                        }
                    });
                    executorGroup.execute();
                }
                catch (IOException iOException) {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)iOException, NbBundle.getMessage(AnnotationsAction.class, (String)"BK0002", (Object)file));
                    errorManager.notify((Throwable)iOException);
                }
            }
        }
    }

    public boolean visible(Node[] nodeArray) {
        JEditorPane jEditorPane = this.activatedEditorPane(nodeArray);
        return AnnotationBarManager.annotationBarVisible(jEditorPane);
    }

    private JEditorPane activatedEditorPane(Node[] nodeArray) {
        JEditorPane[] jEditorPaneArray;
        EditorCookie editorCookie = this.activatedEditorCookie(nodeArray);
        if (editorCookie != null && SwingUtilities.isEventDispatchThread() && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            return jEditorPaneArray[0];
        }
        return null;
    }

    private EditorCookie activatedEditorCookie(Node[] nodeArray) {
        if (nodeArray == null) {
            nodeArray = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        if (nodeArray.length == 1) {
            Node node = nodeArray[0];
            return (EditorCookie)node.getCookie(EditorCookie.class);
        }
        return null;
    }

    private File activatedFile(Node[] nodeArray) {
        Node node;
        DataObject dataObject;
        if (nodeArray.length == 1 && (dataObject = (DataObject)(node = nodeArray[0]).getCookie(DataObject.class)) != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return FileUtil.toFile((FileObject)fileObject);
        }
        return null;
    }

    protected String iconResource() {
        return "org/netbeans/modules/versioning/system/cvss/resources/icons/annotate.png";
    }
}

