/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.io.IOException;
import java.util.ResourceBundle;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.lib.cvsclient.command.commit.CommitInformation;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class CommitExecutor
extends ExecutorSupport {
    public static CommitExecutor[] splitCommand(CommitCommand commitCommand, CvsVersioningSystem cvsVersioningSystem, GlobalOptions globalOptions) {
        Command[] commandArray = new Command[]{};
        ResourceBundle resourceBundle = NbBundle.getBundle(CommitExecutor.class);
        if (commitCommand.getDisplayName() == null) {
            commitCommand.setDisplayName(resourceBundle.getString("MSG_CommitExecutor_CmdDisplayName"));
        }
        try {
            commandArray = CommitExecutor.prepareBasicCommand((BasicCommand)commitCommand);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        CommitExecutor[] commitExecutorArray = new CommitExecutor[commandArray.length];
        for (int i = 0; i < commandArray.length; ++i) {
            Command command = commandArray[i];
            commitExecutorArray[i] = new CommitExecutor(cvsVersioningSystem, (CommitCommand)command, globalOptions);
        }
        return commitExecutorArray;
    }

    private CommitExecutor(CvsVersioningSystem cvsVersioningSystem, CommitCommand commitCommand, GlobalOptions globalOptions) {
        super(cvsVersioningSystem, (Command)commitCommand, globalOptions);
    }

    protected void commandFinished(ClientRuntime.Result result) {
        CommitCommand commitCommand = (CommitCommand)this.cmd;
        for (CommitInformation commitInformation : this.toRefresh) {
            if (commitInformation.getFile() == null) continue;
            int n = 0;
            String string = commitInformation.getType();
            if ("Changed".equals(string) || "Added".equals(string)) {
                n = 65536;
            } else if ("Removed".equals(string) || "To-be-added".equals(string)) {
                n = 0;
            }
            this.cache.refreshCached(commitInformation.getFile(), n);
        }
        if (this.cmd.hasFailed()) {
            return;
        }
    }
}

