/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.executor;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.remove.RemoveCommand;
import org.netbeans.lib.cvsclient.command.remove.RemoveInformation;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class RemoveExecutor
extends ExecutorSupport {
    private Set refreshedFiles;

    public static RemoveExecutor[] splitCommand(RemoveCommand removeCommand, CvsVersioningSystem cvsVersioningSystem, GlobalOptions globalOptions) {
        Command[] commandArray = new Command[]{};
        if (removeCommand.getDisplayName() == null) {
            removeCommand.setDisplayName(NbBundle.getMessage(RemoveExecutor.class, (String)"MSG_RemoveExecutor_CmdDisplayName"));
        }
        try {
            commandArray = RemoveExecutor.prepareBasicCommand((BasicCommand)removeCommand);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        RemoveExecutor[] removeExecutorArray = new RemoveExecutor[commandArray.length];
        for (int i = 0; i < commandArray.length; ++i) {
            Command command = commandArray[i];
            removeExecutorArray[i] = new RemoveExecutor(cvsVersioningSystem, (RemoveCommand)command, globalOptions);
        }
        return removeExecutorArray;
    }

    private RemoveExecutor(CvsVersioningSystem cvsVersioningSystem, RemoveCommand removeCommand, GlobalOptions globalOptions) {
        super(cvsVersioningSystem, (Command)removeCommand, globalOptions);
    }

    protected void commandFinished(ClientRuntime.Result result) {
        RemoveCommand removeCommand = (RemoveCommand)this.cmd;
        this.refreshedFiles = new HashSet(this.toRefresh.size());
        for (RemoveInformation removeInformation : this.toRefresh) {
            if (removeInformation.getFile() == null) continue;
            int n = 0;
            n = removeInformation.isRemoved() ? 82 : 0;
            this.cache.refreshCached(removeInformation.getFile(), n);
            this.refreshedFiles.add(removeInformation.getFile());
        }
        if (this.cmd.hasFailed()) {
            return;
        }
        File[] fileArray = removeCommand.getFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.refreshRecursively(fileArray[i]);
        }
    }

    private void refreshRecursively(File file) {
        if (this.cvs.isIgnoredFilename(file)) {
            return;
        }
        if (this.refreshedFiles.contains(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.refreshRecursively(fileArray[i]);
            }
            this.cache.refreshCached(file, 0);
        } else {
            this.cache.refreshCached(file, 0);
        }
    }
}

