/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.executor;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.filesystems.FileUtil;

public class CheckoutExecutor
extends ExecutorSupport {
    private Set refreshedFiles;
    private Set expandedModules = new HashSet();
    private final File workingFolder;

    public CheckoutExecutor(CvsVersioningSystem cvsVersioningSystem, CheckoutCommand checkoutCommand) {
        this(cvsVersioningSystem, checkoutCommand, null, null);
    }

    public CheckoutExecutor(CvsVersioningSystem cvsVersioningSystem, CheckoutCommand checkoutCommand, GlobalOptions globalOptions, File file) {
        super(cvsVersioningSystem, (Command)checkoutCommand, globalOptions);
        this.workingFolder = file;
    }

    public Set getExpandedModules() {
        return this.expandedModules;
    }

    public final void moduleExpanded(ModuleExpansionEvent moduleExpansionEvent) {
        String string = moduleExpansionEvent.getModule();
        this.expandedModules.add(string);
    }

    protected void commandFinished(ClientRuntime.Result result) {
        CheckoutCommand checkoutCommand = (CheckoutCommand)this.cmd;
        this.refreshedFiles = new HashSet(this.toRefresh.size());
        for (DefaultFileInfoContainer defaultFileInfoContainer : this.toRefresh) {
            int n = 0;
            if ("Changed".equals(defaultFileInfoContainer.getType()) || "Added".equals(defaultFileInfoContainer.getType())) {
                n = 65536;
            } else if ("Removed".equals(defaultFileInfoContainer.getType()) || "To-be-added".equals(defaultFileInfoContainer.getType())) {
                n = 0;
            }
            File file = FileUtil.normalizeFile((File)defaultFileInfoContainer.getFile());
            this.cache.refreshCached(file, n);
            this.refreshedFiles.add(file);
        }
        File[] fileArray = checkoutCommand.getFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = FileUtil.normalizeFile((File)fileArray[i]);
            this.refreshRecursively(file);
            if (!file.isFile()) continue;
            this.cache.refreshCached(file.getParentFile(), 0);
        }
    }

    private void refreshRecursively(File file) {
        if (this.cvs.isIgnoredFilename(file)) {
            return;
        }
        if (this.refreshedFiles.contains(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.refreshRecursively(fileArray[i]);
            }
            this.cache.refreshCached(file, 0);
        } else if (this.cache.getStatus(file.getParentFile()).getStatus() != 8) {
            this.cache.refreshCached(file, 0);
        }
    }
}

