/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewJ2SEPlatform
extends J2SEPlatformImpl
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(NewJ2SEPlatform.class.getName());
    private static Set<String> propertiesToFix = new HashSet<String>();
    private boolean valid;

    public static NewJ2SEPlatform create(FileObject fileObject) throws IOException {
        assert (fileObject != null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        return new NewJ2SEPlatform(null, Collections.singletonList(fileObject.getURL()), hashMap, Collections.<String, String>emptyMap());
    }

    private NewJ2SEPlatform(String string, List<URL> list, Map<String, String> map, Map<String, String> map2) {
        super(string, string, list, map, map2, null, null);
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void run() {
        try {
            FileObject fileObject = this.findTool("java");
            if (fileObject == null) {
                return;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null) {
                return;
            }
            String string = file.getAbsolutePath();
            String string2 = File.createTempFile("nb-platformdetect", "properties").getAbsolutePath();
            String string3 = this.getSDKProperties(string, string2);
            File file2 = new File(string2);
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(file2);
            properties.load(fileInputStream);
            HashMap<String, String> hashMap = new HashMap<String, String>(properties.size());
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = properties.getProperty(string4);
                if ("java.class.path".equals(string4)) {
                    string5 = NewJ2SEPlatform.filterProbe(string5, string3);
                } else if ("user.dir".equals(string4)) {
                    string5 = "";
                }
                string5 = this.fixSymLinks(string4, string5);
                hashMap.put(string4, string5);
            }
            this.setSystemProperties(hashMap);
            this.valid = true;
            ((InputStream)fileInputStream).close();
            file2.delete();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "Cannot execute probe process", iOException);
            this.valid = false;
        }
    }

    private String fixSymLinks(String string, String string2) {
        if (Utilities.isUnix() && propertiesToFix.contains(string)) {
            try {
                String[] stringArray = string2.split(File.pathSeparator);
                boolean bl = false;
                Object object = this.getInstallFolders().iterator();
                while (object.hasNext()) {
                    String string3;
                    String string4;
                    File file = FileUtil.toFile((FileObject)object.next());
                    if (file == null || (string4 = file.getAbsolutePath()).equals(string3 = file.getCanonicalPath())) continue;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!stringArray[i].startsWith(string3)) continue;
                        stringArray[i] = string4 + stringArray[i].substring(string3.length());
                        bl = true;
                    }
                }
                if (bl) {
                    object = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i > 0) {
                            ((StringBuffer)object).append(File.pathSeparatorChar);
                        }
                        ((StringBuffer)object).append(stringArray[i]);
                    }
                    return ((StringBuffer)object).toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    private String getSDKProperties(String string, String string2) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        try {
            String[] stringArray = new String[]{string, "-classpath", InstalledFileLocator.getDefault().locate("modules/ext/org-netbeans-modules-java-j2seplatform-probe.jar", "org.netbeans.modules.java.j2seplatform", false).getAbsolutePath(), "org.netbeans.modules.java.j2seplatform.wizard.SDKProbe", string2};
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Executing: %s %s %s %s %s", stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4]));
            }
            Process process = runtime.exec(stringArray);
            process.waitFor();
            int n = process.exitValue();
            if (n != 0) {
                throw new IOException();
            }
            return stringArray[2];
        }
        catch (InterruptedException interruptedException) {
            IOException iOException = new IOException();
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)interruptedException);
            throw iOException;
        }
    }

    static {
        propertiesToFix.add("sun.boot.class.path");
        propertiesToFix.add("sun.boot.library.path");
        propertiesToFix.add("java.library.path");
        propertiesToFix.add("java.ext.dirs");
        propertiesToFix.add("java.home");
    }
}

