/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.ProjectManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;

public class J2SEPlatformModule
extends ModuleInstall {
    private static final String DEFAULT_PLATFORM = "Services/Platforms/org-netbeans-api-java-Platform/default_platform.xml";

    public void restored() {
        super.restored();
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                J2SEPlatformModule.recoverDefaultPlatform();
            }
        });
    }

    private static void recoverDefaultPlatform() {
        FileObject fileObject = FileUtil.getConfigFile((String)DEFAULT_PLATFORM);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                boolean bl = false;
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                if (instanceCookie != null) {
                    try {
                        instanceCookie.instanceCreate();
                        bl = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    Logger.getLogger("global").log(Level.WARNING, "default_platform.xml is broken, regenerating.");
                    Object object = fileObject.getAttribute("removeWritables");
                    if (object instanceof Callable) {
                        ((Callable)object).call();
                    }
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        } else {
            Logger.getLogger("global").log(Level.WARNING, "The default platform is hidden.");
        }
    }
}

