/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.admin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class Entry {
    public static final String DUMMY_TIMESTAMP = "dummy timestamp";
    public static final String DUMMY_TIMESTAMP_NEW_ENTRY = "dummy timestamp from new-entry";
    public static final String MERGE_TIMESTAMP = "Result of merge";
    private static final String TAG = "T";
    private static final String DATE = "D";
    private static SimpleDateFormat stickyDateFormatter;
    private static final String BINARY_FILE = "-kb";
    private static final String NO_USER_FILE = "";
    private static final String NEW_USER_FILE = "0";
    private static final String REMOVE_USER_FILE = "-";
    public static final char HAD_CONFLICTS = '+';
    public static final char TIMESTAMP_MATCHES_FILE = '=';
    public static final String HAD_CONFLICTS_AND_TIMESTAMP_MATCHES_FILE = "+=";
    private static final String DIRECTORY_PREFIX = "D/";
    private String name;
    private String revision;
    private String conflict;
    private Date lastModified;
    private String options;
    private String tag;
    private Date date;
    private boolean directory;

    private static SimpleDateFormat getStickyDateFormatter() {
        if (stickyDateFormatter == null) {
            stickyDateFormatter = new SimpleDateFormat("yyyy.MM.dd.hh.mm.ss");
        }
        return stickyDateFormatter;
    }

    public static SimpleDateFormat getLastModifiedDateFormatter() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
        simpleDateFormat.setTimeZone(Entry.getTimeZone());
        return simpleDateFormat;
    }

    public static TimeZone getTimeZone() {
        return TimeZone.getTimeZone("GMT");
    }

    public Entry(String string) {
        this.init(string);
    }

    public Entry() {
    }

    protected void init(String string) {
        if (string.startsWith(DIRECTORY_PREFIX)) {
            this.directory = true;
            string = string.substring(1);
        }
        int[] nArray = new int[5];
        try {
            nArray[0] = 0;
            for (int i = 1; i < 5; ++i) {
                nArray[i] = string.indexOf(47, nArray[i - 1] + 1);
            }
            if (nArray[1] > 0) {
                this.name = string.substring(nArray[0] + 1, nArray[1]);
                this.revision = string.substring(nArray[1] + 1, nArray[2]);
                if (nArray[3] - nArray[2] > 1) {
                    String string2 = string.substring(nArray[2] + 1, nArray[3]);
                    this.setConflict(string2);
                }
                if (nArray[4] - nArray[3] > 1) {
                    this.options = string.substring(nArray[3] + 1, nArray[4]);
                }
                if (nArray[4] != string.length() - 1) {
                    String string3 = string.substring(nArray[4] + 1);
                    if (string3.startsWith(TAG)) {
                        this.setTag(string3.substring(1));
                    } else if (string3.startsWith(DATE)) {
                        try {
                            String string4 = string3.substring(DATE.length());
                            Date date = Entry.getStickyDateFormatter().parse(string4);
                            this.setDate(date);
                        }
                        catch (ParseException parseException) {
                            System.err.println("We got another inconsistency in the library's date formatting.");
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error parsing entry line: " + exception);
            exception.printStackTrace();
            throw new IllegalArgumentException("Invalid entry line: " + string);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getConflict() {
        return this.conflict;
    }

    public void setConflict(String string) {
        this.conflict = string;
        this.lastModified = null;
        if (string == null || string.equals(DUMMY_TIMESTAMP) || string.equals(MERGE_TIMESTAMP) || string.equals(DUMMY_TIMESTAMP_NEW_ENTRY)) {
            return;
        }
        String string2 = string;
        int n = string2.indexOf(43);
        if (n >= 0) {
            int n2 = string2.indexOf(61);
            n = Math.max(n, n2);
        }
        if (n >= 0) {
            string2 = string2.substring(n + 1);
        }
        if (string2.length() == 0) {
            return;
        }
        try {
            this.lastModified = Entry.getLastModifiedDateFormatter().parse(string2);
        }
        catch (Exception exception) {
            this.lastModified = null;
        }
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String string) {
        this.options = string;
    }

    public String getStickyInformation() {
        if (this.tag != null) {
            return this.tag;
        }
        return this.getDateFormatted();
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
        this.date = null;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDateFormatted() {
        if (this.getDate() == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = Entry.getStickyDateFormatter();
        String string = simpleDateFormat.format(this.getDate());
        return string;
    }

    public void setDate(Date date) {
        this.date = date;
        this.tag = null;
    }

    public boolean hasDate() {
        return this.date != null;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public boolean isBinary() {
        return this.options != null && this.options.equals(BINARY_FILE);
    }

    public boolean isNoUserFile() {
        return this.revision == null || this.revision.equals(NO_USER_FILE);
    }

    public boolean isNewUserFile() {
        return this.revision != null && this.revision.startsWith(NEW_USER_FILE) && this.revision.indexOf(".") < 0;
    }

    public boolean isUserFileToBeRemoved() {
        return this.revision != null && this.revision.startsWith(REMOVE_USER_FILE);
    }

    public boolean isValid() {
        return this.getName() != null && this.getName().length() > 0;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean bl) {
        this.directory = bl;
    }

    public boolean hadConflicts() {
        if (this.conflict != null) {
            return this.conflict.indexOf(43) >= 0;
        }
        return false;
    }

    public boolean timestampMatchesFile() {
        return this.conflict.charAt(1) == '=';
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.directory) {
            stringBuffer.append(DIRECTORY_PREFIX);
        } else {
            stringBuffer.append('/');
        }
        if (this.name != null) {
            stringBuffer.append(this.name);
            stringBuffer.append('/');
            if (this.revision != null) {
                stringBuffer.append(this.revision);
            }
            stringBuffer.append('/');
            if (this.conflict != null) {
                stringBuffer.append(this.conflict);
            }
            stringBuffer.append('/');
            if (this.options != null) {
                stringBuffer.append(this.options);
            }
            stringBuffer.append('/');
            if (this.tag != null && this.date == null) {
                if (!"HEAD".equals(this.tag)) {
                    stringBuffer.append(TAG);
                    stringBuffer.append(this.getTag());
                }
            } else if (this.tag == null && this.date != null) {
                String string = this.getDateFormatted();
                stringBuffer.append(DATE);
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }
}

