/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.model.ui;

import com.sun.xml.ws.runtime.config.MetroConfig;
import com.sun.xml.ws.runtime.config.ObjectFactory;
import com.sun.xml.ws.runtime.config.TubeFactoryConfig;
import com.sun.xml.ws.runtime.config.TubeFactoryList;
import com.sun.xml.ws.runtime.config.TubelineDefinition;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.jaxwsruntimemodel.JavaWsdlMapper;
import org.netbeans.modules.websvc.metro.model.MetroConfigLoader;
import org.netbeans.modules.websvc.metro.model.ui.TubesConfigPanel;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class TubesEditor
implements WSEditor {
    private static final Logger logger = Logger.getLogger(TubesEditor.class.getName());
    private JAXWSLightSupport jaxWsSupport;
    private JaxWsService jaxWsService;
    private Project project;
    private ObjectFactory objFactory = new ObjectFactory();
    private String ref = null;
    private MetroConfigLoader cfgLoader = new MetroConfigLoader();
    private MetroConfig cfg = null;
    private List<TubeFactoryConfig> cfgList = null;
    private TubesConfigPanel panel = null;
    private boolean isClient = false;

    public TubesEditor(Project project) {
        this.project = project;
    }

    public TubesEditor(JAXWSLightSupport jAXWSLightSupport, JaxWsService jaxWsService, Project project) {
        this.project = project;
        this.jaxWsService = jaxWsService;
        this.jaxWsSupport = jAXWSLightSupport;
    }

    public String getTitle() {
        return NbBundle.getMessage(TubesEditor.class, (String)"TUBES_EDITOR_TITLE");
    }

    public JComponent createWSEditorComponent(Node node) {
        if (this.project == null) {
            return new JPanel();
        }
        if (this.jaxWsService == null) {
            Client client = (Client)node.getLookup().lookup(Client.class);
            Service service = (Service)node.getLookup().lookup(Service.class);
            boolean bl = this.isClient = client != null;
            if (this.isClient) {
                JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.project.getProjectDirectory());
                if (jAXWSClientSupport != null) {
                    FileObject fileObject = jAXWSClientSupport.getLocalWsdlFolderForClient(client.getName(), false);
                    FileObject fileObject2 = fileObject != null ? fileObject.getFileObject(client.getLocalWsdlFile()) : null;
                    this.ref = this.getServiceRef(TubesEditor.getModelFromFO(fileObject2, false));
                    this.cfg = this.cfgLoader.loadMetroConfig(this.project);
                    if (this.cfg == null) {
                        this.cfg = this.cfgLoader.loadDefaultMetroConfig(this.project);
                        if (this.cfg == null) {
                            this.cfg = this.cfgLoader.createFreshMetroConfig();
                        }
                    }
                    boolean bl2 = this.cfgLoader.getTubeline(this.cfg, this.ref) != null;
                    TubelineDefinition tubelineDefinition = this.cfgLoader.createTubeline(this.cfg, this.ref, client.getName() + "Tubeline");
                    TubeFactoryList tubeFactoryList = tubelineDefinition.getClientSide();
                    if (tubeFactoryList == null) {
                        tubeFactoryList = this.objFactory.createTubeFactoryList();
                        tubelineDefinition.setClientSide(tubeFactoryList);
                    }
                    this.cfgList = tubeFactoryList.getTubeFactoryConfigs();
                    try {
                        this.panel = new TubesConfigPanel(this.project, tubeFactoryList, true, bl2);
                        return this.panel;
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, null, exception);
                    }
                }
            } else if (service != null) {
                Object object;
                Object object2;
                Object object3;
                FileObject fileObject;
                JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
                String string = service.getServiceName();
                if (jAXWSSupport.isFromWSDL(service.getName())) {
                    fileObject = jAXWSSupport.getLocalWsdlFolderForService(service.getName(), false);
                    object3 = fileObject != null ? fileObject.getFileObject(service.getLocalWsdlFile()) : null;
                    object2 = TubesEditor.getModelFromFO((FileObject)object3, false);
                    object = object2.getDefinitions().getTargetNamespace();
                    String string2 = service.getPortName();
                    this.ref = (String)object + "#(" + string + "/" + string2 + ")";
                } else {
                    fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
                    object3 = JavaWsdlMapper.getNamespace((String)JavaWsdlMapper.getPackageFromClass((String)service.getImplementationClass()));
                    object2 = JavaWsdlMapper.getPortName((FileObject)fileObject, (String)object3);
                    object = JavaWsdlMapper.getServiceName((FileObject)fileObject);
                    string = ((QName)object).getLocalPart();
                    this.ref = (String)object3 + "#(" + string + "/" + ((QName)object2).getLocalPart() + ")";
                }
                this.cfg = this.cfgLoader.loadMetroConfig(this.project);
                if (this.cfg == null) {
                    this.cfg = this.cfgLoader.loadDefaultMetroConfig(this.project);
                    if (this.cfg == null) {
                        this.cfg = this.cfgLoader.createFreshMetroConfig();
                    }
                }
                boolean bl3 = this.cfgLoader.getTubeline(this.cfg, this.ref) != null;
                object3 = this.cfgLoader.createTubeline(this.cfg, this.ref, string + "Tubeline");
                object2 = ((TubelineDefinition)object3).getEndpointSide();
                if (object2 == null) {
                    object2 = this.objFactory.createTubeFactoryList();
                    ((TubelineDefinition)object3).setEndpointSide((TubeFactoryList)object2);
                }
                this.cfgList = ((TubeFactoryList)object2).getTubeFactoryConfigs();
                try {
                    this.panel = new TubesConfigPanel(this.project, (TubeFactoryList)object2, false, bl3);
                    return this.panel;
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, null, exception);
                }
            }
        } else if (!this.jaxWsService.isServiceProvider()) {
            Object object;
            FileObject fileObject = this.jaxWsSupport.getWsdlFolder(false);
            FileObject fileObject3 = fileObject != null ? fileObject.getFileObject(this.jaxWsService.getLocalWsdl()) : null;
            WSDLModel wSDLModel = TubesEditor.getModelFromFO(fileObject3, false);
            this.ref = this.getServiceRef(wSDLModel);
            String string = null;
            Collection collection = wSDLModel.getDefinitions().getServices();
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                object = (org.netbeans.modules.xml.wsdl.model.Service)iterator.next();
                string = object.getName();
            }
            this.cfg = this.cfgLoader.loadMetroConfig(this.project);
            if (this.cfg == null) {
                this.cfg = this.cfgLoader.loadDefaultMetroConfig(this.project);
                if (this.cfg == null) {
                    this.cfg = this.cfgLoader.createFreshMetroConfig();
                }
            }
            boolean bl = this.cfgLoader.getTubeline(this.cfg, this.ref) != null;
            object = this.cfgLoader.createTubeline(this.cfg, this.ref, string + "Tubeline");
            TubeFactoryList tubeFactoryList = ((TubelineDefinition)object).getClientSide();
            if (tubeFactoryList == null) {
                tubeFactoryList = this.objFactory.createTubeFactoryList();
                ((TubelineDefinition)object).setClientSide(tubeFactoryList);
            }
            this.cfgList = tubeFactoryList.getTubeFactoryConfigs();
            try {
                this.panel = new TubesConfigPanel(this.project, tubeFactoryList, true, bl);
                return this.panel;
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, null, exception);
            }
        } else {
            Object object;
            Object object4;
            Object object5;
            FileObject fileObject;
            String string = this.jaxWsService.getServiceName();
            if (this.jaxWsService.getLocalWsdl() != null) {
                fileObject = this.jaxWsSupport.getWsdlFolder(false);
                object5 = fileObject != null ? fileObject.getFileObject(this.jaxWsService.getLocalWsdl()) : null;
                object4 = TubesEditor.getModelFromFO((FileObject)object5, false);
                object = object4.getDefinitions().getTargetNamespace();
                String string3 = this.jaxWsService.getPortName();
                this.ref = (String)object + "#(" + string + "/" + string3 + ")";
            } else {
                fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
                object5 = JavaWsdlMapper.getNamespace((String)JavaWsdlMapper.getPackageFromClass((String)this.jaxWsService.getImplementationClass()));
                object4 = JavaWsdlMapper.getPortName((FileObject)fileObject, (String)object5);
                object = JavaWsdlMapper.getServiceName((FileObject)fileObject);
                string = ((QName)object).getLocalPart();
                this.ref = (String)object5 + "#(" + string + "/" + ((QName)object4).getLocalPart() + ")";
            }
            this.cfg = this.cfgLoader.loadMetroConfig(this.project);
            if (this.cfg == null) {
                this.cfg = this.cfgLoader.loadDefaultMetroConfig(this.project);
                if (this.cfg == null) {
                    this.cfg = this.cfgLoader.createFreshMetroConfig();
                }
            }
            boolean bl = this.cfgLoader.getTubeline(this.cfg, this.ref) != null;
            object5 = this.cfgLoader.createTubeline(this.cfg, this.ref, string + "Tubeline");
            object4 = ((TubelineDefinition)object5).getEndpointSide();
            if (object4 == null) {
                object4 = this.objFactory.createTubeFactoryList();
                ((TubelineDefinition)object5).setEndpointSide((TubeFactoryList)object4);
            }
            this.cfgList = ((TubeFactoryList)object4).getTubeFactoryConfigs();
            try {
                this.panel = new TubesConfigPanel(this.project, (TubeFactoryList)object4, false, bl);
                return this.panel;
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, null, exception);
            }
        }
        return new JPanel();
    }

    private String getServiceRef(WSDLModel wSDLModel) {
        Definitions definitions = wSDLModel.getDefinitions();
        String string = definitions.getTargetNamespace();
        String string2 = null;
        String string3 = null;
        Collection collection = definitions.getServices();
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            org.netbeans.modules.xml.wsdl.model.Service service = (org.netbeans.modules.xml.wsdl.model.Service)iterator.next();
            string2 = service.getName();
            Collection collection2 = service.getPorts();
            Iterator iterator2 = collection2.iterator();
            if (iterator2.hasNext()) {
                Port port = (Port)iterator2.next();
                string3 = port.getName();
            }
        }
        return string + "#(" + string2 + "/" + string3 + ")";
    }

    private static WSDLModel getModelFromFO(FileObject fileObject, boolean bl) {
        WSDLModel wSDLModel = null;
        ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)bl);
        try {
            wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
            if (wSDLModel != null) {
                wSDLModel.sync();
            }
        }
        catch (Exception exception) {
            logger.log(Level.INFO, null, exception);
        }
        return wSDLModel;
    }

    public void save(Node node) {
        if (node == null) {
            return;
        }
        try {
            if (this.panel != null && this.panel.isChanged()) {
                if (this.panel.isOverride()) {
                    this.cfgList.clear();
                    this.cfgList.addAll(this.cfgLoader.createTubeFactoryConfigList(this.panel.getTubeList()));
                } else {
                    this.cfgLoader.removeTubelineReference(this.cfg, this.ref);
                }
                this.cfgLoader.saveMetroConfig(this.cfg, this.project);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, null, exception);
        }
    }

    public void cancel(Node node) {
    }

    public String getDescription() {
        return NbBundle.getMessage(TubesEditor.class, (String)"TUBES_CONFIG_DESC");
    }
}

