/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.api;

import java.util.Collection;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.web.client.tools.api.DebugProjectPanel;
import org.netbeans.modules.web.client.tools.api.Log;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class WebClientToolsProjectUtils {
    static final String DIALOG_DISPLAY_CONFIG = "dialogShowDebugPanel";
    static final String CLIENT_DEBUG_PROP = "clientdebug";
    static final String SERVER_DEBUG_PROP = "serverdebug";
    private static final boolean CLIENT_DEBUG_DEFAULT = false;
    private static final boolean SERVER_DEBUG_DEFAULT = true;
    static final Browser BROWSER_DEFAULT = Browser.FIREFOX;

    public static boolean showDebugDialog(Project project) {
        Preferences preferences = WebClientToolsProjectUtils.getPreferencesForProject(project);
        boolean bl = preferences.getBoolean(DIALOG_DISPLAY_CONFIG, true);
        boolean bl2 = WebClientToolsProjectUtils.getServerDebugProperty(project);
        if (!bl || !bl2) {
            return true;
        }
        String string = ProjectUtils.getInformation((Project)project).getDisplayName();
        String string2 = NbBundle.getMessage(WebClientToolsProjectUtils.class, (String)"DebugProjectPanel_DialogTitle", (Object)string);
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(WebClientToolsProjectUtils.class, (String)"DebugProjectPanel_OkButton"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClientToolsProjectUtils.class, (String)"DebugProjectPanel_OkButton.accessibleDescription"));
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        DebugProjectPanel debugProjectPanel = new DebugProjectPanel(project);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)debugProjectPanel, string2, true, objectArray, (Object)jButton, 0, null, debugProjectPanel.getPanelCloseHandler(jButton));
        dialogDescriptor.setClosingOptions(null);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == jButton;
    }

    public static Browser getDefaultBrowser() {
        if (WebClientToolsProjectUtils.isFirefoxSupported()) {
            return Browser.FIREFOX;
        }
        if (WebClientToolsProjectUtils.isInternetExplorerSupported()) {
            return Browser.INTERNET_EXPLORER;
        }
        return BROWSER_DEFAULT;
    }

    public static boolean getClientDebugDefault() {
        return false;
    }

    public static boolean getServerDebugDefault() {
        return true;
    }

    public static HtmlBrowser.Factory getFirefoxBrowser() {
        return WebClientToolsProjectUtils.findBrowser("org.netbeans.modules.extbrowser.FirefoxBrowser");
    }

    public static HtmlBrowser.Factory getInternetExplorerBrowser() {
        return WebClientToolsProjectUtils.findBrowser("org.netbeans.modules.extbrowser.IExplorerBrowser");
    }

    public static boolean getClientDebugProperty(Project project) {
        return WebClientToolsProjectUtils.getProjectProperty(project, CLIENT_DEBUG_PROP, WebClientToolsProjectUtils.getClientDebugDefault());
    }

    public static boolean getServerDebugProperty(Project project) {
        if (WebClientToolsProjectUtils.supportedBrowsersAvailable()) {
            return WebClientToolsProjectUtils.getProjectProperty(project, SERVER_DEBUG_PROP, true);
        }
        return true;
    }

    public static boolean isDebugPropertySet(Project project) {
        return WebClientToolsProjectUtils.isPropertySet(project, CLIENT_DEBUG_PROP);
    }

    static boolean isPropertySet(Project project, String string) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, WebClientToolsProjectUtils.class, (boolean)false);
        assert (preferences != null);
        return preferences.get(string, null) != null;
    }

    static Preferences getPreferencesForProject(Project project) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, WebClientToolsProjectUtils.class, (boolean)false);
        assert (preferences != null);
        return preferences;
    }

    public static boolean isFirefox(Project project) {
        return WebClientToolsProjectUtils.getProjectProperty(project, Browser.FIREFOX.name(), WebClientToolsProjectUtils.getDefaultBrowser() == Browser.FIREFOX);
    }

    public static boolean isInternetExplorer(Project project) {
        return WebClientToolsProjectUtils.getProjectProperty(project, Browser.INTERNET_EXPLORER.name(), WebClientToolsProjectUtils.getDefaultBrowser() == Browser.INTERNET_EXPLORER);
    }

    private static boolean getProjectProperty(Project project, String string, boolean bl) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, WebClientToolsProjectUtils.class, (boolean)false);
        assert (preferences != null);
        return preferences.getBoolean(string, bl);
    }

    public static void setProjectProperties(final Project project, final boolean bl, final boolean bl2, final Browser browser) {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws BackingStoreException {
                    Preferences preferences = ProjectUtils.getPreferences((Project)project, WebClientToolsProjectUtils.class, (boolean)false);
                    assert (preferences != null);
                    boolean bl3 = browser == Browser.FIREFOX;
                    boolean bl22 = browser == Browser.INTERNET_EXPLORER;
                    preferences.putBoolean(WebClientToolsProjectUtils.SERVER_DEBUG_PROP, bl);
                    preferences.putBoolean(WebClientToolsProjectUtils.CLIENT_DEBUG_PROP, bl2);
                    preferences.putBoolean(Browser.FIREFOX.name(), bl3);
                    preferences.putBoolean(Browser.INTERNET_EXPLORER.name(), bl22);
                    preferences.sync();
                    return Boolean.TRUE;
                }
            });
        }
        catch (MutexException mutexException) {
            Log.getLogger().log(Level.SEVERE, "Unable to set javascript debugger project properties", mutexException);
        }
    }

    private static HtmlBrowser.Factory findBrowser(String string) {
        Collection collection = Lookup.getDefault().lookupAll(HtmlBrowser.Factory.class);
        for (HtmlBrowser.Factory factory : collection) {
            if (!factory.getClass().getName().equals(string)) continue;
            return factory;
        }
        return null;
    }

    public static boolean isFirefoxSupported() {
        return WebClientToolsProjectUtils.getFirefoxBrowser() != null;
    }

    public static boolean isInternetExplorerSupported() {
        return Utilities.isWindows() && WebClientToolsProjectUtils.getInternetExplorerBrowser() != null;
    }

    public static boolean supportedBrowsersAvailable() {
        return WebClientToolsProjectUtils.isInternetExplorerSupported() || WebClientToolsProjectUtils.isFirefoxSupported();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Browser {
        FIREFOX,
        INTERNET_EXPLORER;

    }
}

