/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Insets;
import java.io.IOException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.Keymap;
import org.netbeans.modules.openide.loaders.AWTTask;
import org.netbeans.modules.openide.loaders.DataObjectAccessor;
import org.openide.awt.Actions;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.actions.Presenter;

public class Toolbar
extends JToolBar {
    @Deprecated
    public static final int BASIC_HEIGHT = 34;
    static final Logger LOG = Logger.getLogger(Toolbar.class.getName());
    private String displayName;
    private DataFolder backingFolder;
    private Folder processor;
    private static final boolean isMetalLaF = MetalLookAndFeel.class.isAssignableFrom(UIManager.getLookAndFeel().getClass());
    private static final boolean isJdk15;
    private static final boolean isJdk16;
    static final long serialVersionUID = 5011742660516204764L;
    private JButton label;
    private static final Insets emptyInsets;

    public Toolbar() {
        this("");
    }

    public Toolbar(String string) {
        this(string, string, false);
    }

    public Toolbar(String string, String string2) {
        this(string, string2, false);
    }

    public Toolbar(String string, boolean bl) {
        this(string, string, bl);
    }

    Toolbar(DataFolder dataFolder) {
        this.backingFolder = dataFolder;
        this.initAll(dataFolder.getName(), false);
        this.putClientProperty("folder", dataFolder);
    }

    DataFolder getFolder() {
        return this.backingFolder;
    }

    final Folder waitFinished() {
        if (this.backingFolder == null) {
            return null;
        }
        if (this.processor == null && this.isVisible()) {
            this.processor = new Folder();
        }
        return this.processor;
    }

    public void addNotify() {
        super.addNotify();
        this.waitFinished();
    }

    public Component[] getComponents() {
        this.waitFinished();
        return super.getComponents();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.waitFinished();
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof AbstractButton) {
            component.setFocusable(false);
            ((JComponent)component).setOpaque(false);
            if (isMetalLaF && (isJdk15 || isJdk16)) {
                ((AbstractButton)component).setBorderPainted(false);
                ((AbstractButton)component).setOpaque(false);
            }
            if (isJdk16 && !isMetalLaF) {
                ((AbstractButton)component).setMargin(emptyInsets);
            }
            if (null != this.label && component != this.label) {
                this.remove(this.label);
                this.label = null;
            }
        } else if (component instanceof JToolBar.Separator) {
            JToolBar.Separator separator = (JToolBar.Separator)component;
            if (this.getOrientation() == 1) {
                separator.setOrientation(0);
            } else {
                separator.setOrientation(1);
            }
        }
        super.addImpl(component, object, n);
    }

    public Toolbar(String string, String string2, boolean bl) {
        this.setDisplayName(string2);
        this.initAll(string, bl);
    }

    @Deprecated
    public static int getBasicHeight() {
        return ToolbarPool.getDefault().getPreferredIconSize();
    }

    private void initAll(String string, boolean bl) {
        this.setName(string);
        this.setFloatable(bl);
        this.getAccessibleContext().setAccessibleName(this.displayName == null ? this.getName() : this.displayName);
        this.getAccessibleContext().setAccessibleDescription(this.getName());
    }

    public String getUIClassID() {
        if (UIManager.get("Nb.Toolbar.ui") != null) {
            return "Nb.Toolbar.ui";
        }
        return super.getUIClassID();
    }

    @Deprecated
    public static int rowCount(int n) {
        return 1;
    }

    @Deprecated
    public void setDnDListener(DnDListener dnDListener) {
    }

    @Deprecated
    protected void fireDragToolbar(int n, int n2, int n3) {
    }

    @Deprecated
    protected void fireDropToolbar(int n, int n2, int n3) {
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            if (this.backingFolder.isValid()) {
                try {
                    return this.backingFolder.getNodeDelegate().getDisplayName();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return this.backingFolder.getName();
        }
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setAccelerator(Action action, FileObject fileObject) {
        KeyStroke[] keyStrokeArray;
        if (fileObject == null) {
            return;
        }
        action.putValue("definingFile", fileObject);
        try {
            assert (action.getValue("definingFile") == fileObject) : action.getClass() + " violated Action.putValue contract";
            Keymap keymap = (Keymap)Lookup.getDefault().lookup(Keymap.class);
            KeyStroke[] keyStrokeArray2 = keyStrokeArray = keymap != null ? keymap.getKeyStrokesForAction(action) : new KeyStroke[]{};
            assert (keyStrokeArray != null) : keymap;
            Object var5_4 = null;
            action.putValue("definingFile", null);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            action.putValue("definingFile", null);
            throw throwable;
        }
        if (keyStrokeArray.length > 0) {
            action.putValue("AcceleratorKey", keyStrokeArray[0]);
        }
    }

    public void setUI(ToolBarUI toolBarUI) {
        super.setUI(toolBarUI);
        if (null != this.backingFolder && null != this.processor) {
            this.processor.recreate();
        }
    }

    static {
        String string = System.getProperty("java.version");
        isJdk15 = string.startsWith("1.5");
        isJdk16 = string.startsWith("1.6");
        emptyInsets = new Insets(1, 1, 1, 1);
    }

    private static class DefaultIconButton
    extends JButton {
        private Icon unknownIcon;

        private DefaultIconButton() {
        }

        public Icon getIcon() {
            Icon icon = super.getIcon();
            if (null == icon && (null == this.getText() || this.getText().length() == 0)) {
                if (this.unknownIcon == null) {
                    this.unknownIcon = ImageUtilities.loadImageIcon((String)"org/openide/loaders/unknown.gif", (boolean)false);
                }
                icon = this.unknownIcon;
            }
            return icon;
        }
    }

    @Deprecated
    public static class DnDEvent
    extends EventObject {
        public static final int DND_ONE = 1;
        public static final int DND_END = 2;
        public static final int DND_LINE = 3;
        private String name;
        private int dx;
        private int dy;
        private int type;
        static final long serialVersionUID = 4389530973297716699L;

        public DnDEvent(Toolbar toolbar, String string, int n, int n2, int n3) {
            super(toolbar);
            this.name = string;
            this.dx = n;
            this.dy = n2;
            this.type = n3;
        }

        public String getName() {
            return this.name;
        }

        public int getDX() {
            return this.dx;
        }

        public int getDY() {
            return this.dy;
        }

        public int getType() {
            return this.type;
        }
    }

    @Deprecated
    public static interface DnDListener
    extends EventListener {
        public void dragToolbar(DnDEvent var1);

        public void dropToolbar(DnDEvent var1);
    }

    final class Folder
    extends FolderInstance {
        private Map<Object, DataObject> cookiesToObjects;

        public Folder() {
            super(Toolbar.this.backingFolder);
            this.cookiesToObjects = new HashMap<Object, DataObject>();
            DataObjectAccessor.DEFAULT.precreateInstances(this);
            this.recreate();
        }

        public String instanceName() {
            return Toolbar.this.getClass().getName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return Toolbar.this.getClass();
        }

        protected Object instanceForCookie(DataObject dataObject, InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Object object = super.instanceForCookie(dataObject, instanceCookie);
            this.cookiesToObjects.put(object, dataObject);
            return object;
        }

        protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Class clazz;
            InstanceCookie.Of of;
            boolean bl = instanceCookie instanceof InstanceCookie.Of ? (of = (InstanceCookie.Of)instanceCookie).instanceOf(Component.class) || of.instanceOf(Presenter.Toolbar.class) || of.instanceOf(Action.class) : Component.class.isAssignableFrom(clazz = instanceCookie.instanceClass()) || Presenter.Toolbar.class.isAssignableFrom(clazz) || Action.class.isAssignableFrom(clazz);
            return bl ? instanceCookie : null;
        }

        protected InstanceCookie acceptFolder(DataFolder dataFolder) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            Toolbar.this.removeAll();
            for (int i = 0; i < instanceCookieArray.length; ++i) {
                Object var8_9;
                block16: {
                    try {
                        try {
                            Object object = instanceCookieArray[i].instanceCreate();
                            DataObject dataObject = this.cookiesToObjects.get(object);
                            if (object instanceof Presenter.Toolbar) {
                                if (object instanceof Action && dataObject != null) {
                                    Toolbar.setAccelerator((Action)object, dataObject.getPrimaryFile());
                                }
                                object = ((Presenter.Toolbar)object).getToolbarPresenter();
                            }
                            if (object instanceof Component) {
                                if (object instanceof JComponent && "Fixed".equals(((JComponent)object).getClientProperty("Toolbar"))) {
                                    Toolbar.this.removeAll();
                                    Toolbar.this.setBorder(null);
                                }
                                if (object instanceof JComponent) {
                                    if (ToolbarPool.getDefault().getPreferredIconSize() == 24) {
                                        ((JComponent)object).putClientProperty("PreferredIconSize", new Integer(24));
                                    }
                                    ((JComponent)object).putClientProperty("file", dataObject);
                                }
                                Toolbar.this.add((Component)object);
                                var8_9 = null;
                                this.cookiesToObjects.clear();
                                continue;
                            }
                            if (!(object instanceof Action)) break block16;
                            Action action = (Action)object;
                            DefaultIconButton defaultIconButton = new DefaultIconButton();
                            if (ToolbarPool.getDefault().getPreferredIconSize() == 24) {
                                defaultIconButton.putClientProperty("PreferredIconSize", new Integer(24));
                            }
                            if (null == action.getValue("SmallIcon") && (null == action.getValue("Name") || action.getValue("Name").toString().length() == 0)) {
                                action.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/openide/loaders/unknown.gif", (boolean)false));
                            }
                            Actions.connect((AbstractButton)defaultIconButton, (Action)action);
                            defaultIconButton.putClientProperty("file", dataObject);
                            Toolbar.this.add(defaultIconButton);
                            if (dataObject != null) {
                                Toolbar.setAccelerator(action, dataObject.getPrimaryFile());
                            }
                        }
                        catch (IOException iOException) {
                            LOG.log(Level.WARNING, null, iOException);
                            var8_9 = null;
                            this.cookiesToObjects.clear();
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            LOG.log(Level.WARNING, null, classNotFoundException);
                            var8_9 = null;
                            this.cookiesToObjects.clear();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var8_9 = null;
                        this.cookiesToObjects.clear();
                        throw throwable;
                    }
                    var8_9 = null;
                    this.cookiesToObjects.clear();
                    continue;
                }
                var8_9 = null;
                this.cookiesToObjects.clear();
            }
            if (instanceCookieArray.length == 0) {
                Toolbar.this.label = new JButton("<" + Actions.cutAmpersand((String)Toolbar.this.getDisplayName()) + ">");
                Toolbar.this.add(Toolbar.this.label);
            }
            Toolbar.this.invalidate();
            return Toolbar.this;
        }

        protected Task postCreationTask(Runnable runnable) {
            return new AWTTask(runnable);
        }
    }
}

