/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import java.util.HashMap;
import java.util.Map;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyKernel;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyString;
import org.jruby.nb.RubyThread;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.internal.runtime.JumpTarget;
import org.jruby.nb.internal.runtime.methods.DefaultMethod;
import org.jruby.nb.libraries.FiberLibrary;
import org.jruby.nb.parser.BlockStaticScope;
import org.jruby.nb.parser.LocalStaticScope;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Binding;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.InterpretedBlock;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.scope.ManyVarsDynamicScope;

public final class ThreadContext {
    private static final int INITIAL_SIZE = 10;
    private static final String UNKNOWN_NAME = "(unknown)";
    private final Ruby runtime;
    private boolean isWithinTrace;
    private boolean isWithinDefined;
    private RubyThread thread;
    private FiberLibrary.Fiber fiber;
    private IRubyObject errorInfo;
    private RubyModule[] parentStack = new RubyModule[10];
    private int parentIndex = -1;
    private Frame[] frameStack = new Frame[10];
    private int frameIndex = -1;
    private DynamicScope[] scopeStack = new DynamicScope[10];
    private int scopeIndex = -1;
    private RubyKernel.CatchTarget[] catchStack = new RubyKernel.CatchTarget[10];
    private int catchIndex = -1;
    private String file = "";
    private int line = 0;
    private int rubyFrameDelta = 0;
    CallType lastCallType;
    Visibility lastVisibility;
    IRubyObject lastExitStatus;
    int calls = 0;
    public static final Map<String, FrameType> INTERPRETED_FRAMES = new HashMap<String, FrameType>();

    public static synchronized ThreadContext newContext(Ruby ruby) {
        ThreadContext threadContext = new ThreadContext(ruby);
        return threadContext;
    }

    private ThreadContext(Ruby ruby) {
        this.runtime = ruby;
        this.errorInfo = ruby.getNil();
        LocalStaticScope localStaticScope = new LocalStaticScope(null);
        this.pushScope(new ManyVarsDynamicScope(localStaticScope, null));
        for (int i = 0; i < this.frameStack.length; ++i) {
            this.frameStack[i] = new Frame();
        }
    }

    protected void finalize() throws Throwable {
        this.thread.dispose();
    }

    public final Ruby getRuntime() {
        return this.runtime;
    }

    public IRubyObject getErrorInfo() {
        return this.errorInfo;
    }

    public IRubyObject setErrorInfo(IRubyObject iRubyObject) {
        this.errorInfo = iRubyObject;
        return iRubyObject;
    }

    public JumpException.ReturnJump returnJump(IRubyObject iRubyObject) {
        return new JumpException.ReturnJump(this.getFrameJumpTarget(), iRubyObject);
    }

    public void setLastCallStatus(CallType callType) {
        this.lastCallType = callType;
    }

    public CallType getLastCallType() {
        return this.lastCallType;
    }

    public void setLastVisibility(Visibility visibility) {
        this.lastVisibility = visibility;
    }

    public Visibility getLastVisibility() {
        return this.lastVisibility;
    }

    public void setLastCallStatusAndVisibility(CallType callType, Visibility visibility) {
        this.lastCallType = callType;
        this.lastVisibility = visibility;
    }

    public IRubyObject getLastExitStatus() {
        return this.lastExitStatus;
    }

    public void setLastExitStatus(IRubyObject iRubyObject) {
        this.lastExitStatus = iRubyObject;
    }

    public void printScope() {
        System.out.println("SCOPE STACK:");
        for (int i = 0; i <= this.scopeIndex; ++i) {
            System.out.println(this.scopeStack[i]);
        }
    }

    public DynamicScope getCurrentScope() {
        return this.scopeStack[this.scopeIndex];
    }

    public DynamicScope getPreviousScope() {
        return this.scopeStack[this.scopeIndex - 1];
    }

    private void expandFramesIfNecessary() {
        int n = this.frameStack.length * 2;
        this.frameStack = this.fillNewFrameStack(new Frame[n], n);
    }

    private Frame[] fillNewFrameStack(Frame[] frameArray, int n) {
        System.arraycopy(this.frameStack, 0, frameArray, 0, this.frameStack.length);
        for (int i = this.frameStack.length; i < n; ++i) {
            frameArray[i] = new Frame();
        }
        return frameArray;
    }

    private void expandParentsIfNecessary() {
        int n = this.parentStack.length * 2;
        RubyModule[] rubyModuleArray = new RubyModule[n];
        System.arraycopy(this.parentStack, 0, rubyModuleArray, 0, this.parentStack.length);
        this.parentStack = rubyModuleArray;
    }

    public void pushScope(DynamicScope dynamicScope) {
        int n = ++this.scopeIndex;
        DynamicScope[] dynamicScopeArray = this.scopeStack;
        dynamicScopeArray[n] = dynamicScope;
        if (n + 1 == dynamicScopeArray.length) {
            this.expandScopesIfNecessary();
        }
    }

    public void popScope() {
        this.scopeStack[this.scopeIndex--] = null;
    }

    private void expandScopesIfNecessary() {
        int n = this.scopeStack.length * 2;
        DynamicScope[] dynamicScopeArray = new DynamicScope[n];
        System.arraycopy(this.scopeStack, 0, dynamicScopeArray, 0, this.scopeStack.length);
        this.scopeStack = dynamicScopeArray;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public void setThread(RubyThread rubyThread) {
        this.thread = rubyThread;
    }

    public FiberLibrary.Fiber getFiber() {
        return this.fiber;
    }

    public void setFiber(FiberLibrary.Fiber fiber) {
        this.fiber = fiber;
    }

    private void expandCatchIfNecessary() {
        int n = this.catchStack.length * 2;
        RubyKernel.CatchTarget[] catchTargetArray = new RubyKernel.CatchTarget[n];
        System.arraycopy(this.catchStack, 0, catchTargetArray, 0, this.catchStack.length);
        this.catchStack = catchTargetArray;
    }

    public void pushCatch(RubyKernel.CatchTarget catchTarget) {
        int n = ++this.catchIndex;
        RubyKernel.CatchTarget[] catchTargetArray = this.catchStack;
        catchTargetArray[n] = catchTarget;
        if (n + 1 == catchTargetArray.length) {
            this.expandCatchIfNecessary();
        }
    }

    public void popCatch() {
        --this.catchIndex;
    }

    public RubyKernel.CatchTarget[] getActiveCatches() {
        int n = this.catchIndex;
        if (n < 0) {
            return new RubyKernel.CatchTarget[0];
        }
        RubyKernel.CatchTarget[] catchTargetArray = new RubyKernel.CatchTarget[n + 1];
        System.arraycopy(this.catchStack, 0, catchTargetArray, 0, n + 1);
        return catchTargetArray;
    }

    private void pushFrameCopy() {
        int n = ++this.frameIndex;
        Frame[] frameArray = this.frameStack;
        Frame frame = frameArray[n - 1];
        frameArray[n].updateFrame(frame);
        if (n + 1 == frameArray.length) {
            this.expandFramesIfNecessary();
        }
    }

    private Frame pushFrame(Frame frame) {
        int n = ++this.frameIndex;
        Frame[] frameArray = this.frameStack;
        frameArray[n] = frame;
        if (n + 1 == frameArray.length) {
            this.expandFramesIfNecessary();
        }
        return frame;
    }

    private void pushCallFrame(RubyModule rubyModule, String string, IRubyObject iRubyObject, Block block) {
        int n = ++this.frameIndex;
        Frame[] frameArray = this.frameStack;
        frameArray[n].updateFrame(rubyModule, iRubyObject, string, block, this.file, this.line);
        if (n + 1 == frameArray.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushEvalFrame(IRubyObject iRubyObject) {
        int n = ++this.frameIndex;
        Frame[] frameArray = this.frameStack;
        frameArray[n].updateFrameForEval(iRubyObject, this.file, this.line);
        if (n + 1 == frameArray.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushBacktraceFrame(String string) {
        this.pushFrame(string);
    }

    private void pushFrame(String string) {
        int n = ++this.frameIndex;
        Frame[] frameArray = this.frameStack;
        frameArray[n].updateFrame(string, this.file, this.line);
        if (n + 1 == frameArray.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushFrame() {
        int n = ++this.frameIndex;
        Frame[] frameArray = this.frameStack;
        frameArray[n].updateFrame(this.file, this.line);
        if (n + 1 == frameArray.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void popFrame() {
        Frame frame = this.frameStack[this.frameIndex--];
        this.setFile(frame.getFile());
        this.setLine(frame.getLine());
        frame.clear();
    }

    private void popFrameReal(Frame frame) {
        int n = this.frameIndex;
        Frame frame2 = this.frameStack[n];
        this.frameStack[n] = frame;
        this.frameIndex = n - 1;
        this.setFile(frame2.getFile());
        this.setLine(frame2.getLine());
    }

    public Frame getCurrentFrame() {
        return this.frameStack[this.frameIndex];
    }

    public int getRubyFrameDelta() {
        return this.rubyFrameDelta;
    }

    public void setRubyFrameDelta(int n) {
        this.rubyFrameDelta = n;
    }

    public Frame getCurrentRubyFrame() {
        return this.frameStack[this.frameIndex - this.rubyFrameDelta];
    }

    public Frame getNextFrame() {
        int n = this.frameIndex;
        Frame[] frameArray = this.frameStack;
        if (n + 1 == frameArray.length) {
            this.expandFramesIfNecessary();
        }
        return frameArray[n + 1];
    }

    public Frame getPreviousFrame() {
        int n = this.frameIndex;
        return n < 1 ? null : this.frameStack[n - 1];
    }

    public int getFrameCount() {
        return this.frameIndex + 1;
    }

    public String getFrameName() {
        return this.getCurrentFrame().getName();
    }

    public IRubyObject getFrameSelf() {
        return this.getCurrentFrame().getSelf();
    }

    public JumpTarget getFrameJumpTarget() {
        return this.getCurrentFrame().getJumpTarget();
    }

    @Deprecated
    public void setFrameJumpTarget(JumpTarget jumpTarget) {
    }

    public RubyModule getFrameKlazz() {
        return this.getCurrentFrame().getKlazz();
    }

    public Block getFrameBlock() {
        return this.getCurrentFrame().getBlock();
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public void setFileAndLine(String string, int n) {
        this.file = string;
        this.line = n;
    }

    public Visibility getCurrentVisibility() {
        return this.getCurrentFrame().getVisibility();
    }

    public Visibility getPreviousVisibility() {
        return this.getPreviousFrame().getVisibility();
    }

    public void setCurrentVisibility(Visibility visibility) {
        this.getCurrentFrame().setVisibility(visibility);
    }

    public void pollThreadEvents() {
        this.getThread().pollThreadEvents(this);
    }

    public void callThreadPoll() {
        if ((this.calls++ & 0xFF) == 0) {
            this.pollThreadEvents();
        }
    }

    public void trace(RubyEvent rubyEvent, String string, RubyModule rubyModule) {
        this.runtime.callEventHooks(this, rubyEvent, this.file, this.line, string, rubyModule);
    }

    public void pushRubyClass(RubyModule rubyModule) {
        int n = ++this.parentIndex;
        RubyModule[] rubyModuleArray = this.parentStack;
        rubyModuleArray[n] = rubyModule;
        if (n + 1 == rubyModuleArray.length) {
            this.expandParentsIfNecessary();
        }
    }

    public RubyModule popRubyClass() {
        int n = this.parentIndex;
        RubyModule[] rubyModuleArray = this.parentStack;
        RubyModule rubyModule = rubyModuleArray[n];
        rubyModuleArray[n] = null;
        this.parentIndex = n - 1;
        return rubyModule;
    }

    public RubyModule getRubyClass() {
        assert (this.parentIndex != -1) : "Trying to get RubyClass from empty stack";
        RubyModule rubyModule = this.parentStack[this.parentIndex];
        return rubyModule.getNonIncludedClass();
    }

    public RubyModule getBindingRubyClass() {
        int n = this.parentIndex;
        RubyModule rubyModule = null;
        rubyModule = n == 0 ? this.parentStack[n] : this.parentStack[n - 1];
        return rubyModule.getNonIncludedClass();
    }

    public boolean getConstantDefined(String string) {
        for (StaticScope staticScope = this.getCurrentScope().getStaticScope(); staticScope != null; staticScope = staticScope.getPreviousCRefScope()) {
            RubyModule rubyModule = staticScope.getModule();
            IRubyObject iRubyObject = rubyModule.fastFetchConstant(string);
            if (iRubyObject == null) continue;
            if (iRubyObject != RubyObject.UNDEF) {
                return true;
            }
            return this.runtime.getLoadService().autoloadFor(rubyModule.getName() + "::" + string) != null;
        }
        return this.getCurrentScope().getStaticScope().getModule().fastIsConstantDefined(string);
    }

    public IRubyObject getConstant(String string) {
        return this.getCurrentScope().getStaticScope().getConstant(this.runtime, string, this.runtime.getObject());
    }

    public IRubyObject setConstantInCurrent(String string, IRubyObject iRubyObject) {
        RubyModule rubyModule = this.getCurrentScope().getStaticScope().getModule();
        if (rubyModule != null) {
            rubyModule.fastSetConstant(string, iRubyObject);
            return iRubyObject;
        }
        throw this.runtime.newTypeError("no class/module to define constant");
    }

    public IRubyObject setConstantInModule(String string, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (!(iRubyObject instanceof RubyModule)) {
            throw this.runtime.newTypeError(iRubyObject.toString() + " is not a class/module");
        }
        RubyModule rubyModule = (RubyModule)iRubyObject;
        rubyModule.fastSetConstant(string, iRubyObject2);
        return iRubyObject2;
    }

    public IRubyObject setConstantInObject(String string, IRubyObject iRubyObject) {
        this.runtime.getObject().fastSetConstant(string, iRubyObject);
        return iRubyObject;
    }

    @Deprecated
    private static void addBackTraceElement(RubyArray rubyArray, StackTraceElement stackTraceElement, StackTraceElement stackTraceElement2) {
        ThreadContext.addBackTraceElement(rubyArray.getRuntime(), rubyArray, stackTraceElement, stackTraceElement2);
    }

    private static void addBackTraceElement(Ruby ruby, RubyArray rubyArray, Frame frame, Frame frame2) {
        if (frame != frame2 && frame.getLine() == frame2.getLine() && frame.getName() != null && frame.getName().equals(frame2.getName()) && frame.getFile().equals(frame2.getFile())) {
            return;
        }
        RubyString rubyString = frame2.getName() != null ? RubyString.newString(ruby, frame.getFile() + ':' + (frame.getLine() + 1) + ":in `" + frame2.getName() + '\'') : RubyString.newString(ruby, frame.getFile() + ':' + (frame.getLine() + 1));
        rubyArray.append(rubyString);
    }

    private static void addBackTraceElement(Ruby ruby, RubyArray rubyArray, StackTraceElement stackTraceElement, StackTraceElement stackTraceElement2) {
        if (stackTraceElement != stackTraceElement2 && stackTraceElement.getLineNumber() == stackTraceElement2.getLineNumber() && stackTraceElement.getMethodName() != null && stackTraceElement.getMethodName().equals(stackTraceElement2.getMethodName()) && stackTraceElement.getFileName().equals(stackTraceElement2.getFileName())) {
            return;
        }
        RubyString rubyString = stackTraceElement2.getMethodName() == UNKNOWN_NAME ? RubyString.newString(ruby, stackTraceElement.getFileName() + ':' + stackTraceElement.getLineNumber()) : RubyString.newString(ruby, stackTraceElement.getFileName() + ':' + stackTraceElement.getLineNumber() + ":in `" + stackTraceElement2.getMethodName() + '\'');
        rubyArray.append(rubyString);
    }

    private static void addBackTraceElement(RubyArray rubyArray, StackTraceElement stackTraceElement, StackTraceElement stackTraceElement2, FrameType frameType) {
        if (stackTraceElement != stackTraceElement2 && stackTraceElement.getMethodName() != null && stackTraceElement.getMethodName().equals(stackTraceElement2.getMethodName()) && stackTraceElement.getFileName().equals(stackTraceElement2.getFileName()) && stackTraceElement.getLineNumber() == stackTraceElement2.getLineNumber()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(60);
        stringBuilder.append(stackTraceElement.getFileName()).append(':').append(stackTraceElement.getLineNumber());
        if (stackTraceElement2.getMethodName() != null) {
            switch (frameType) {
                case METHOD: {
                    stringBuilder.append(":in `");
                    stringBuilder.append(stackTraceElement2.getMethodName());
                    stringBuilder.append('\'');
                    break;
                }
                case BLOCK: {
                    stringBuilder.append(":in `");
                    stringBuilder.append("block in " + stackTraceElement2.getMethodName());
                    stringBuilder.append('\'');
                    break;
                }
                case EVAL: {
                    stringBuilder.append(":in `");
                    stringBuilder.append("eval in " + stackTraceElement2.getMethodName());
                    stringBuilder.append('\'');
                    break;
                }
                case CLASS: {
                    stringBuilder.append(":in `");
                    stringBuilder.append("class in " + stackTraceElement2.getMethodName());
                    stringBuilder.append('\'');
                    break;
                }
                case ROOT: {
                    stringBuilder.append(":in `<toplevel>'");
                }
            }
        }
        rubyArray.append(rubyArray.getRuntime().newString(stringBuilder.toString()));
    }

    public static IRubyObject createBacktraceFromFrames(Ruby ruby, StackTraceElement[] stackTraceElementArray) {
        return ThreadContext.createBacktraceFromFrames(ruby, stackTraceElementArray, true);
    }

    public IRubyObject createCallerBacktrace(Ruby ruby, int n) {
        int n2 = this.frameIndex - n + 1;
        RubyArray rubyArray = ruby.newArray(n2);
        for (int i = n2 - 1; i > 0; --i) {
            ThreadContext.addBackTraceElement(ruby, rubyArray, this.frameStack[i], this.frameStack[i - 1]);
        }
        return rubyArray;
    }

    public static IRubyObject createBacktraceFromFrames(Ruby ruby, StackTraceElement[] stackTraceElementArray, boolean bl) {
        RubyArray rubyArray = ruby.newArray();
        if (stackTraceElementArray == null || stackTraceElementArray.length <= 0) {
            return rubyArray;
        }
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n - 1; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            ThreadContext.addBackTraceElement(ruby, rubyArray, stackTraceElement, stackTraceElementArray[i + 1]);
        }
        return rubyArray;
    }

    public Frame[] createBacktrace(int n, boolean bl) {
        Frame[] frameArray;
        int n2 = this.frameIndex - n + 1;
        if (n2 <= 0) {
            return null;
        }
        if (bl) {
            frameArray = new Frame[n2 + 1];
            frameArray[n2] = this.frameStack[this.frameIndex];
        } else {
            frameArray = new Frame[n2];
        }
        System.arraycopy(this.frameStack, 0, frameArray, 0, n2);
        return frameArray;
    }

    public StackTraceElement[] createBacktrace2(int n, boolean bl) {
        int n2 = this.frameIndex - n + 1;
        if (n2 <= 0) {
            return null;
        }
        int n3 = n2;
        if (bl) {
            n3 = n2 + 1;
        }
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[n3];
        return this.buildTrace(stackTraceElementArray);
    }

    private StackTraceElement[] buildTrace(StackTraceElement[] stackTraceElementArray) {
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            Frame frame = this.frameStack[i];
            String string = this.getClassNameFromFrame(frame);
            String string2 = this.getMethodNameFromFrame(frame);
            stackTraceElementArray[stackTraceElementArray.length - 1 - i] = new StackTraceElement(string, string2, frame.getFile(), frame.getLine() + 1);
        }
        return stackTraceElementArray;
    }

    private String getClassNameFromFrame(Frame frame) {
        String string = frame.getKlazz() == null ? UNKNOWN_NAME : frame.getKlazz().getName();
        return string;
    }

    private String getMethodNameFromFrame(Frame frame) {
        String string = frame.getName();
        if (frame.getName() == null) {
            string = UNKNOWN_NAME;
        }
        return string;
    }

    private static String createRubyBacktraceString(StackTraceElement stackTraceElement) {
        return stackTraceElement.getClassName() + ":" + stackTraceElement.getLineNumber() + ":in `" + stackTraceElement.getMethodName() + "'";
    }

    public static String createRawBacktraceStringFromThrowable(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
            stringBuffer.append(ThreadContext.createRubyBacktraceString(stackTraceElementArray[0])).append(": ").append(throwable.toString()).append("\n");
            for (int i = 1; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                stringBuffer.append("\tfrom ").append(ThreadContext.createRubyBacktraceString(stackTraceElement));
                if (i + 1 >= stackTraceElementArray.length) continue;
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public static IRubyObject createRawBacktrace(Ruby ruby, StackTraceElement[] stackTraceElementArray, boolean bl) {
        RubyArray rubyArray = RubyArray.newArray(ruby);
        for (int i = 17; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            if (bl && stackTraceElement.getClassName().startsWith("org.jruby.nb")) continue;
            RubyString rubyString = RubyString.newString(ruby, ThreadContext.createRubyBacktraceString(stackTraceElement));
            rubyArray.append(rubyString);
        }
        return rubyArray;
    }

    public static IRubyObject createRubyCompiledBacktrace(Ruby ruby, StackTraceElement[] stackTraceElementArray) {
        RubyArray rubyArray = RubyArray.newArray(ruby);
        for (int i = 17; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            int n = stackTraceElement.getMethodName().indexOf("$RUBY$");
            if (n < 0) continue;
            String string = stackTraceElement.getMethodName().substring(n + 6);
            RubyString rubyString = RubyString.newString(ruby, stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ":in `" + string + "'");
            rubyArray.append(rubyString);
        }
        return rubyArray;
    }

    public static IRubyObject createRubyHybridBacktrace(Ruby ruby, StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2, boolean bl) {
        RubyArray rubyArray = RubyArray.newArray(ruby);
        ThreadContext threadContext = ruby.getCurrentContext();
        int n = stackTraceElementArray.length - 1;
        for (int i = 0; i < stackTraceElementArray2.length; ++i) {
            RubyString rubyString;
            Object object;
            Object object2;
            StackTraceElement stackTraceElement = stackTraceElementArray2[i];
            int n2 = stackTraceElement.getMethodName().indexOf("$RUBY$");
            if (n2 >= 0) {
                object2 = stackTraceElement.getMethodName().substring(n2 + 6);
                object = RubyString.newString(ruby, stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ":in `" + (String)object2 + "'");
                rubyArray.append((IRubyObject)object);
                if (stackTraceElement.getMethodName().contains("__rescue__") || stackTraceElement.getMethodName().contains("__ensure__")) continue;
                --n;
                continue;
            }
            if (stackTraceElement.getMethodName().equals("__file__")) {
                object2 = RubyString.newString(ruby, stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ": `<toplevel>'");
                rubyArray.append((IRubyObject)object2);
                --n;
                continue;
            }
            n2 = stackTraceElement.getClassName().indexOf("$RUBYINVOKER$");
            if (n2 >= 0) {
                object2 = stackTraceElement.getClassName().substring(n2 + 13);
                object = threadContext.frameStack[n];
                rubyString = RubyString.newString(ruby, ((Frame)object).getFile() + ":" + (((Frame)object).getLine() + 1) + ":in `" + (String)object2 + "'");
                rubyArray.append(rubyString);
                continue;
            }
            n2 = stackTraceElement.getClassName().indexOf("$RUBYFRAMEDINVOKER$");
            if (n2 >= 0) {
                ThreadContext.addBackTraceElement(rubyArray, stackTraceElementArray[n], stackTraceElementArray[n - 1], FrameType.METHOD);
                --n;
                continue;
            }
            object2 = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
            object = INTERPRETED_FRAMES.get(object2);
            if (object != null) {
                if (n == 0) {
                    ThreadContext.addBackTraceElement(rubyArray, stackTraceElementArray[n], stackTraceElementArray[n], (FrameType)((Object)object));
                    continue;
                }
                ThreadContext.addBackTraceElement(rubyArray, stackTraceElementArray[n], stackTraceElementArray[n - 1], (FrameType)((Object)object));
                --n;
                continue;
            }
            if (!bl) continue;
            rubyString = RubyString.newString(ruby, ThreadContext.createRubyBacktraceString(stackTraceElement));
            rubyArray.append(rubyString);
        }
        return rubyArray;
    }

    public void preAdoptThread() {
        this.pushFrame();
        this.pushRubyClass(this.runtime.getObject());
        this.getCurrentFrame().setSelf(this.runtime.getTopSelf());
    }

    public void preCompiledClass(RubyModule rubyModule, String[] stringArray) {
        this.pushRubyClass(rubyModule);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(rubyModule);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        LocalStaticScope localStaticScope = new LocalStaticScope(this.getCurrentScope().getStaticScope(), stringArray);
        localStaticScope.setModule(rubyModule);
        this.pushScope(new ManyVarsDynamicScope(localStaticScope, null));
    }

    public void postCompiledClass() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preScopeNode(StaticScope staticScope) {
        this.pushScope(DynamicScope.newDynamicScope(staticScope, this.getCurrentScope()));
    }

    public void postScopeNode() {
        this.popScope();
    }

    public void preClassEval(StaticScope staticScope, RubyModule rubyModule) {
        this.pushRubyClass(rubyModule);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(rubyModule);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        this.pushScope(DynamicScope.newDynamicScope(staticScope, null));
    }

    public void postClassEval() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preBsfApply(String[] stringArray) {
        LocalStaticScope localStaticScope = new LocalStaticScope(null);
        localStaticScope.setVariables(stringArray);
        this.pushFrame();
    }

    public void postBsfApply() {
        this.popFrame();
    }

    public void preMethodFrameAndScope(RubyModule rubyModule, String string, IRubyObject iRubyObject, Block block, StaticScope staticScope) {
        RubyModule rubyModule2 = staticScope.getModule();
        if (rubyModule2 == null) {
            rubyModule2 = rubyModule;
        }
        this.pushCallFrame(rubyModule, string, iRubyObject, block);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(rubyModule2);
    }

    public void postMethodFrameAndScope() {
        this.popRubyClass();
        this.popScope();
        this.popFrame();
    }

    public void preMethodFrameOnly(RubyModule rubyModule, String string, IRubyObject iRubyObject, Block block) {
        this.pushRubyClass(rubyModule);
        this.pushCallFrame(rubyModule, string, iRubyObject, block);
    }

    public void postMethodFrameOnly() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preMethodScopeOnly(RubyModule rubyModule, StaticScope staticScope) {
        RubyModule rubyModule2 = staticScope.getModule();
        if (rubyModule2 == null) {
            rubyModule2 = rubyModule;
        }
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(rubyModule2);
    }

    public void postMethodScopeOnly() {
        this.popRubyClass();
        this.popScope();
    }

    public void preMethodBacktraceAndScope(String string, RubyModule rubyModule, StaticScope staticScope) {
        this.preMethodScopeOnly(rubyModule, staticScope);
        this.pushBacktraceFrame(string);
    }

    public void postMethodBacktraceAndScope() {
        this.postMethodScopeOnly();
        this.popFrame();
    }

    public void preMethodBacktraceOnly(String string) {
        this.pushBacktraceFrame(string);
    }

    public void postMethodBacktraceOnly() {
        this.popFrame();
    }

    public void prepareTopLevel(RubyClass rubyClass, IRubyObject iRubyObject) {
        this.pushFrame();
        this.setCurrentVisibility(Visibility.PRIVATE);
        this.pushRubyClass(rubyClass);
        Frame frame = this.getCurrentFrame();
        frame.setSelf(iRubyObject);
        this.getCurrentScope().getStaticScope().setModule(rubyClass);
    }

    public void preNodeEval(RubyModule rubyModule, IRubyObject iRubyObject, String string) {
        this.pushRubyClass(rubyModule);
        this.pushEvalFrame(iRubyObject);
    }

    public void preNodeEval(RubyModule rubyModule, IRubyObject iRubyObject) {
        this.pushRubyClass(rubyModule);
        this.pushEvalFrame(iRubyObject);
    }

    public void postNodeEval() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preExecuteUnder(RubyModule rubyModule, Block block) {
        Frame frame = this.getCurrentFrame();
        this.pushRubyClass(rubyModule);
        DynamicScope dynamicScope = this.getCurrentScope();
        BlockStaticScope blockStaticScope = new BlockStaticScope(dynamicScope.getStaticScope());
        blockStaticScope.setModule(rubyModule);
        this.pushScope(DynamicScope.newDynamicScope(blockStaticScope, dynamicScope));
        this.pushCallFrame(frame.getKlazz(), frame.getName(), frame.getSelf(), block);
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postExecuteUnder() {
        this.popFrame();
        this.popScope();
        this.popRubyClass();
    }

    public void preMproc() {
        this.pushFrame();
    }

    public void postMproc() {
        this.popFrame();
    }

    public void preRunThread(Frame frame) {
        this.pushFrame(frame);
    }

    public void preTrace() {
        this.setWithinTrace(true);
        this.pushFrame();
    }

    public void postTrace() {
        this.popFrame();
        this.setWithinTrace(false);
    }

    public Frame preForBlock(Binding binding, RubyModule rubyModule) {
        Frame frame = this.getNextFrame();
        Frame frame2 = binding.getFrame();
        frame2.setFile(this.file);
        frame2.setLine(this.line);
        this.pushFrame(frame2);
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushScope(binding.getDynamicScope());
        this.pushRubyClass(rubyModule != null ? rubyModule : binding.getKlass());
        return frame;
    }

    public Frame preYieldSpecificBlock(Binding binding, StaticScope staticScope, RubyModule rubyModule) {
        Frame frame = this.getNextFrame();
        Frame frame2 = this.pushFrame(binding.getFrame());
        frame2.setFile(this.file);
        frame2.setLine(this.line);
        frame2.setVisibility(binding.getVisibility());
        this.pushScope(DynamicScope.newDynamicScope(staticScope, binding.getDynamicScope()));
        this.pushRubyClass(rubyModule != null ? rubyModule : binding.getKlass());
        return frame;
    }

    public Frame preYieldLightBlock(Binding binding, DynamicScope dynamicScope, RubyModule rubyModule) {
        Frame frame = this.getNextFrame();
        Frame frame2 = this.pushFrame(binding.getFrame());
        frame2.setFile(this.file);
        frame2.setLine(this.line);
        frame2.setVisibility(binding.getVisibility());
        this.pushScope(dynamicScope);
        this.pushRubyClass(rubyModule != null ? rubyModule : binding.getKlass());
        return frame;
    }

    public Frame preYieldNoScope(Binding binding, RubyModule rubyModule) {
        Frame frame = this.getNextFrame();
        Frame frame2 = this.pushFrame(binding.getFrame());
        frame2.setFile(this.file);
        frame2.setLine(this.line);
        frame2.setVisibility(binding.getVisibility());
        this.pushRubyClass(rubyModule != null ? rubyModule : binding.getKlass());
        return frame;
    }

    public Frame preEvalWithBinding(Binding binding) {
        Frame frame = this.getNextFrame();
        Frame frame2 = binding.getFrame();
        frame2.setIsBindingFrame(true);
        this.pushFrame(frame2);
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushRubyClass(binding.getKlass());
        return frame;
    }

    public void postEvalWithBinding(Binding binding, Frame frame) {
        binding.getFrame().setIsBindingFrame(false);
        this.popFrameReal(frame);
        this.popRubyClass();
    }

    public void postYield(Binding binding, Frame frame) {
        this.popScope();
        this.popFrameReal(frame);
        this.popRubyClass();
    }

    public void postYieldLight(Binding binding, Frame frame) {
        this.popScope();
        this.popFrameReal(frame);
        this.popRubyClass();
    }

    public void postYieldNoScope(Frame frame) {
        this.popFrameReal(frame);
        this.popRubyClass();
    }

    public void preScopedBody(DynamicScope dynamicScope) {
        this.pushScope(dynamicScope);
    }

    public void postScopedBody() {
        this.popScope();
    }

    public boolean isWithinTrace() {
        return this.isWithinTrace;
    }

    public void setWithinTrace(boolean bl) {
        this.isWithinTrace = bl;
    }

    public boolean isWithinDefined() {
        return this.isWithinDefined;
    }

    public void setWithinDefined(boolean bl) {
        this.isWithinDefined = bl;
    }

    static {
        INTERPRETED_FRAMES.put(DefaultMethod.class.getName() + ".interpretedCall", FrameType.METHOD);
        INTERPRETED_FRAMES.put(InterpretedBlock.class.getName() + ".evalBlockBody", FrameType.BLOCK);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".evalWithBinding", FrameType.EVAL);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".evalSimple", FrameType.EVAL);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".evalClassDefinitionBody", FrameType.CLASS);
        INTERPRETED_FRAMES.put(Ruby.class.getName() + ".runInterpreter", FrameType.ROOT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FrameType {
        METHOD,
        BLOCK,
        EVAL,
        CLASS,
        ROOT;

    }
}

