/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import org.jruby.nb.Ruby;
import org.jruby.nb.runtime.CompiledBlockCallback;
import org.jruby.nb.runtime.callback.Callback;
import org.jruby.nb.runtime.callback.DumpingInvocationCallbackFactory;
import org.jruby.nb.runtime.callback.InvocationCallbackFactory;
import org.jruby.nb.runtime.callback.ReflectionCallbackFactory;
import org.jruby.nb.util.SafePropertyAccessor;

public abstract class CallbackFactory {
    public static final Class[] NULL_CLASS_ARRAY = new Class[0];
    private static final boolean reflection;
    private static final boolean dumping;

    public abstract Callback getMethod(String var1);

    public abstract Callback getFastMethod(String var1);

    public abstract Callback getMethod(String var1, Class var2);

    public abstract Callback getFastMethod(String var1, Class var2);

    public abstract Callback getMethod(String var1, Class var2, Class var3);

    public abstract Callback getFastMethod(String var1, Class var2, Class var3);

    public abstract Callback getMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getFastMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getSingletonMethod(String var1);

    public abstract Callback getFastSingletonMethod(String var1);

    public abstract Callback getSingletonMethod(String var1, Class var2);

    public abstract Callback getFastSingletonMethod(String var1, Class var2);

    public abstract Callback getSingletonMethod(String var1, Class var2, Class var3);

    public abstract Callback getFastSingletonMethod(String var1, Class var2, Class var3);

    public abstract Callback getSingletonMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getFastSingletonMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getBlockMethod(String var1);

    public abstract CompiledBlockCallback getBlockCallback(String var1, Object var2);

    public abstract Callback getOptSingletonMethod(String var1);

    public abstract Callback getFastOptSingletonMethod(String var1);

    public abstract Callback getOptMethod(String var1);

    public abstract Callback getFastOptMethod(String var1);

    public static CallbackFactory createFactory(Ruby ruby, Class clazz) {
        return CallbackFactory.createFactory(ruby, clazz, ruby.getJRubyClassLoader());
    }

    public static CallbackFactory createFactory(Ruby ruby, Class clazz, ClassLoader classLoader) {
        if (reflection) {
            return new ReflectionCallbackFactory(clazz);
        }
        if (dumping) {
            return new DumpingInvocationCallbackFactory(ruby, clazz, classLoader);
        }
        return new InvocationCallbackFactory(ruby, clazz, classLoader);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        if (Ruby.isSecurityRestricted()) {
            bl = true;
        } else {
            if (SafePropertyAccessor.getProperty("jruby.reflection") != null && SafePropertyAccessor.getBoolean("jruby.reflection")) {
                bl = true;
            }
            if (SafePropertyAccessor.getProperty("jruby.dump_invocations") != null) {
                bl2 = true;
            }
        }
        reflection = bl;
        dumping = bl2;
    }
}

