/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.javasupport.JavaAccessibleObject;
import org.jruby.nb.javasupport.JavaClass;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"Java::JavaField"})
public class JavaField
extends JavaAccessibleObject {
    private Field field;

    public Object getValue() {
        return this.field;
    }

    public static RubyClass createJavaFieldClass(Ruby ruby, RubyModule rubyModule) {
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaField", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaAccessibleObject.registerRubyMethods(ruby, rubyClass);
        rubyClass.defineAnnotatedMethods(JavaField.class);
        return rubyClass;
    }

    public JavaField(Ruby ruby, Field field) {
        super(ruby, ruby.getJavaSupport().getJavaFieldClass());
        this.field = field;
    }

    public boolean equals(Object object) {
        return object instanceof JavaField && this.field == ((JavaField)object).field;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    @JRubyMethod
    public RubyString value_type() {
        return this.getRuntime().newString(this.field.getType().getName());
    }

    @JRubyMethod(name={"==", "==="})
    public IRubyObject op_equal(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaField)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().newBoolean(this.field.equals(((JavaField)iRubyObject).field));
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.field.getModifiers()));
    }

    @JRubyMethod(name={"static?"})
    public RubyBoolean static_p() {
        return this.getRuntime().newBoolean(Modifier.isStatic(this.field.getModifiers()));
    }

    @JRubyMethod(name={"enum_constant?"})
    public RubyBoolean enum_constant_p() {
        return this.getRuntime().newBoolean(this.field.isEnumConstant());
    }

    @JRubyMethod
    public RubyString to_generic_string() {
        return this.getRuntime().newString(this.field.toGenericString());
    }

    @JRubyMethod(name={"type"})
    public IRubyObject field_type() {
        return JavaClass.get(this.getRuntime(), this.field.getType());
    }

    @JRubyMethod
    public IRubyObject value(IRubyObject iRubyObject) {
        Object object = JavaUtil.unwrapJavaValue(this.getRuntime(), iRubyObject, "not a java object");
        try {
            return JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), this.field.get(object));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.getRuntime().newTypeError("illegal access");
        }
    }

    @JRubyMethod
    public IRubyObject set_value(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Object object = JavaUtil.unwrapJavaValue(this.getRuntime(), iRubyObject, "not a java object: " + iRubyObject);
        IRubyObject iRubyObject3 = iRubyObject2;
        if (iRubyObject3.dataGetStruct() instanceof JavaObject) {
            iRubyObject3 = (IRubyObject)iRubyObject3.dataGetStruct();
        }
        try {
            Object object2 = JavaUtil.convertArgumentToType(iRubyObject3.getRuntime().getCurrentContext(), iRubyObject3, this.field.getType());
            this.field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.getRuntime().newTypeError("illegal access on setting variable: " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.getRuntime().newTypeError("wrong type for " + this.field.getType().getName() + ": " + iRubyObject3.getClass().getName());
        }
        return iRubyObject3;
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.field.getModifiers()));
    }

    @JRubyMethod
    public JavaObject static_value() {
        try {
            if (!Ruby.isSecurityRestricted()) {
                this.field.setAccessible(true);
            }
            return JavaObject.wrap(this.getRuntime(), this.field.get(null));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.getRuntime().newTypeError("illegal static value access: " + illegalAccessException.getMessage());
        }
    }

    @JRubyMethod
    public JavaObject set_static_value(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + iRubyObject);
        }
        try {
            Object object = JavaUtil.convertArgument(this.getRuntime(), ((JavaObject)iRubyObject).getValue(), this.field.getType());
            this.field.set(null, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.getRuntime().newTypeError("illegal access on setting static variable: " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.getRuntime().newTypeError("wrong type for " + this.field.getType().getName() + ": " + ((JavaObject)iRubyObject).getValue().getClass().getName());
        }
        return (JavaObject)iRubyObject;
    }

    @JRubyMethod
    public RubyString name() {
        return this.getRuntime().newString(this.field.getName());
    }

    protected AccessibleObject accessibleObject() {
        return this.field;
    }
}

