/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import java.lang.reflect.Array;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyModule;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"Java::JavaArray"}, parent="Java::JavaObject")
public class JavaArray
extends JavaObject {
    private JavaUtil.RubyConverter rubyConverter;

    public JavaArray(Ruby ruby, Object object) {
        super(ruby, ruby.getJavaSupport().getJavaArrayClass(), object);
        assert (object.getClass().isArray());
        this.rubyConverter = JavaUtil.getArrayConverter(object.getClass().getComponentType());
    }

    public static RubyClass createJavaArrayClass(Ruby ruby, RubyModule rubyModule) {
        return rubyModule.defineClassUnder("JavaArray", rubyModule.fastGetClass("JavaObject"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
    }

    public Class getComponentType() {
        return this.getValue().getClass().getComponentType();
    }

    public JavaUtil.RubyConverter getRubyConverter() {
        return this.rubyConverter;
    }

    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.getLength());
    }

    private int getLength() {
        return Array.getLength(this.getValue());
    }

    public boolean equals(Object object) {
        return object instanceof JavaArray && this.getValue() == ((JavaArray)object).getValue();
    }

    public IRubyObject aref(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getInteger());
        }
        int n = (int)((RubyInteger)iRubyObject).getLongValue();
        if (n < 0 || n >= this.getLength()) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + n + " for length " + this.getLength() + ")");
        }
        Object object = Array.get(this.getValue(), n);
        if (object == null) {
            return this.getRuntime().getNil();
        }
        return JavaObject.wrap(this.getRuntime(), object);
    }

    public IRubyObject at(int n) {
        Object object = Array.get(this.getValue(), n);
        if (object == null) {
            return this.getRuntime().getNil();
        }
        return JavaObject.wrap(this.getRuntime(), object);
    }

    public IRubyObject aset(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (!(iRubyObject instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getInteger());
        }
        int n = (int)((RubyInteger)iRubyObject).getLongValue();
        if (!(iRubyObject2 instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + iRubyObject2);
        }
        Object object = ((JavaObject)iRubyObject2).getValue();
        this.setWithExceptionHandling(n, object);
        return iRubyObject2;
    }

    public void setWithExceptionHandling(int n, Object object) {
        try {
            Array.set(this.getValue(), n, object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + n + " for length " + this.getLength() + ")");
        }
        catch (ArrayStoreException arrayStoreException) {
            throw this.getRuntime().newArgumentError("wrong element type " + object.getClass() + "(array is " + this.getValue().getClass() + ")");
        }
    }

    public IRubyObject afill(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        if (!(iRubyObject instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getInteger());
        }
        int n = (int)((RubyInteger)iRubyObject).getLongValue();
        if (!(iRubyObject2 instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(iRubyObject2, this.getRuntime().getInteger());
        }
        int n2 = (int)((RubyInteger)iRubyObject2).getLongValue();
        if (!(iRubyObject3 instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + iRubyObject3);
        }
        Object object = ((JavaObject)iRubyObject3).getValue();
        this.fillWithExceptionHandling(n, n2, object);
        return iRubyObject3;
    }

    public void fillWithExceptionHandling(int n, int n2, Object object) {
        try {
            while (n < n2) {
                Array.set(this.getValue(), n, object);
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + n + " for length " + this.getLength() + ")");
        }
        catch (ArrayStoreException arrayStoreException) {
            throw this.getRuntime().newArgumentError("wrong element type " + object.getClass() + "(array is " + this.getValue().getClass() + ")");
        }
    }
}

