/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyMatchData;
import org.jruby.nb.RubyRegexp;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NthRefNode
extends Node {
    private final int matchNumber;

    public NthRefNode(ISourcePosition iSourcePosition, int n) {
        super(iSourcePosition, NodeType.NTHREFNODE);
        this.matchNumber = n;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitNthRefNode(this);
    }

    public int getMatchNumber() {
        return this.matchNumber;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return RubyRegexp.nth_match(this.matchNumber, threadContext.getCurrentFrame().getBackRef());
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = threadContext.getCurrentFrame().getBackRef();
        if (iRubyObject2 instanceof RubyMatchData) {
            ((RubyMatchData)iRubyObject2).use();
            if (!((RubyMatchData)iRubyObject2).group(this.matchNumber).isNil()) {
                return "$" + this.matchNumber;
            }
        }
        return null;
    }
}

