/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.IterNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.SharedScopeBlock;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForNode
extends IterNode {
    public final CallSite callAdapter = MethodIndex.getCallSite("each");
    private Node iterNode;

    public ForNode(ISourcePosition iSourcePosition, Node node, Node node2, Node node3) {
        super(iSourcePosition, node, null, node2, NodeType.FORNODE);
        assert (node3 != null) : "iterNode is not null";
        this.iterNode = node3;
    }

    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitForNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.getVarNode(), this.getBodyNode(), this.iterNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Block block2 = SharedScopeBlock.newInterpretedSharedScopeClosure(threadContext, this, threadContext.getCurrentScope(), iRubyObject);
        try {
            while (true) {
                try {
                    String string = threadContext.getFile();
                    int n = threadContext.getLine();
                    IRubyObject iRubyObject2 = null;
                    try {
                        iRubyObject2 = this.iterNode.interpret(ruby, threadContext, iRubyObject, block);
                    }
                    finally {
                        threadContext.setFile(string);
                        threadContext.setLine(n);
                    }
                    return this.callAdapter.call(threadContext, iRubyObject2, block2);
                }
                catch (JumpException.RetryJump retryJump) {
                    continue;
                }
                break;
            }
        }
        catch (JumpException.BreakJump breakJump) {
            return (IRubyObject)breakJump.getValue();
        }
    }
}

