/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import org.jruby.nb.Ruby;
import org.jruby.nb.ast.ListNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.ILiteralNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ArrayNode
extends ListNode
implements ILiteralNode {
    private boolean lightweight = false;

    public ArrayNode(ISourcePosition iSourcePosition, Node node) {
        super(iSourcePosition, NodeType.ARRAYNODE, node);
        assert (node != null) : "ArrayNode.first == null";
    }

    public ArrayNode(ISourcePosition iSourcePosition) {
        super(iSourcePosition, NodeType.ARRAYNODE);
    }

    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitArrayNode(this);
    }

    public void setLightweight(boolean bl) {
        this.lightweight = bl;
    }

    public boolean isLightweight() {
        return this.lightweight;
    }

    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject[] iRubyObjectArray = this.interpretPrimitive(ruby, threadContext, iRubyObject, block);
        return this.lightweight ? ruby.newArrayNoCopyLight(iRubyObjectArray) : ruby.newArrayNoCopy(iRubyObjectArray);
    }

    public IRubyObject[] interpretPrimitive(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        int n = this.size();
        IRubyObject[] iRubyObjectArray = new IRubyObject[n];
        for (int i = 0; i < n; ++i) {
            iRubyObjectArray[i] = this.get(i).interpret(ruby, threadContext, iRubyObject, block);
        }
        return iRubyObjectArray;
    }
}

